/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudProps;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResource;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.util.Assert;

final class CrudHelper1 {
    private CrudHelper1() {
    }

    public static CrudRequest getRequest(CrudHandler handler, byte[] data) {
        JsonNode stacks;
        JsonNode value;
        JsonNode loads;
        JsonNode fields;
        JsonNode orders;
        JsonNode jid;
        Integer replica;
        Assert.notNull((Object)handler, (String)"CrudHandler is required");
        CrudResource resource = handler.getCrudResource();
        Assert.notNull((Object)resource, (String)"CrudResource is required");
        EntityTrxManager entityTrxManager = handler.getEntityTrxManager();
        Assert.notNull((Object)entityTrxManager, (String)"EntityTrxManager is required");
        JsonNode root = CrudHelper0.readValue(data);
        String manager = CrudHelper0.getStringValue(root, "manager", "");
        TrxManagerInfo trxManagerInfo = entityTrxManager.getDefaultTrxManagerInfo();
        if (!manager.isEmpty()) {
            trxManagerInfo = entityTrxManager.getTrxManagerInfo(manager);
            Assert.notNull((Object)trxManagerInfo, (String)("Manager is not found, manager: " + manager));
        }
        String name = CrudHelper0.getStringValue(root, "name", "");
        CrudProps props = resource.getCrudProps(trxManagerInfo.getName(), name);
        Assert.notNull((Object)props, (String)("CrudProps is not found, name: " + name));
        EntityInfo entityInfo = props.getEntityInfo();
        Assert.notNull((Object)entityInfo, (String)("EntityInfo is not found, name: " + name));
        CrudRequest request = CrudRequest.of(entityInfo);
        request.setManager(trxManagerInfo.getName());
        request.setName(name);
        String sreplica = CrudHelper0.getStringValue(root, "replica", "").trim();
        if (!sreplica.isEmpty() && (replica = Integer.valueOf(sreplica)) > 0) {
            request.setReplica(replica);
            request.setUseNative(Boolean.TRUE);
        }
        if ((jid = CrudHelper0.getNodeValue(root, "id")) != null) {
            Object id = CrudHelper0.idFromNode(entityInfo, jid);
            request.setIds(new ArrayList<Object>());
            request.getIds().add(id);
        } else {
            JsonNode jids = CrudHelper0.getNodeValue(root, "ids");
            if (jids != null && jids.isArray()) {
                request.setIds(new ArrayList<Object>());
                for (JsonNode item : jids) {
                    request.getIds().add(CrudHelper0.idFromNode(entityInfo, item));
                }
            }
        }
        CrudRequest.MapConfig cfgmap = new CrudRequest.MapConfig();
        cfgmap.setFlat(Boolean.TRUE);
        JsonNode map = CrudHelper0.getNodeValue(root, "map");
        if (map != null && map.isObject()) {
            String key;
            String flat = CrudHelper0.getStringValue(map, "flat", "").trim().toLowerCase();
            if (!flat.isEmpty()) {
                cfgmap.setFlat(!"0".equals(flat) && !"false".equals(flat));
            }
            if (!(key = CrudHelper0.getStringValue(map, "key", "")).isEmpty()) {
                cfgmap.setKeys(new ArrayList<String>());
                cfgmap.getKeys().add(key);
            } else {
                JsonNode keys = CrudHelper0.getNodeValue(map, "keys");
                if (keys != null && keys.isArray()) {
                    cfgmap.setKeys(new ArrayList<String>());
                    for (JsonNode jkey : keys) {
                        cfgmap.getKeys().add(jkey.asText());
                    }
                }
            }
        }
        request.setMap(cfgmap);
        JsonNode page = CrudHelper0.getNodeValue(root, "page");
        if (page != null && page.isObject()) {
            request.setPage(CrudHelper0.nodeToObject(page, Page.class));
        } else {
            String limit;
            String start = CrudHelper0.getStringValue(root, "start", "").trim();
            if (!start.isEmpty()) {
                request.setStart(Integer.valueOf(start));
            }
            if (!(limit = CrudHelper0.getStringValue(root, "limit", "").trim()).isEmpty()) {
                request.setLimit(Integer.valueOf(limit));
            }
        }
        JsonNode filters = CrudHelper0.getNodeValue(root, "filters");
        if (filters != null && filters.isArray()) {
            request.setFilters(CrudHelper0.nodeToFilter(filters));
        }
        if ((orders = CrudHelper0.getNodeValue(root, "orders")) != null && orders.isArray()) {
            request.setOrders(CrudHelper0.nodeToStringList(orders));
        }
        if ((fields = CrudHelper0.getNodeValue(root, "fields")) != null && fields.isArray()) {
            request.setFields(CrudHelper0.nodeToStringList(fields));
        }
        if (!Boolean.FALSE.equals(props.getEnableLoad()) && (loads = CrudHelper0.getNodeValue(root, "loads")) != null && loads.isArray()) {
            request.setLoads(CrudHelper0.nodeToStringList(loads));
        }
        if ((value = CrudHelper0.getNodeValue(root, "value")) != null && value.isObject()) {
            request.setValues(new ArrayList<MapStringObject>());
            request.getValues().add(CrudHelper0.nodeToValue(value));
        } else {
            JsonNode values = CrudHelper0.getNodeValue(root, "values");
            if (values != null && values.isArray()) {
                request.setValues(new ArrayList<MapStringObject>());
                for (JsonNode item : values) {
                    request.getValues().add(CrudHelper0.nodeToValue(item));
                }
            }
        }
        JsonNode joins = CrudHelper0.getNodeValue(root, "joins");
        if (joins != null && joins.isArray()) {
            request.setJoins(new ArrayList<Join>());
            for (JsonNode item : joins) {
                Join join = CrudHelper0.getJoin(resource, entityInfo, item);
                request.getJoins().add(join);
                if (join.getReplica() == null || join.getReplica() <= 0) continue;
                request.setUseNative(Boolean.TRUE);
            }
        }
        if (!Boolean.FALSE.equals(props.getEnableStack()) && (stacks = CrudHelper0.getNodeValue(root, "stacks")) != null && stacks.isArray()) {
            request.setStacks(new ArrayList<Stack>());
            for (JsonNode item : stacks) {
                Stack stack = CrudHelper0.getStack(resource, entityInfo, item);
                request.getStacks().add(stack);
                if (stack.getReplica() == null || stack.getReplica() <= 0) continue;
                request.setUseNative(Boolean.TRUE);
            }
        }
        return props.setToRequest(request);
    }

    public static CrudRequest getRequest(CrudHandler handler) {
        String page;
        String sid;
        Integer replica;
        String sreplica;
        HttpServletRequest http = RequestContext.currentContext().getRequest();
        if (http == null) {
            return null;
        }
        Assert.notNull((Object)handler, (String)"CrudHandler is required");
        CrudResource resource = handler.getCrudResource();
        Assert.notNull((Object)resource, (String)"CrudHandler.Resource is required");
        EntityTrxManager entityTrxManager = handler.getEntityTrxManager();
        Assert.notNull((Object)entityTrxManager, (String)"EntityTrxManager is required");
        String manager = http.getParameter("manager");
        TrxManagerInfo trxManagerInfo = entityTrxManager.getDefaultTrxManagerInfo();
        if (!manager.isEmpty()) {
            trxManagerInfo = entityTrxManager.getTrxManagerInfo(manager);
            Assert.notNull((Object)trxManagerInfo, (String)("Manager is not found: " + manager));
        }
        String name = http.getParameter("name");
        Assert.hasLength((String)name, (String)"Name is required");
        CrudProps props = resource.getCrudProps(trxManagerInfo.getName(), name);
        Assert.notNull((Object)props, (String)("CrudProps is not found, name: " + name));
        EntityInfo entityInfo = props.getEntityInfo();
        Assert.notNull((Object)entityInfo, (String)("EntityInfo is not found, name: " + name));
        CrudRequest request = CrudRequest.of(entityInfo);
        request.setManager(trxManagerInfo.getName());
        request.setName(name);
        String string = sreplica = http.getParameter("replica") != null ? http.getParameter("replica").trim() : "";
        if (!sreplica.isEmpty() && (replica = Integer.valueOf(sreplica)) > 0) {
            request.setReplica(replica);
            request.setUseNative(Boolean.TRUE);
        }
        if ((sid = http.getParameter("id")) != null) {
            Object id = CrudHelper0.idFromString(entityInfo, sid);
            if (id != null) {
                request.setIds(new ArrayList<Object>());
                request.getIds().add(id);
            }
        } else {
            String[] sids = http.getParameterValues("ids");
            if (sids != null) {
                request.setIds(new ArrayList<Object>());
                for (String cid : sids) {
                    Object id = CrudHelper0.idFromString(entityInfo, cid);
                    if (id == null) continue;
                    request.getIds().add(id);
                }
            }
        }
        String smap = http.getParameter("map");
        if (smap != null) {
            String[] ss;
            CrudRequest.MapConfig map = new CrudRequest.MapConfig();
            for (String s : ss = smap.split("~~")) {
                int idx = s.indexOf(":");
                if (idx == -1) continue;
                String key = s.substring(0, idx).trim();
                String str = s.substring(idx + 1);
                if ("key".equals(key)) {
                    map.setKeys(new ArrayList<String>());
                    map.getKeys().add(str);
                    continue;
                }
                if ("keys".equals(key)) {
                    map.setKeys(CrudHelper0.stringToList(str));
                    continue;
                }
                if (!"flat".equals(key)) continue;
                String lcase = str.trim().toLowerCase();
                map.setFlat(!"0".equals(lcase) && !"false".equals(lcase));
            }
        }
        if ((page = http.getParameter("page")) != null) {
            request.setPage(CrudHelper0.stringToPage(page));
        } else {
            String limit;
            String start = http.getParameter("start");
            if (start != null && !(start = start.trim()).isEmpty()) {
                request.setStart(Integer.valueOf(start));
            }
            if ((limit = http.getParameter("limit")) != null && !(limit = limit.trim()).isEmpty()) {
                request.setLimit(Integer.valueOf(limit));
            }
        }
        request.setFilters(CrudHelper0.stringToFilters(http.getParameter("filters")));
        request.setOrders(CrudHelper0.stringToList(http.getParameter("orders")));
        request.setFields(CrudHelper0.stringToList(http.getParameter("fields")));
        if (!Boolean.FALSE.equals(props.getEnableLoad())) {
            request.setLoads(CrudHelper0.stringToList(http.getParameter("loads")));
        }
        MapStringObject value = CrudHelper0.stringToMap(http.getParameter("value"));
        request.setValues(new ArrayList<MapStringObject>());
        request.getValues().add(value);
        return props.setToRequest(request);
    }

    public static Object getId(CrudRequest request) {
        List<Object> ids = request.getIds();
        if (ids != null && !ids.isEmpty()) {
            if (ids.size() != 1) {
                throw FrameworkUtil.exception("Multiple ID not allowed");
            }
            return ids.get(0);
        }
        return null;
    }

    public static void setId(CrudRequest request, Object entity) {
        Object idValue = CrudHelper1.getId(request);
        if (idValue != null) {
            try {
                EntityInfo entityInfo = request.getEntityInfo();
                IdInfo idInfo = entityInfo.getIdInfo();
                if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                    for (String name : idInfo.getFields()) {
                        FieldInfo fieldInfo = entityInfo.getFieldInfo(name);
                        fieldInfo.setValue(entity, fieldInfo.getValue(idValue));
                    }
                } else {
                    FieldInfo fieldInfo = entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                    fieldInfo.setValue(entity, idValue);
                }
            }
            catch (Exception e) {
                throw FrameworkUtil.exception(e);
            }
        }
    }

    public static MapStringObject getValue(CrudRequest request) {
        List<MapStringObject> values = request.getValues();
        return values != null && !values.isEmpty() ? values.get(0) : null;
    }
}

