/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Join;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import org.springframework.util.Assert;

public class CrudRequest {
    private String manager;
    private String name;
    private Integer replica;
    private List<Object> ids;
    private MapConfig map;
    private Page page;
    private Integer start;
    private Integer limit;
    private List<Filter> filters;
    private List<String> orders;
    private List<String> fields;
    private List<String> loads;
    private List<MapStringObject> values;
    private List<Join> joins;
    private List<Stack> stacks;
    @JsonIgnore
    private Boolean useNative;
    @JsonIgnore
    private Integer maxLimit;
    @JsonIgnore
    private List<Filter> spesifics;
    @JsonIgnore
    private EntityInfo entityInfo;

    private CrudRequest() {
    }

    public CrudRequest setManager(String manager) {
        this.manager = manager;
        return this;
    }

    public CrudRequest setName(String name) {
        this.name = name;
        return this;
    }

    public CrudRequest setReplica(Integer replica) {
        this.replica = replica;
        return this;
    }

    public CrudRequest setIds(List<Object> ids) {
        this.ids = ids;
        return this;
    }

    protected CrudRequest setMap(MapConfig map) {
        this.map = map;
        return this;
    }

    public CrudRequest setPage(Page page) {
        this.page = page;
        return this;
    }

    public CrudRequest setStart(Integer start) {
        this.start = start;
        return this;
    }

    public CrudRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public CrudRequest setFilters(List<Filter> filters) {
        this.filters = filters;
        return this;
    }

    public CrudRequest setOrders(List<String> orders) {
        this.orders = orders;
        return this;
    }

    public CrudRequest setFields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public CrudRequest setLoads(List<String> loads) {
        this.loads = loads;
        return this;
    }

    public CrudRequest setValues(List<MapStringObject> values) {
        this.values = values;
        return this;
    }

    public CrudRequest setJoins(List<Join> joins) {
        this.joins = joins;
        return this;
    }

    public CrudRequest setStacks(List<Stack> stacks) {
        this.stacks = stacks;
        return this;
    }

    public CrudRequest setUseNative(Boolean useNative) {
        this.useNative = useNative;
        return this;
    }

    public CrudRequest setMaxLimit(Integer maxLimit) {
        this.maxLimit = maxLimit;
        return this;
    }

    public CrudRequest setSpesifics(List<Filter> spesifics) {
        this.spesifics = spesifics;
        return this;
    }

    protected CrudRequest setEntityInfo(EntityInfo entityInfo) {
        this.entityInfo = entityInfo;
        return this;
    }

    public static CrudRequest of(EntityInfo entityInfo) {
        Assert.notNull((Object)entityInfo, (String)"EntityInfo is required");
        return new CrudRequest().setEntityInfo(entityInfo);
    }

    protected static CrudRequest of(String name) {
        Assert.hasLength((String)name, (String)"Name is required");
        return new CrudRequest().setName(name);
    }

    public static CrudRequest copy(CrudRequest request) {
        CrudRequest creq;
        block8: {
            int i;
            creq = CrudHelper0.copy(request, CrudRequest.class);
            creq.setUseNative(request.getUseNative());
            creq.setMaxLimit(request.getMaxLimit());
            creq.setEntityInfo(request.getEntityInfo());
            if (creq.getJoins() != null) {
                for (i = 0; i < creq.getJoins().size(); ++i) {
                    creq.getJoins().get(i).setEntityInfo(request.getJoins().get(i).getEntityInfo());
                }
            }
            if (creq.getStacks() != null) {
                for (i = 0; i < creq.getStacks().size(); ++i) {
                    Stack stack = creq.getStacks().get(i);
                    stack.setEntityInfo(request.getStacks().get(i).getEntityInfo());
                }
            }
            if (creq.getIds() == null || creq.getEntityInfo() == null) break block8;
            IdInfo idInfo = creq.getEntityInfo().getIdInfo();
            if (EntityIdType.COMPOSITE.equals((Object)idInfo.getIdType())) {
                for (int i2 = 0; i2 < creq.getIds().size(); ++i2) {
                    creq.getIds().set(i2, CrudHelper0.convert(creq.getIds().get(i2), creq.getEntityInfo().getEntityClass()));
                }
            } else {
                FieldInfo fieldInfo = creq.getEntityInfo().getFieldInfo(idInfo.getFields().iterator().next());
                for (int i3 = 0; i3 < creq.getIds().size(); ++i3) {
                    creq.getIds().set(i3, CrudHelper0.convert(creq.getIds().get(i3), fieldInfo.getType()));
                }
            }
        }
        return creq;
    }

    public String getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public Integer getReplica() {
        return this.replica;
    }

    public List<Object> getIds() {
        return this.ids;
    }

    public MapConfig getMap() {
        return this.map;
    }

    public Page getPage() {
        return this.page;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<String> getOrders() {
        return this.orders;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public List<String> getLoads() {
        return this.loads;
    }

    public List<MapStringObject> getValues() {
        return this.values;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public List<Stack> getStacks() {
        return this.stacks;
    }

    public Boolean getUseNative() {
        return this.useNative;
    }

    public Integer getMaxLimit() {
        return this.maxLimit;
    }

    public List<Filter> getSpesifics() {
        return this.spesifics;
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public static final class MapConfig {
        private List<String> keys;
        private Boolean flat;

        public void setKeys(List<String> keys) {
            this.keys = keys;
        }

        public void setFlat(Boolean flat) {
            this.flat = flat;
        }

        public List<String> getKeys() {
            return this.keys;
        }

        public Boolean getFlat() {
            return this.flat;
        }
    }
}

