/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.Arrays;
import java.util.List;
import net.ideahut.springboot.crud.CrudConstant;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudHelper1;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.crud.CrudUpdate;
import net.ideahut.springboot.crud.CrudUpdateNative0;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.EntityPostListener;
import net.ideahut.springboot.entity.EntityPreListener;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;

final class CrudUpdateNative
implements CrudUpdate {
    private EntityInfo entityInfo;
    private CrudRequest crudRequest;

    private CrudUpdateNative() {
    }

    @Override
    public void destroy() {
        this.entityInfo = null;
        this.crudRequest = null;
    }

    public static CrudUpdateNative of(CrudRequest crudRequest) {
        CrudUpdateNative crudUpdate = new CrudUpdateNative();
        crudUpdate.crudRequest = crudRequest;
        crudUpdate.entityInfo = crudRequest.getEntityInfo();
        return crudUpdate;
    }

    @Override
    public CrudResult create() {
        MapStringObject value = CrudHelper1.getValue(this.crudRequest);
        if (value == null) {
            return CrudConstant.Error.REQUIRED_VALUE;
        }
        final Object input = CrudHelper0.mapToObject(value, this.entityInfo.getEntityClass());
        CrudHelper1.setId(this.crudRequest, input);
        TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        CrudResult result = trxManagerInfo.transaction(true, new SessionCallable<CrudResult>(){

            @Override
            public CrudResult call(Session session) throws Exception {
                Object entity = EntityNative.save(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), input);
                CrudResult result = CrudResult.success((Object)entity);
                List<Stack> stacks = CrudUpdateNative0.saveStacks(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest, entity, false);
                if (stacks != null) {
                    result.setInfo("stacks", stacks);
                }
                if (CrudUpdateNative.this.crudRequest.getLoads() != null && !CrudUpdateNative.this.crudRequest.getLoads().isEmpty()) {
                    EntityNative.LazyLoad lazyLoad = EntityNative.LazyLoad.of(CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), CrudUpdateNative.this.crudRequest.getLoads());
                    lazyLoad.reload(session, entity);
                    lazyLoad.destroy();
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public CrudResult update() {
        CrudUpdateNative0.SqlParameters sqlParameters;
        Object id = CrudHelper1.getId(this.crudRequest);
        if (id == null) {
            return CrudConstant.Error.REQUIRED_ID;
        }
        final MapStringObject value = CrudHelper1.getValue(this.crudRequest);
        if (value == null) {
            return CrudConstant.Error.REQUIRED_VALUE;
        }
        try {
            sqlParameters = CrudUpdateNative0.sqlParametersByIds(this.crudRequest, 1);
            if (sqlParameters == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            return CrudConstant.Error.UNSUPPORTED_ID_TYPE;
        }
        TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        CrudResult crudResult = trxManagerInfo.transaction(true, new SessionCallable<CrudResult>(){

            @Override
            public CrudResult call(Session session) throws Exception {
                Query query = EntityNative.queryOf((SharedSessionContract)session, sqlParameters.selectQl() + " " + sqlParameters.whereQl());
                sqlParameters.applyParameters(query);
                Object[] row = (Object[])query.uniqueResult();
                if (row != null) {
                    Object entity = EntityNative.valueOf(sqlParameters.getSelect(), row);
                    if (CrudUpdateNative.this.entityInfo.merge(value, entity, CrudUpdateNative.this.entityInfo.getIdInfo().getFields())) {
                        entity = EntityNative.update(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), entity);
                    }
                    CrudResult result = CrudResult.success(entity);
                    List<Stack> stacks = CrudUpdateNative0.saveStacks(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest, entity, true);
                    if (stacks != null) {
                        result.setInfo("stacks", stacks);
                    }
                    if (CrudUpdateNative.this.crudRequest.getLoads() != null && !CrudUpdateNative.this.crudRequest.getLoads().isEmpty()) {
                        EntityNative.LazyLoad lazyLoad = EntityNative.LazyLoad.of(CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), CrudUpdateNative.this.crudRequest.getLoads());
                        lazyLoad.reload(session, entity);
                        lazyLoad.destroy();
                    }
                    return result;
                }
                return CrudResult.success(null);
            }
        });
        if (crudResult.getValue() == null) {
            return CrudConstant.Error.NOT_FOUND;
        }
        return crudResult;
    }

    @Override
    public CrudResult save() {
        final MapStringObject value = CrudHelper1.getValue(this.crudRequest);
        if (value == null) {
            return CrudConstant.Error.REQUIRED_VALUE;
        }
        CrudUpdateNative0.SqlParameters sqlParameters = null;
        Object id = CrudHelper1.getId(this.crudRequest);
        if (id != null) {
            try {
                sqlParameters = CrudUpdateNative0.sqlParametersByIds(this.crudRequest, 1);
            }
            catch (Exception e) {
                return CrudConstant.Error.UNSUPPORTED_ID_TYPE;
            }
        }
        final CrudUpdateNative0.SqlParameters fSqlParameters = sqlParameters;
        TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        return trxManagerInfo.transaction(true, new SessionCallable<CrudResult>(){

            @Override
            public CrudResult call(Session session) throws Exception {
                Object entity = null;
                if (fSqlParameters != null) {
                    Query query = EntityNative.queryOf((SharedSessionContract)session, fSqlParameters.selectQl() + " " + fSqlParameters.whereQl());
                    fSqlParameters.applyParameters(query);
                    Object[] row = (Object[])query.uniqueResult();
                    if (row != null) {
                        entity = EntityNative.valueOf(fSqlParameters.getSelect(), row);
                    }
                }
                if (entity != null) {
                    if (CrudUpdateNative.this.entityInfo.merge(value, entity, CrudUpdateNative.this.entityInfo.getIdInfo().getFields())) {
                        entity = EntityNative.update(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), entity);
                    }
                    CrudResult result = CrudResult.success(entity);
                    List<Stack> stacks = CrudUpdateNative0.saveStacks(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest, entity, true);
                    if (stacks != null) {
                        result.setInfo("stacks", stacks);
                    }
                    if (CrudUpdateNative.this.crudRequest.getLoads() != null && !CrudUpdateNative.this.crudRequest.getLoads().isEmpty()) {
                        EntityNative.LazyLoad lazyLoad = EntityNative.LazyLoad.of(CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), CrudUpdateNative.this.crudRequest.getLoads());
                        lazyLoad.reload(session, entity);
                        lazyLoad.destroy();
                    }
                    return result;
                }
                Object input = CrudHelper0.mapToObject(value, CrudUpdateNative.this.entityInfo.getEntityClass());
                CrudHelper1.setId(CrudUpdateNative.this.crudRequest, input);
                entity = EntityNative.save(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), input);
                CrudResult result = CrudResult.success(entity);
                List<Stack> stacks = CrudUpdateNative0.saveStacks(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest, entity, false);
                if (stacks != null) {
                    result.setInfo("stacks", stacks);
                }
                if (CrudUpdateNative.this.crudRequest.getLoads() != null && !CrudUpdateNative.this.crudRequest.getLoads().isEmpty()) {
                    EntityNative.LazyLoad lazyLoad = EntityNative.LazyLoad.of(CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), CrudUpdateNative.this.crudRequest.getLoads());
                    lazyLoad.reload(session, entity);
                    lazyLoad.destroy();
                }
                return result;
            }
        });
    }

    @Override
    public CrudResult delete() {
        CrudUpdateNative0.SqlParameters sqlParameters;
        Object id = CrudHelper1.getId(this.crudRequest);
        if (id == null) {
            return CrudConstant.Error.REQUIRED_ID;
        }
        try {
            sqlParameters = CrudUpdateNative0.sqlParametersByIds(this.crudRequest, 1);
            if (sqlParameters == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            return CrudConstant.Error.UNSUPPORTED_ID_TYPE;
        }
        TrxManagerInfo trxManagerInfo = this.entityInfo.getTrxManagerInfo();
        Object entity = trxManagerInfo.transaction(true, new SessionCallable<Object>(){

            @Override
            public Object call(Session session) throws Exception {
                Query query = EntityNative.queryOf((SharedSessionContract)session, sqlParameters.selectQl() + " " + sqlParameters.whereQl());
                sqlParameters.applyParameters(query);
                Object[] row = (Object[])query.uniqueResult();
                if (row != null) {
                    Object entity = EntityNative.valueOf(sqlParameters.getSelect(), row);
                    entity = EntityNative.delete(session, CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica(), entity);
                    return entity;
                }
                return null;
            }
        });
        return CrudResult.success((Object)entity);
    }

    @Override
    public CrudResult deletes() {
        List entities;
        block15: {
            SessionFactoryImplementor sessionFactory;
            TrxManagerInfo trxManagerInfo;
            CrudUpdateNative0.SqlParameters sqlParameters;
            block16: {
                List<EntityPreListener> preListeners;
                List<Object> ids = this.crudRequest.getIds();
                if (ids == null || ids.isEmpty()) {
                    return CrudConstant.Error.REQUIRED_IDS;
                }
                try {
                    sqlParameters = CrudUpdateNative0.sqlParametersByIds(this.crudRequest, 1);
                    if (sqlParameters == null) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    return CrudConstant.Error.UNSUPPORTED_ID_TYPE;
                }
                trxManagerInfo = this.entityInfo.getTrxManagerInfo();
                entities = trxManagerInfo.transaction(new SessionCallable<List>(){

                    @Override
                    public List call(Session session) throws Exception {
                        Query query = EntityNative.queryOf((SharedSessionContract)session, sqlParameters.selectQl() + " " + sqlParameters.whereQl());
                        sqlParameters.applyParameters(query);
                        List rows = query.getResultList();
                        return EntityNative.entitesOf(rows, session, CrudUpdateNative.this.entityInfo, Arrays.asList(sqlParameters.getSelect()), null);
                    }
                });
                if (entities == null || entities.isEmpty()) break block15;
                sessionFactory = trxManagerInfo.getIntegrator().getSessionFactory();
                boolean isSoftDelete = EntitySoftDelete.class.isAssignableFrom(this.entityInfo.getEntityClass());
                CrudUpdateNative0.SqlParameters softUpt = null;
                if (isSoftDelete) {
                    try {
                        softUpt = CrudUpdateNative0.sqlParametersByIds(this.crudRequest, 2);
                    }
                    catch (Exception e) {
                        return CrudConstant.Error.FAILED;
                    }
                }
                if ((preListeners = EntityIntegrator.getEntityPreListeners((SessionFactory)sessionFactory)) != null) {
                    for (EntityPreListener listener : preListeners) {
                        for (Object entity : entities) {
                            listener.onPreDelete(entity);
                        }
                    }
                }
                final Long deletedOn = TimeUtil.currentEpochMillis();
                if (softUpt == null) break block16;
                final CrudUpdateNative0.SqlParameters fSoftUpt = softUpt;
                trxManagerInfo.transaction(true, new SessionCallable<Void>(){

                    @Override
                    public Void call(Session session) throws Exception {
                        Query query = EntityNative.queryOf((SharedSessionContract)session, "update " + EntityNative.tableReplica(CrudUpdateNative.this.entityInfo, CrudUpdateNative.this.crudRequest.getReplica()) + " set deleted_on=?1 " + fSoftUpt.whereQl()).setParameter(1, (Object)deletedOn);
                        fSoftUpt.applyParameters(query);
                        query.executeUpdate();
                        return null;
                    }
                });
                List<EntityPostListener> postListeners = EntityIntegrator.getEntityPostListeners((SessionFactory)sessionFactory);
                if (postListeners == null) break block15;
                for (EntityPostListener listener : postListeners) {
                    for (Object entity : entities) {
                        ((EntitySoftDelete)entity).setDeletedOn(deletedOn);
                        listener.onPostDelete(entity);
                    }
                }
                break block15;
            }
            trxManagerInfo.transaction(true, new SessionCallable<Void>(){

                @Override
                public Void call(Session session) throws Exception {
                    Query query = EntityNative.queryOf((SharedSessionContract)session, sqlParameters.deleteQl() + " " + sqlParameters.whereQl());
                    sqlParameters.applyParameters(query);
                    query.executeUpdate();
                    return null;
                }
            });
            List<EntityPostListener> postListeners = EntityIntegrator.getEntityPostListeners((SessionFactory)sessionFactory);
            if (postListeners != null) {
                for (EntityPostListener listener : postListeners) {
                    for (Object entity : entities) {
                        listener.onPostDelete(entity);
                    }
                }
            }
        }
        return CrudResult.success((Object)entities);
    }
}

