/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.crud.Condition;
import net.ideahut.springboot.crud.CrudHelper0;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudSelectNative0;
import net.ideahut.springboot.crud.Filter;
import net.ideahut.springboot.crud.Logical;
import net.ideahut.springboot.crud.Relation;
import net.ideahut.springboot.crud.Stack;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.object.MapStringObject;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.util.Assert;

final class CrudUpdateNative0 {
    private CrudUpdateNative0() {
    }

    protected static List<Stack> saveStacks(Session session, EntityInfo entityInfo, CrudRequest crudRequest, Object parent, boolean isUpdate) throws Exception {
        List<Stack> items = crudRequest.getStacks();
        if (items != null && !items.isEmpty()) {
            ArrayList<Stack> stacks = new ArrayList<Stack>();
            for (Stack item : items) {
                if (item.getValues() == null || item.getValues().isEmpty()) continue;
                Stack stack = Stack.of(item.getEntityInfo()).setName(item.getName()).setReplica(item.getReplica()).setEntities(new ArrayList<Object>());
                MapStringObject mref = new MapStringObject();
                for (Relation relation : item.getRelations()) {
                    FieldInfo fiSource = entityInfo.getFieldInfo(relation.getSource());
                    Assert.notNull((Object)fiSource, (String)("Invalid stack relation, 1, stack: " + stack.getName() + ", relation: " + CrudHelper0.writeAsString(relation)));
                    Object viSource = fiSource.getValue(parent);
                    FieldInfo fiTarget = stack.getEntityInfo().getFieldInfo(relation.getTarget());
                    Assert.notNull((Object)fiTarget, (String)("Invalid stack relation, 2, stack: " + stack.getName() + ", relation: " + CrudHelper0.writeAsString(relation)));
                    if (Converter.isEntity(fiTarget.getConverter())) {
                        Assert.isTrue((boolean)fiTarget.getType().equals(entityInfo.getEntityClass()), (String)("Invalid stack relation, 3, stack: " + stack.getName() + ", relation: " + CrudHelper0.writeAsString(relation)));
                        Object viTarget = entityInfo.createEntity();
                        fiSource.setValue(viTarget, viSource);
                        mref.put(relation.getTarget(), viTarget);
                        continue;
                    }
                    mref.put(relation.getTarget(), viSource);
                }
                for (MapStringObject value : item.getValues()) {
                    MapStringObject newValue = new MapStringObject(value);
                    newValue.putAll((Map)mref);
                    Object entity = CrudUpdateNative0.saveStack(session, entityInfo, parent, stack, newValue, item.getRelations(), isUpdate);
                    stack.getEntities().add(entity);
                }
                stacks.add(stack);
            }
            return stacks;
        }
        return null;
    }

    private static Object saveStack(Session session, EntityInfo entityInfo, Object parent, Stack stack, MapStringObject value, List<Relation> relations, boolean isUpdate) throws Exception {
        Object entity = CrudHelper0.mapToObject(value, stack.getEntityInfo().getEntityClass());
        if (isUpdate) {
            entity = EntityNative.reload(session, stack.getEntityInfo(), stack.getReplica(), entity);
            Assert.notNull(entity, (String)("Stack entity is not found, stack: " + stack.getName() + ", value: " + CrudHelper0.writeAsString(value)));
            HashSet<String> skipFields = new HashSet<String>(stack.getEntityInfo().getIdInfo().getFields());
            for (Relation relation : relations) {
                FieldInfo fiSource = entityInfo.getFieldInfo(relation.getSource());
                Object viSource = fiSource.getValue(parent);
                FieldInfo fiTarget = stack.getEntityInfo().getFieldInfo(relation.getTarget());
                Object viTarget = fiTarget.getValue(entity);
                if (Converter.isEntity(fiTarget.getConverter())) {
                    Object idTarget = CrudHelper0.idFromEntity(entityInfo, viTarget);
                    if (viSource != null && idTarget != null && !viSource.equals(idTarget)) {
                        Assert.isTrue((boolean)false, (String)("Invalid stack relation value, 1, stack: " + stack.getName() + ", value: " + CrudHelper0.writeAsString(value)));
                    }
                } else if (viSource != null && viTarget != null && !viSource.equals(viTarget)) {
                    Assert.isTrue((boolean)false, (String)("Invalid stack relation value, 2, stack: " + stack.getName() + ", value: " + CrudHelper0.writeAsString(value)));
                }
                skipFields.add(relation.getTarget());
            }
            if (stack.getEntityInfo().merge(value, entity, skipFields)) {
                entity = EntityNative.update(session, stack.getEntityInfo(), stack.getReplica(), entity);
            }
        } else {
            EntityHelper.setAudit(entity, false);
            entity = EntityNative.saveOrUpdate(session, stack.getEntityInfo(), stack.getReplica(), entity);
        }
        return entity;
    }

    protected static SqlParameters sqlParametersByIds(CrudRequest crudRequest, int startIndex) throws Exception {
        EntityInfo entityInfo = crudRequest.getEntityInfo();
        Integer replica = crudRequest.getReplica();
        ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();
        String inIds = CrudSelectNative0.inIds(crudRequest.getIds(), entityInfo, "", parameters, startIndex);
        if (inIds.isEmpty()) {
            return null;
        }
        Object whereQl = "where 1=1 ";
        if (EntitySoftDelete.class.isAssignableFrom(entityInfo.getEntityClass())) {
            whereQl = (String)whereQl + "and deleted_on is null ";
        }
        whereQl = (String)whereQl + "and " + inIds + " ";
        Condition.QueryParameters queryAndParameters = Condition.QueryParameters.of((String)whereQl, (Object[])new Object[]{parameters});
        CrudUpdateNative0.spesifics(crudRequest, queryAndParameters);
        return new SqlParameters(entityInfo, replica, queryAndParameters.getQuery(), parameters, startIndex);
    }

    private static void spesifics(CrudRequest crudRequest, Condition.QueryParameters queryParameters) {
        if (crudRequest.getSpesifics() != null) {
            for (Filter filter : crudRequest.getSpesifics()) {
                CrudUpdateNative0.filter(filter, crudRequest.getEntityInfo(), queryParameters);
            }
        }
    }

    private static void filter(Filter filter, EntityInfo entityInfo, Condition.QueryParameters queryAndParameters) {
        Logical logical = filter.getLogical();
        if (logical == null) {
            logical = Logical.AND;
        }
        String logic = " " + logical.name().toLowerCase();
        StringBuilder query = new StringBuilder(queryAndParameters.getQuery());
        if (filter.getFilters() != null && !filter.getFilters().isEmpty()) {
            query.append(" ").append(logic).append(" (1=1 ");
            for (Filter child : filter.getFilters()) {
                queryAndParameters.setQuery(query.toString());
                CrudUpdateNative0.filter(child, entityInfo, queryAndParameters);
                query = new StringBuilder(queryAndParameters.getQuery());
            }
            query.append(") ");
            queryAndParameters.setQuery(query.toString());
            return;
        }
        Assert.notNull((Object)filter.getField(), (String)"Filter field is required");
        FieldInfo fieldInfo = EntityHelper.getFieldInfo(entityInfo, filter.getField());
        Condition condition = filter.getCondition();
        ArrayList<Object> lvals = new ArrayList<Object>();
        if (condition.isConvert()) {
            for (Object svalue : filter.getValues()) {
                Object ovalue = EntityHelper.getFieldValue(entityInfo, filter.getField(), svalue != null ? "" + svalue : null);
                lvals.add(ovalue);
            }
        } else {
            for (Object svalue : filter.getValues()) {
                lvals.add(svalue);
            }
        }
        Condition.QueryParameters qap = condition.getBuilder().build(true, logic, queryAndParameters.getParameters().size(), fieldInfo.getColumn().getName(), lvals.toArray());
        query.append(qap.getQuery());
        for (Object value : qap.getParameters()) {
            queryAndParameters.getParameters().add(EntityNative.Parameter.of(fieldInfo.getHibernateType(), value));
        }
        queryAndParameters.setQuery(query.toString());
    }

    protected static class SqlParameters {
        private final EntityInfo entityInfo;
        private final EntityNative.Select select;
        private final String selectQl;
        private final String deleteQl;
        private final String whereQl;
        private final List<EntityNative.Parameter> parameters;
        private final int startIndex;

        protected SqlParameters(EntityInfo entityInfo, Integer replica, String whereQl, List<EntityNative.Parameter> parameters, int startIndex) {
            StringBuilder selectQlEi = new StringBuilder();
            EntityNative.Select selectEi = EntityNative.Select.of(entityInfo, 0, null);
            for (String field : selectEi.getEntityInfo().getFieldInfoNames()) {
                FieldInfo fieldInfo = selectEi.getEntityInfo().getFieldInfo(field);
                EntityNative.appendSelect(fieldInfo, selectEi, selectQlEi, null, 0, false);
            }
            this.selectQl = "select " + selectQlEi.deleteCharAt(selectQlEi.length() - 1).toString() + " from " + EntityNative.tableReplica(entityInfo, replica);
            this.deleteQl = "delete from " + EntityNative.tableReplica(entityInfo, replica);
            this.entityInfo = entityInfo;
            this.whereQl = whereQl;
            this.parameters = parameters != null ? Collections.unmodifiableList(parameters) : null;
            this.startIndex = startIndex;
            this.select = selectEi;
        }

        protected String selectQl() {
            return this.selectQl;
        }

        protected String deleteQl() {
            return this.deleteQl;
        }

        protected String whereQl() {
            return this.whereQl;
        }

        protected Class<?> entityClass() {
            return this.entityInfo.getEntityClass();
        }

        protected EntityNative.Select getSelect() {
            return this.select;
        }

        protected void applyParameters(Query<?> query) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                EntityNative.Parameter parameter = this.parameters.get(i);
                query.setParameter(this.startIndex + i, parameter.getValue(), parameter.getType());
            }
        }
    }
}

