/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.crud;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import net.ideahut.springboot.crud.CrudBuilder0;
import net.ideahut.springboot.crud.Relation;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.object.MapStringObject;
import org.springframework.util.Assert;

public class Stack {
    private String name;
    private Integer replica;
    private List<Relation> relations;
    private List<MapStringObject> values;
    private List<Object> entities;
    @JsonIgnore
    private EntityInfo entityInfo;

    private Stack() {
    }

    public Stack setName(String name) {
        this.name = name;
        return this;
    }

    public Stack setReplica(Integer replica) {
        this.replica = replica;
        return this;
    }

    public Stack setRelations(List<Relation> relations) {
        this.relations = relations;
        return this;
    }

    public Stack addRelation(Relation relation) {
        if (this.relations == null) {
            this.relations = new ArrayList<Relation>();
        }
        this.relations.add(relation);
        return this;
    }

    public Stack setValues(List<Object> values) {
        if (values != null) {
            this.values = new ArrayList<MapStringObject>();
            for (Object value : values) {
                CrudBuilder0.checkValue(this.entityInfo, value);
                this.values.add(CrudBuilder0.convertValue(value));
            }
        } else {
            this.values = null;
        }
        return this;
    }

    public Stack addValue(Object value) {
        CrudBuilder0.checkValue(this.entityInfo, value);
        if (this.values == null) {
            this.values = new ArrayList<MapStringObject>();
        }
        this.values.add(CrudBuilder0.convertValue(value));
        return this;
    }

    protected Stack setEntities(List<Object> entities) {
        this.entities = entities;
        return this;
    }

    protected Stack setEntityInfo(EntityInfo entityInfo) {
        this.entityInfo = entityInfo;
        return this;
    }

    public static Stack of(EntityInfo entityInfo, Relation relation) {
        Assert.notNull((Object)entityInfo, (String)"EntityInfo is required");
        Stack stack = new Stack().setEntityInfo(entityInfo);
        if (relation != null) {
            stack.addRelation(relation);
        }
        return stack;
    }

    public static Stack of(EntityInfo entityInfo) {
        return Stack.of(entityInfo, null);
    }

    public static Stack of(String name, Relation relation) {
        Assert.hasLength((String)name, (String)"Name is required");
        Stack stack = new Stack().setName(name);
        if (relation != null) {
            stack.addRelation(relation);
        }
        return stack;
    }

    public static Stack of(String name) {
        return Stack.of(name, null);
    }

    public String getName() {
        return this.name;
    }

    public Integer getReplica() {
        return this.replica;
    }

    public List<Relation> getRelations() {
        return this.relations;
    }

    public List<MapStringObject> getValues() {
        return this.values;
    }

    public List<Object> getEntities() {
        return this.entities;
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }
}

