/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;

public class AttributeOverrides {
    private final FieldInfo fieldInfo;
    private final EntityInfo entityInfo;
    private final Map<String, FieldInfo> colums;

    protected AttributeOverrides(FieldInfo fieldInfoEi, EntityInfo entityInfoEi) {
        EmbeddedId anEmbeddedId;
        TreeMap<String, FieldInfo> columsEi = new TreeMap<String, FieldInfo>();
        jakarta.persistence.AttributeOverrides anAttributeOverrides = fieldInfoEi.getAnnotation(jakarta.persistence.AttributeOverrides.class);
        if (anAttributeOverrides != null) {
            this.populate(fieldInfoEi, entityInfoEi, columsEi, anAttributeOverrides.value());
        } else {
            AttributeOverride[] anAttrs = (AttributeOverride[])fieldInfoEi.getAnnotationsByType(AttributeOverride.class);
            this.populate(fieldInfoEi, entityInfoEi, columsEi, anAttrs);
        }
        if (columsEi.isEmpty() && (anEmbeddedId = fieldInfoEi.getAnnotation(EmbeddedId.class)) != null) {
            for (String name : entityInfoEi.getFieldInfoNames()) {
                FieldInfo fieldInfo = entityInfoEi.getFieldInfo(name);
                columsEi.put(fieldInfo.getColumn().getName(), fieldInfo);
            }
        }
        this.fieldInfo = fieldInfoEi;
        this.entityInfo = entityInfoEi;
        this.colums = Collections.unmodifiableMap(columsEi);
        if (!this.colums.isEmpty()) {
            this.entityInfo.attributeOverrides.put(this.fieldInfo.getName(), this);
        }
    }

    private void populate(FieldInfo fieldInfoEi, EntityInfo entityInfoEi, Map<String, FieldInfo> columsEi, AttributeOverride[] attributeOverrides) {
        if (attributeOverrides != null && attributeOverrides.length != 0) {
            for (AttributeOverride attributeOverride : attributeOverrides) {
                String name = attributeOverride.name();
                FieldInfo fieldInfo = entityInfoEi.getFieldInfo(name);
                if (fieldInfo == null) continue;
                Column column = attributeOverride.column();
                columsEi.put(column.name(), fieldInfo);
            }
        }
    }

    public Set<String> getColums() {
        return this.colums.keySet();
    }

    public boolean isEmpty() {
        return this.colums.isEmpty();
    }

    public FieldInfo getFieldInfo(String column) {
        return this.colums.get(column);
    }

    public Object createObject() throws Exception {
        return this.entityInfo.createEntity();
    }

    public boolean setValue(Object object, String column, Object value) throws Exception {
        FieldInfo fieldInfo;
        if (object != null && value != null && (fieldInfo = this.colums.get(column)) != null) {
            fieldInfo.setValue(object, fieldInfo.convert(value));
            return true;
        }
        return false;
    }

    public EntityNative.Parameter getParameter(Object object, String column) throws Exception {
        if (object != null) {
            Object value = this.fieldInfo.getValue(object);
            FieldInfo finfo = this.colums.get(column);
            if (value != null && finfo != null) {
                Object pval = finfo.getValue(value);
                return EntityNative.Parameter.of(finfo.getHibernateType(), pval);
            }
        }
        return null;
    }
}

