/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.entity.DatabaseType;
import net.ideahut.springboot.entity.DepreHelper;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.MetadataImpl;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

final class EntityHelper1 {
    private static final Comparator<String> SORT_CATALOG = (o1, o2) -> o2.compareTo((String)o1);

    private EntityHelper1() {
    }

    protected static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static List<String> getCatalogs(DatabaseMetaData dbMetaData) throws SQLException {
        ArrayList<String> catalogs = new ArrayList<String>();
        ResultSet rs = dbMetaData.getCatalogs();
        while (rs.next()) {
            catalogs.add(rs.getString(1));
        }
        Collections.sort(catalogs, SORT_CATALOG);
        return catalogs;
    }

    protected static boolean isTableExist(EntityIntegrator integrator, Table table, boolean isUpperCase) {
        Connection connection = null;
        try {
            connection = integrator.getConnection();
            DatabaseMetaData dbMetaData = connection.getMetaData();
            String url = dbMetaData.getURL();
            List<String> catalogs = EntityHelper1.getCatalogs(dbMetaData);
            String catalog = null;
            for (String cat : catalogs) {
                if (url.indexOf("databaseName=" + cat) == -1 && url.indexOf("/" + cat) == -1) continue;
                catalog = cat;
                break;
            }
            if (catalog == null) {
                catalog = table.getCatalog();
            }
            String schema = table.getSchema();
            String name = table.getName();
            if (isUpperCase) {
                catalog = catalog != null ? catalog.toUpperCase() : null;
                schema = schema != null ? schema.toUpperCase() : null;
                name = name.toUpperCase();
            }
            ResultSet rs = dbMetaData.getTables(catalog, schema, name, new String[]{"TABLE"});
            boolean result = rs.next();
            rs.close();
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
        finally {
            EntityHelper1.close(connection);
        }
    }

    protected static String getColumDefaultValue(EntityIntegrator integrator, Table table, Column column, boolean isUpperCase) {
        String string;
        Connection connection = null;
        try {
            String tableName = table.getName();
            String columnName = column.getName();
            if (isUpperCase) {
                tableName = tableName.toUpperCase();
                columnName = columnName.toUpperCase();
            }
            connection = integrator.getConnection();
            DatabaseMetaData dbMetaData = connection.getMetaData();
            ResultSet rs = dbMetaData.getColumns(connection.getCatalog(), dbMetaData.getUserName(), tableName, columnName);
            String defaultValue = null;
            if (rs.next() && (defaultValue = rs.getString("COLUMN_DEF")) == null) {
                defaultValue = rs.getString("column_def");
            }
            rs.close();
            string = defaultValue != null ? defaultValue : "";
        }
        catch (Exception e) {
            try {
                throw FrameworkUtil.exception(e);
            }
            catch (Throwable throwable) {
                EntityHelper1.close(connection);
                throw throwable;
            }
        }
        EntityHelper1.close(connection);
        return string;
    }

    protected static boolean createTable(EntityIntegrator integrator, Table table, boolean isIdentityPk) {
        int num = 0;
        DatabaseType databaseType = integrator.getDatabaseType();
        boolean isTableExist = EntityHelper1.isTableExist(integrator, table, databaseType.isUpperCaseTable());
        if (!isTableExist) {
            SessionImplementor session = null;
            try {
                String sql = EntityHelper1.sqlCreateTable(integrator, table, isIdentityPk);
                session = integrator.getSessionFactory().openSession();
                session.beginTransaction();
                num = EntityNative.queryOf((SharedSessionContract)session, sql).executeUpdate();
                Iterator<Index> iter = DepreHelper.getIndexIterator(table);
                while (iter.hasNext()) {
                    sql = EntityHelper1.sqlCreateIndex(integrator, iter.next());
                    EntityNative.queryOf((SharedSessionContract)session, sql).executeUpdate();
                }
                EntityHelper.commit((Session)session);
            }
            catch (Exception e) {
                try {
                    EntityHelper.rollback(session);
                    throw e;
                }
                catch (Throwable throwable) {
                    EntityHelper.close(session);
                    throw throwable;
                }
            }
            EntityHelper.close((Session)session);
        }
        return num != 0;
    }

    protected static Table findTable(EntityIntegrator integrator, String name) {
        Database database = integrator.getMetadata().getDatabase();
        Namespace namespace = database.getDefaultNamespace();
        Identifier identifier = database.toIdentifier(name);
        for (Table table : namespace.getTables()) {
            if (!table.getNameIdentifier().equals((Object)identifier)) continue;
            return table;
        }
        return null;
    }

    protected static Column findColumn(Table table, String name) {
        Column column = table.getColumn(Identifier.toIdentifier((String)name));
        if (column == null) {
            column = table.getColumn(Identifier.toIdentifier((String)name, (boolean)true));
        }
        return column;
    }

    protected static String sqlCreateTable(EntityIntegrator integrator, Table table, boolean isIdentityPk) {
        String checkConstraint;
        MetadataImpl metadata = (MetadataImpl)integrator.getMetadata();
        SqlStringGenerationContext context = integrator.getSqlStringGenerationContext();
        Dialect dialect = context.getDialect();
        StringBuilder buf = new StringBuilder(table.hasPrimaryKey() ? dialect.getCreateTableString() : dialect.getCreateMultisetTableString()).append(' ').append(table.getQualifiedName(context)).append(" (");
        KeyValue idValue = table.getIdentifierValue();
        HashSet<String> pkColumns = new HashSet<String>();
        boolean identityColumn = idValue != null && isIdentityPk;
        String pkname = null;
        if (table.hasPrimaryKey()) {
            if (identityColumn) {
                pkname = ((Column)table.getPrimaryKey().getColumns().iterator().next()).getQuotedName(dialect);
            }
            for (Column pkColumn : table.getPrimaryKey().getColumns()) {
                pkColumns.add(pkColumn.getName());
            }
        }
        Iterator iter = table.getColumns().iterator();
        while (iter.hasNext()) {
            String columnComment;
            Column col = (Column)iter.next();
            buf.append(col.getQuotedName(dialect)).append(' ');
            if (identityColumn && col.getQuotedName(dialect).equals(pkname)) {
                if (dialect.getIdentityColumnSupport().hasDataTypeInIdentityColumn()) {
                    buf.append(col.getSqlType((Metadata)metadata));
                }
                buf.append(' ').append(dialect.getIdentityColumnSupport().getIdentityColumnString(col.getSqlTypeCode((Mapping)metadata)));
            } else {
                buf.append(col.getSqlType((Metadata)metadata));
                String defaultValue = col.getDefaultValue();
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (col.isNullable()) {
                    buf.append(dialect.getNullColumnString());
                } else {
                    buf.append(" not null");
                }
            }
            if (col.isUnique() && !pkColumns.contains(col.getName())) {
                String keyName = Constraint.generateName((String)"UK_", (Table)table, (Column[])new Column[]{col});
                UniqueKey uk = table.getOrCreateUniqueKey(keyName);
                uk.addColumn(col);
                buf.append(dialect.getUniqueDelegate().getColumnDefinitionUniquenessFragment(col, context));
            }
            if (col.hasCheckConstraint() && dialect.supportsColumnCheck()) {
                checkConstraint = DepreHelper.getCheckConstraint(col);
                buf.append(" check (").append(checkConstraint).append(")");
            }
            if ((columnComment = col.getComment()) != null) {
                buf.append(dialect.getColumnComment(columnComment));
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (table.hasPrimaryKey()) {
            buf.append(", ").append(table.getPrimaryKey().sqlConstraintString(dialect));
        }
        buf.append(dialect.getUniqueDelegate().getTableCreationUniqueConstraintsFragment(table, context));
        if (dialect.supportsTableCheck()) {
            Iterator<String> checkConstraints = DepreHelper.getCheckConstraintsIterator(table);
            while (checkConstraints.hasNext()) {
                checkConstraint = checkConstraints.next();
                buf.append(", check (").append(checkConstraint).append(')');
            }
        }
        buf.append(')');
        if (table.getComment() != null) {
            buf.append(dialect.getTableComment(table.getComment()));
        }
        return buf.append(dialect.getTableTypeString()).toString();
    }

    protected static String sqlCreateIndex(EntityIntegrator integrator, Index index) {
        SqlStringGenerationContext context = integrator.getSqlStringGenerationContext();
        Dialect dialect = context.getDialect();
        String tableName = index.getTable().getQualifiedName(context);
        String name = index.getQuotedName(dialect);
        StringBuilder buf = new StringBuilder("create").append(" index ").append(dialect.qualifyIndexName() ? name : StringHelper.unqualify((String)name)).append(" on ").append(tableName).append(" (");
        Iterator<Column> columns = DepreHelper.getIndexColumns(index).iterator();
        Map<Column, String> columnOrderMap = DepreHelper.getIndexColumnOrderMap(index);
        while (columns.hasNext()) {
            Column column = columns.next();
            buf.append(column.getQuotedName(dialect));
            if (columnOrderMap.containsKey(column)) {
                buf.append(" ").append(columnOrderMap.get(column));
            }
            if (!columns.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    protected static String sqlCreateUniqueKey(EntityIntegrator integrator, UniqueKey uniqueKey) {
        Dialect dialect = integrator.getDialect();
        return dialect.getUniqueDelegate().getAlterTableToAddUniqueKeyCommand(uniqueKey, integrator.getMetadata(), integrator.getSqlStringGenerationContext());
    }
}

