/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Entity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo0;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.JoinColumns;
import net.ideahut.springboot.entity.NativeEntityDefinition;
import net.ideahut.springboot.entity.StandardEntityDefinition;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.mapping.Table;

public class EntityInfo {
    @JsonIgnore
    private final TrxManagerInfo trxManagerInfo;
    private final Class<?> entityClass;
    private final Constructor<?> constructor;
    private final boolean isEntity;
    private final Map<String, FieldInfo> fieldTransients;
    private final Map<String, FieldInfo> fieldInfos;
    private final Map<String, FieldInfo> columnInfos;
    private final Map<String, FieldInfo> lazyObjectFields;
    private final Map<String, FieldInfo> eagerObjectFields;
    private final Map<String, FieldInfo> lazyCollectionFields;
    private final Set<String> uniqueFields;
    private final Map<Class<? extends Annotation>, Set<String>> annotationFields;
    private final IdInfo idInfo;
    private final Table table;
    protected final Set<String> mergeIgnoredFields;
    protected Map<String, JoinColumns> joinColumns;
    protected Map<String, AttributeOverrides> attributeOverrides;
    @JsonIgnore
    protected EntityInfo parentInfo;
    private final StandardEntityDefinition standardDefinition;
    private final NativeEntityDefinition nativeDefinition;

    protected EntityInfo(TrxManagerInfo trxManagerInfo, Class<?> entityClass) throws Exception {
        this(trxManagerInfo, entityClass, null);
    }

    protected EntityInfo(TrxManagerInfo trxManagerInfo, Class<?> entityClass, Table table) throws Exception {
        this.trxManagerInfo = trxManagerInfo;
        Entity annotEntity = entityClass.getAnnotation(Entity.class);
        boolean isEntityEi = annotEntity != null;
        String tableName = "";
        jakarta.persistence.Table annotTable = entityClass.getAnnotation(jakarta.persistence.Table.class);
        if (annotTable != null) {
            tableName = annotTable.name();
        }
        Table tableEi = table;
        if (trxManagerInfo != null && tableEi == null) {
            tableEi = EntityHelper.findTable(trxManagerInfo.getIntegrator(), tableName);
        }
        this.table = tableEi;
        LinkedHashMap<String, FieldInfo> fieldTransientsEi = new LinkedHashMap<String, FieldInfo>();
        LinkedHashMap<String, FieldInfo> fieldInfosEi = new LinkedHashMap<String, FieldInfo>();
        LinkedHashMap<String, FieldInfo> columnInfosEi = new LinkedHashMap<String, FieldInfo>();
        LinkedHashMap<String, FieldInfo> lazyObjectFieldsEi = new LinkedHashMap<String, FieldInfo>();
        LinkedHashMap<String, FieldInfo> eagerObjectFieldsEi = new LinkedHashMap<String, FieldInfo>();
        LinkedHashMap<String, FieldInfo> lazyCollectionFieldsEi = new LinkedHashMap<String, FieldInfo>();
        LinkedHashMap<Class<? extends Annotation>, Set<String>> annotationFieldsEi = new LinkedHashMap<Class<? extends Annotation>, Set<String>>();
        HashSet<String> uniqueFieldsEi = new HashSet<String>();
        HashSet<String> idFieldsEi = new HashSet<String>();
        EntityInfo embeddedEntityInfo = null;
        for (Class<?> theClass = entityClass; theClass != null; theClass = theClass.getSuperclass()) {
            for (Field field : theClass.getDeclaredFields()) {
                EntityInfo idEmbeddedInfo;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isFinal(modifiers) || Modifier.isNative(modifiers) || Modifier.isTransient(modifiers) || Modifier.isVolatile(modifiers)) continue;
                boolean canPopulate = false;
                if (Modifier.isPrivate(modifiers)) {
                    try {
                        String fieldName = field.getName();
                        String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                        Method getter = theClass.getMethod("get" + methodName, new Class[0]);
                        canPopulate = getter.getReturnType().equals(field.getType());
                    }
                    catch (Exception fieldName) {}
                } else if (Modifier.isPublic(modifiers)) {
                    canPopulate = true;
                }
                if (!canPopulate || (idEmbeddedInfo = EntityInfo0.collectField(this, field, fieldTransientsEi, fieldInfosEi, columnInfosEi, eagerObjectFieldsEi, lazyObjectFieldsEi, lazyCollectionFieldsEi, idFieldsEi, uniqueFieldsEi, annotationFieldsEi)) == null) continue;
                embeddedEntityInfo = idEmbeddedInfo;
            }
        }
        HashSet<String> mergeIgnoredFieldsEi = new HashSet<String>();
        if (EntitySoftDelete.class.isAssignableFrom(entityClass)) {
            mergeIgnoredFieldsEi.add("deletedOn");
        }
        if (EntityAudit.class.isAssignableFrom(entityClass)) {
            mergeIgnoredFieldsEi.addAll(EntityAudit.Name.Field.list());
        }
        this.idInfo = EntityInfo0.getIdInfo(idFieldsEi, uniqueFieldsEi, fieldInfosEi, embeddedEntityInfo);
        this.uniqueFields = uniqueFieldsEi;
        this.fieldTransients = Collections.unmodifiableMap(fieldTransientsEi);
        this.fieldInfos = fieldInfosEi;
        this.eagerObjectFields = Collections.unmodifiableMap(eagerObjectFieldsEi);
        this.lazyObjectFields = Collections.unmodifiableMap(lazyObjectFieldsEi);
        this.lazyCollectionFields = Collections.unmodifiableMap(lazyCollectionFieldsEi);
        this.columnInfos = columnInfosEi;
        this.annotationFields = Collections.unmodifiableMap(annotationFieldsEi);
        this.mergeIgnoredFields = Collections.unmodifiableSet(mergeIgnoredFieldsEi);
        this.entityClass = entityClass;
        this.isEntity = isEntityEi;
        this.joinColumns = new LinkedHashMap<String, JoinColumns>();
        this.attributeOverrides = new LinkedHashMap<String, AttributeOverrides>();
        this.standardDefinition = StandardEntityDefinition.of(this);
        this.nativeDefinition = NativeEntityDefinition.of(this);
        this.constructor = entityClass.getConstructor(new Class[0]);
    }

    public TrxManagerInfo getTrxManagerInfo() {
        return this.trxManagerInfo;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.entityClass.getAnnotation(annotationClass);
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return this.entityClass.getAnnotationsByType(annotationClass);
    }

    public Annotation[] getAnnotations() {
        return this.entityClass.getAnnotations();
    }

    public Set<String> getAnnotationFields(Class<? extends Annotation> annotationClass) {
        return this.annotationFields.get(annotationClass);
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isEntity() {
        return this.isEntity;
    }

    public FieldInfo getFieldTransient(String name) {
        return this.fieldTransients.get(name);
    }

    public Set<String> getFieldTransientNames() {
        return this.fieldTransients.keySet();
    }

    public FieldInfo getFieldInfo(String name) {
        return this.fieldInfos.get(name);
    }

    public Set<String> getFieldInfoNames() {
        return this.fieldInfos.keySet();
    }

    public FieldInfo getColumnInfo(String name) {
        return this.columnInfos.get(name);
    }

    public Set<String> getColumnInfoNames() {
        return this.columnInfos.keySet();
    }

    public Map<String, FieldInfo> getEagerObjectFields() {
        return this.eagerObjectFields;
    }

    public Map<String, FieldInfo> getLazyObjectFields() {
        return this.lazyObjectFields;
    }

    public Map<String, FieldInfo> getLazyCollectionFields() {
        return this.lazyCollectionFields;
    }

    public boolean isUniqueField(String field) {
        return this.uniqueFields.contains(field);
    }

    public IdInfo getIdInfo() {
        return this.idInfo;
    }

    public EntityInfo getParentInfo() {
        return this.parentInfo;
    }

    public EntityNative.ColumnConverter getColumnConverter(String anyField) {
        return this.nativeDefinition.getColumnConverters().get(anyField);
    }

    public <T> T createEntity() throws Exception {
        return (T)this.constructor.newInstance(new Object[0]);
    }

    protected StandardEntityDefinition getStandardDefinition() {
        return this.standardDefinition;
    }

    protected NativeEntityDefinition getNativeDefinition() {
        return this.nativeDefinition;
    }

    public <T> void writeJoinColumns(T entity) throws Exception {
        if (entity != null) {
            for (Map.Entry<String, JoinColumns> entry : this.joinColumns.entrySet()) {
                entry.getValue().writeToObject(entity);
            }
        }
    }

    public EntityInfo loadLazy(Object object, List<String> tobeLoadFields) {
        EntityHelper.loadLazy(object, this, tobeLoadFields);
        return this;
    }

    public EntityInfo nullLazyCollection(Object object) {
        if (object != null && this.entityClass.isAssignableFrom(object.getClass())) {
            try {
                for (FieldInfo fieldInfo : this.lazyCollectionFields.values()) {
                    fieldInfo.setValue(object, null);
                }
            }
            catch (Exception e) {
                throw FrameworkUtil.exception(e);
            }
        }
        return this;
    }

    public <T> boolean merge(T source, T target, boolean skipNull, Collection<String> skipFields) {
        return EntityInfo0.merge(this, source, target, skipNull, skipFields);
    }

    public <T> boolean merge(MapStringObject source, T target, Collection<String> skipFields) throws Exception {
        return EntityInfo0.merge(this, source, target, skipFields);
    }

    protected void prepareConverters() {
        this.prepareConverters(this.fieldTransients.values());
        this.prepareConverters(this.fieldInfos.values());
        if (EntityIdType.EMBEDDED == this.idInfo.getIdType()) {
            this.prepareConverters(this.idInfo.getEmbeddedEntityInfo().fieldInfos.values());
        }
    }

    private void prepareConverters(Collection<FieldInfo> fields) {
        for (FieldInfo field : fields) {
            field.prepareConverter();
        }
    }

    protected void prepareAttributeOverrides() {
        for (FieldInfo field : this.fieldInfos.values()) {
            if (!Converter.isEntity(field.getConverter())) continue;
            EntityInfo etInfo = this.trxManagerInfo.getEntityInfo(field.getType());
            field.prepareAttributeOverrides(etInfo);
        }
        if (EntityIdType.EMBEDDED == this.idInfo.getIdType()) {
            FieldInfo field = this.fieldInfos.get(this.idInfo.getFields().iterator().next());
            field.prepareAttributeOverrides(this.idInfo.getEmbeddedEntityInfo());
        }
        this.attributeOverrides = Collections.unmodifiableMap(this.attributeOverrides);
    }

    protected void prepareJoinColumns() {
        for (FieldInfo field : this.fieldInfos.values()) {
            if (!Converter.isEntity(field.getConverter())) continue;
            EntityInfo etInfo = this.trxManagerInfo.getEntityInfo(field.getType());
            field.prepareJoinColumns(etInfo);
        }
        this.joinColumns = Collections.unmodifiableMap(this.joinColumns);
        Map<String, EntityNative.ColumnConverter> columnConvertersEi = EntityInfo0.getColumnConverters(this);
        this.nativeDefinition.setColumnConverters(Collections.unmodifiableMap(columnConvertersEi));
    }

    protected void prepareDefinition() {
        for (FieldInfo field : this.fieldInfos.values()) {
            field.prepareDefinition();
        }
    }
}

