/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.EnumType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityInfo0;
import net.ideahut.springboot.entity.EntityNative0;
import net.ideahut.springboot.entity.EntityNative1;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.SessionCallable;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.mapping.Table;
import org.hibernate.query.Query;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.springframework.util.Assert;

public class EntityNative {
    private EntityNative() {
    }

    public static <T> Query<T> queryOf(SharedSessionContract session, String sql) {
        return EntityNative0.queryOf(session, sql, null, null, null);
    }

    public static <T> Query<T> queryOf(SharedSessionContract session, String sql, List<Parameter> parameters) {
        return EntityNative0.queryOf(session, sql, parameters, null, null);
    }

    public static <T> Query<T> queryOf(SharedSessionContract session, String sql, List<Parameter> parameters, Integer start, Integer limit) {
        return EntityNative0.queryOf(session, sql, parameters, start, limit);
    }

    public static String tableReplica(EntityInfo entityInfo, Integer replica) {
        Table table = entityInfo.getTable();
        String schema = table.getSchema() != null ? table.getSchema() : "";
        return (String)(!schema.isEmpty() ? schema + "." : "") + table.getName() + (String)(replica != null && replica > 0 ? "_" + replica : "");
    }

    public static String aliasColumn(String alias, String column) {
        return (String)(alias != null && !alias.isEmpty() ? alias + "." : "") + column;
    }

    public static Integer appendSelect(FieldInfo fieldInfo, Select select, StringBuilder query, String alias, Integer idxSelect, boolean commaAtFirst) {
        return fieldInfo.getNativeDefinition().getSelectAppender().appendSelect(select, query, alias, idxSelect, commaAtFirst);
    }

    public static void appendInsert(FieldInfo fieldInfo, StringBuilder sqlInto, StringBuilder sqlValues, List<Parameter> parameters, Object entity) throws Exception {
        fieldInfo.getNativeDefinition().getUpdateAppender().appendInsert(sqlInto, sqlValues, parameters, entity);
    }

    public static void appendUpdate(FieldInfo fieldInfo, StringBuilder query, List<Parameter> parameters, Object entity) throws Exception {
        fieldInfo.getNativeDefinition().getUpdateAppender().appendUpdate(query, parameters, entity);
    }

    public static <T> T valueOf(Select select, Object[] data) throws Exception {
        return EntityNative0.valueOf(select, data);
    }

    public static int valueOf(FieldInfo fieldInfo, Object[] data, Object entity, int start) throws Exception {
        return fieldInfo.getNativeDefinition().getSelectValue().valueOf(data, entity, start).getLast();
    }

    public static Object enumValue(FieldInfo fieldInfo, Object value) {
        Object object = fieldInfo.getConverter().convert(value);
        object = EnumType.STRING.equals((Object)fieldInfo.getEnumType()) ? fieldInfo.getNativeDefinition().getEnumDefinition().getObjectNameMap().get(object) : fieldInfo.getNativeDefinition().getEnumDefinition().getObjectOrdinalMap().get(object);
        return object;
    }

    public static <T> List<T> entitesOf(List<Object[]> rows, Session session, EntityInfo entityInfo, List<Select> selects, List<String> load) throws Exception {
        return EntityNative0.entitesOf(rows, session, entityInfo, selects, load);
    }

    private static <T> void validate(Session session, EntityInfo info, T entity) {
        Assert.notNull((Object)session, (String)"session is required");
        EntityNative.validate(info, entity);
    }

    private static <T> void validate(EntityInfo info, T entity) {
        Assert.notNull((Object)info, (String)"info is required");
        Assert.notNull(entity, (String)"entity is required");
        Assert.isTrue((boolean)info.getEntityClass().equals(entity.getClass()), (String)("Invalid entity type: " + entity.getClass().getName() + "!=" + info.getEntityClass().getName()));
    }

    public static <T> T reload(final EntityInfo info, final Integer replica, final T entity) {
        EntityNative.validate(info, entity);
        return info.getTrxManagerInfo().transaction(new SessionCallable<T>(){

            @Override
            public T call(Session session) throws Exception {
                return EntityNative0.reload(session, info, replica, entity);
            }
        });
    }

    public static <T> T reload(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        EntityNative.validate(session, info, entity);
        return EntityNative0.reload(session, info, replica, entity);
    }

    public static String generateInIdsQuery(List<Object> ids, EntityInfo entityInfo, String alias, List<Parameter> parameters, Integer startIndex) {
        if (ids != null) {
            return entityInfo.getNativeDefinition().getInIdsQuery().getInIdsQuery(ids, alias, parameters, startIndex);
        }
        return "";
    }

    public static <T> T insert(final EntityInfo info, final Integer replica, final T entity) {
        EntityNative.validate(info, entity);
        return info.getTrxManagerInfo().transaction(true, new SessionCallable<T>(){

            @Override
            public T call(Session session) throws Exception {
                return EntityNative1.insert(session, info, replica, entity);
            }
        });
    }

    public static <T> T insert(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        EntityNative.validate(session, info, entity);
        return EntityNative1.insert(session, info, replica, entity);
    }

    public static <T> T update(final EntityInfo info, final Integer replica, final T entity) {
        EntityNative.validate(info, entity);
        return info.getTrxManagerInfo().transaction(true, new SessionCallable<T>(){

            @Override
            public T call(Session session) throws Exception {
                return EntityNative1.update(session, info, replica, entity);
            }
        });
    }

    public static <T> T update(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        EntityNative.validate(session, info, entity);
        return EntityNative1.update(session, info, replica, entity);
    }

    public static <T> T delete(final EntityInfo info, final Integer replica, final T entity) {
        EntityNative.validate(info, entity);
        return info.getTrxManagerInfo().transaction(true, new SessionCallable<T>(){

            @Override
            public T call(Session session) throws Exception {
                return EntityNative1.delete(session, info, replica, entity);
            }
        });
    }

    public static <T> T delete(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        EntityNative.validate(session, info, entity);
        return EntityNative1.delete(session, info, replica, entity);
    }

    public static <T> T save(final EntityInfo info, final Integer replica, final T entity) {
        EntityNative.validate(info, entity);
        return info.getTrxManagerInfo().transaction(true, new SessionCallable<T>(){

            @Override
            public T call(Session session) throws Exception {
                return EntityNative1.save(session, info, replica, entity);
            }
        });
    }

    public static <T> T save(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        EntityNative.validate(session, info, entity);
        return EntityNative1.save(session, info, replica, entity);
    }

    public static <T> T saveOrUpdate(final EntityInfo info, final Integer replica, final T entity) {
        EntityNative.validate(info, entity);
        return info.getTrxManagerInfo().transaction(true, new SessionCallable<T>(){

            @Override
            public T call(Session session) throws Exception {
                return EntityNative1.saveOrUpdate(session, info, replica, entity);
            }
        });
    }

    public static <T> T saveOrUpdate(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        EntityNative.validate(session, info, entity);
        return EntityNative1.saveOrUpdate(session, info, replica, entity);
    }

    public static class Select {
        @JsonIgnore
        private final EntityInfo entityInfo;
        private final int index;
        private final FieldInfo store;
        private final List<FieldInfo> fields = new ArrayList<FieldInfo>();

        private Select(EntityInfo entityInfo, Integer index, FieldInfo store) {
            this.entityInfo = entityInfo;
            this.index = index;
            this.store = store;
        }

        public static Select of(EntityInfo entityInfo, int index, FieldInfo store) {
            return new Select(entityInfo, index, store);
        }

        public EntityInfo getEntityInfo() {
            return this.entityInfo;
        }

        public int getIndex() {
            return this.index;
        }

        public FieldInfo getStore() {
            return this.store;
        }

        public List<FieldInfo> getFields() {
            return this.fields;
        }
    }

    public static class ColumnConverter {
        private final String column;
        private final Converter converter;

        private ColumnConverter(String column, Converter converter) {
            this.column = column;
            this.converter = converter;
        }

        public static ColumnConverter of(String column, Converter converter) {
            return new ColumnConverter(column, converter);
        }

        public static ColumnConverter of(String column, Class<?> type, String format, EnumType enumType) {
            return new ColumnConverter(column, Converter.of(type, format, enumType));
        }

        public String getColumn() {
            return this.column;
        }

        public Converter getConverter() {
            return this.converter;
        }
    }

    public static class LazyLoad {
        private boolean isLoad;
        private Map<String, LoadField> mapLoadField;

        private LazyLoad(EntityInfo entityInfo, Integer replica, List<String> load) {
            LoadField loadField;
            FieldInfo fieldInfo;
            boolean isLoadEi;
            LinkedHashMap<String, LoadField> mapLoadFieldEi = new LinkedHashMap<String, LoadField>();
            boolean bl = isLoadEi = load != null && !load.isEmpty();
            if (isLoadEi) {
                for (String name : load) {
                    if (!entityInfo.getLazyObjectFields().containsKey(name)) continue;
                    fieldInfo = entityInfo.getFieldInfo(name);
                    loadField = new LoadField(entityInfo, fieldInfo, replica);
                    mapLoadFieldEi.put(name, loadField);
                }
            }
            for (String name : entityInfo.getEagerObjectFields().keySet()) {
                if (mapLoadFieldEi.containsKey(name)) continue;
                fieldInfo = entityInfo.getFieldInfo(name);
                loadField = new LoadField(entityInfo, fieldInfo, replica);
                mapLoadFieldEi.put(name, loadField);
            }
            this.isLoad = isLoadEi = !mapLoadFieldEi.isEmpty();
            this.mapLoadField = Collections.unmodifiableMap(mapLoadFieldEi);
        }

        public static LazyLoad of(EntityInfo entityInfo, Integer replica, List<String> load) {
            return new LazyLoad(entityInfo, replica, load);
        }

        public void reload(Session session, Object entity) throws Exception {
            if (this.isLoad) {
                for (Map.Entry<String, LoadField> entry : this.mapLoadField.entrySet()) {
                    entry.getValue().reload(session, entity);
                }
            }
        }

        public void destroy() {
            for (LoadField loadField : this.mapLoadField.values()) {
                loadField.destroy();
            }
            this.mapLoadField = null;
        }
    }

    private static class LoadField {
        private FieldInfo parentFieldInfo;
        private String query;
        private Select select;
        private EntityInfo entityInfo;
        private FieldInfo refIdFieldInfo;
        private boolean isEmbedded = false;
        private Map<String, FieldInfo> idColumns;
        private Map<String, Object> mapLoaded = new LinkedHashMap<String, Object>();

        private LoadField(EntityInfo parentEntityInfo, FieldInfo parentFieldInfo, Integer replica) {
            LinkedHashMap<String, FieldInfo> idColumnsEi = new LinkedHashMap<String, FieldInfo>();
            FieldInfo refIdFieldInfoEi = null;
            EntityInfo entityInfoEi = parentEntityInfo.getTrxManagerInfo().getEntityInfo(parentFieldInfo.getType());
            IdInfo idInfo = entityInfoEi.getIdInfo();
            if (EntityIdType.STANDARD == idInfo.getIdType()) {
                String column;
                fieldInfo = entityInfoEi.getFieldInfo(idInfo.getFields().iterator().next());
                if (parentFieldInfo.hasJoinColumns() && (refIdFieldInfoEi = parentEntityInfo.getColumnInfo(column = parentFieldInfo.getJoinColumns().getColums().iterator().next())) != null && refIdFieldInfoEi.getType().equals(fieldInfo.getType())) {
                    refIdFieldInfoEi = null;
                }
                idColumnsEi.put(fieldInfo.getColumn().getName(), fieldInfo);
            } else if (EntityIdType.EMBEDDED == idInfo.getIdType()) {
                this.isEmbedded = true;
                fieldInfo = entityInfoEi.getFieldInfo(idInfo.getFields().iterator().next());
                if (fieldInfo.hasAttributeOverrides()) {
                    AttributeOverrides attributeOverrides = fieldInfo.getAttributeOverrides();
                    for (String column : attributeOverrides.getColums()) {
                        idColumnsEi.put(column, attributeOverrides.getFieldInfo(column));
                    }
                } else {
                    EntityInfo embeddedInfo = idInfo.getEmbeddedEntityInfo();
                    for (String name : embeddedInfo.getFieldInfoNames()) {
                        FieldInfo emFlInfo = embeddedInfo.getFieldInfo(name);
                        idColumnsEi.put(emFlInfo.getColumn().getName(), emFlInfo);
                    }
                }
            } else if (EntityIdType.COMPOSITE == idInfo.getIdType()) {
                Iterator<String> iter = idInfo.getFields().iterator();
                while (iter.hasNext()) {
                    FieldInfo fieldInfo = entityInfoEi.getFieldInfo(iter.next());
                    idColumnsEi.put(fieldInfo.getColumn().getName(), fieldInfo);
                }
            }
            StringBuilder selql = new StringBuilder();
            this.select = Select.of(entityInfoEi, 0, null);
            for (String field : this.select.getEntityInfo().getFieldInfoNames()) {
                FieldInfo fieldInfo = this.select.getEntityInfo().getFieldInfo(field);
                EntityNative.appendSelect(fieldInfo, this.select, selql, null, 0, false);
            }
            this.query = "select " + selql.deleteCharAt(selql.length() - 1) + " from " + EntityNative.tableReplica(entityInfoEi, replica);
            this.parentFieldInfo = parentFieldInfo;
            this.entityInfo = entityInfoEi;
            this.idColumns = Collections.unmodifiableMap(idColumnsEi);
            this.refIdFieldInfo = refIdFieldInfoEi;
        }

        private Map<String, Parameter> getIdMap(Object object) throws Exception {
            Object id = this.isEmbedded ? this.entityInfo.getFieldInfo(this.entityInfo.getIdInfo().getFields().iterator().next()).getValue(object) : object;
            if (id != null) {
                LinkedHashMap<String, Parameter> map = new LinkedHashMap<String, Parameter>();
                for (String idColumn : this.idColumns.keySet()) {
                    FieldInfo fieldInfo = this.idColumns.get(idColumn);
                    Parameter parameter = Parameter.of(fieldInfo.getHibernateType(), fieldInfo.getValue(id));
                    map.put(idColumn, parameter);
                }
                return map;
            }
            return null;
        }

        private void reload(Session session, Object entity) throws Exception {
            Map<String, Parameter> idMap;
            Object refIdValue;
            Object value = this.parentFieldInfo.getValue(entity);
            if (value == null && this.refIdFieldInfo != null && (refIdValue = this.refIdFieldInfo.getValue(entity)) != null) {
                value = this.parentFieldInfo.createEntity();
                this.entityInfo.getFieldInfo(this.entityInfo.getIdInfo().getFields().iterator().next()).setValue(value, refIdValue);
            }
            if (value != null && (idMap = this.getIdMap(value)) != null) {
                String key = EntityInfo0.mapper.writeAsString(idMap, 1);
                if (this.mapLoaded.containsKey(key)) {
                    Object object = this.mapLoaded.get(key);
                    if (object != null) {
                        this.parentFieldInfo.setValue(entity, object);
                    }
                } else {
                    ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                    Object whereQl = "where 1=1 ";
                    for (Map.Entry<String, Parameter> entry : idMap.entrySet()) {
                        whereQl = (String)whereQl + "and " + entry.getKey() + "=? ";
                        parameters.add(entry.getValue());
                    }
                    Object[] data = (Object[])EntityNative.queryOf((SharedSessionContract)session, this.query + " " + (String)whereQl, parameters).uniqueResult();
                    if (data != null) {
                        Object object = EntityNative.valueOf(this.select, data);
                        this.mapLoaded.put(key, object);
                        if (object != null) {
                            this.parentFieldInfo.setValue(entity, object);
                        }
                    } else {
                        this.mapLoaded.put(key, null);
                    }
                    parameters.clear();
                }
                idMap.clear();
            }
        }

        private void destroy() {
            this.parentFieldInfo = null;
            this.query = null;
            this.select = null;
            this.entityInfo = null;
            this.idColumns = null;
            this.mapLoaded = null;
        }
    }

    public static class Parameter {
        private final Type hibernateType;
        private final Class type;
        private final Object value;

        private Parameter(Type hibernateType, Object value) {
            this.hibernateType = hibernateType;
            this.value = value;
            this.type = hibernateType != null ? ((BasicType)hibernateType).getBindableJavaType() : null;
        }

        public static Parameter of(Type hibernateType, Object value) {
            return new Parameter(hibernateType, value);
        }

        public Type getHibernateType() {
            return this.hibernateType;
        }

        public Class getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

