/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.ideahut.springboot.audit.AuditInfo;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.EntityNative0;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.NativeAutoGeneratedId;
import net.ideahut.springboot.entity.NativeInsertIdentity;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.util.TimeUtil;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;

final class EntityNative1 {
    private static final String ATTR_SESSION_ACTION = EntityNative.class.getName() + "::SessionAction";

    private EntityNative1() {
    }

    private static void setSessionAction(SharedSessionContract session, Integer action) {
        RequestContext context = RequestContext.currentContext();
        HashMap<SharedSessionContract, Integer> sessions = (HashMap<SharedSessionContract, Integer>)context.getAttribute(ATTR_SESSION_ACTION);
        if (sessions == null) {
            sessions = new HashMap<SharedSessionContract, Integer>();
            context.setAttribute(ATTR_SESSION_ACTION, sessions);
        }
        sessions.put(session, action);
    }

    private static Integer getSessionAction(SharedSessionContract session) {
        RequestContext context = RequestContext.currentContext();
        Map sessions = (Map)context.getAttribute(ATTR_SESSION_ACTION);
        if (sessions != null) {
            return (Integer)sessions.remove(session);
        }
        return null;
    }

    protected static <T> T insert(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        AuditInfo.context().setReplica(info.getEntityClass(), replica);
        TrxManagerInfo.onPreInsert(session.getSessionFactory(), entity);
        IdInfo idInfo = info.getIdInfo();
        NativeInsertIdentity insertIdentity = info.getNativeDefinition().getInsertIdentity();
        NativeAutoGeneratedId autoGeneratedId = info.getNativeDefinition().getAutoGeneratedId();
        if (insertIdentity == null && autoGeneratedId != null) {
            autoGeneratedId.setGeneratedId((SharedSessionContract)session, entity);
        }
        EntityHelper.setAudit(entity, false);
        String table = EntityNative.tableReplica(info, replica);
        StringBuilder sqlInto = new StringBuilder("insert into ").append(table).append("(");
        StringBuilder sqlValues = new StringBuilder("values (");
        ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();
        HashSet<String> names = new HashSet<String>(info.getFieldInfoNames());
        if (insertIdentity != null) {
            names.remove(idInfo.getFields().iterator().next());
        }
        for (String name : names) {
            info.getFieldInfo(name).getNativeDefinition().getUpdateAppender().appendInsert(sqlInto, sqlValues, parameters, entity);
        }
        sqlInto.deleteCharAt(sqlInto.length() - 1).append(")");
        sqlValues.deleteCharAt(sqlValues.length() - 1).append(")");
        if (insertIdentity != null) {
            insertIdentity.executeInsert((SharedSessionContract)session, sqlInto.toString(), entity, sqlValues.toString(), parameters);
        } else {
            EntityNative.queryOf((SharedSessionContract)session, sqlInto.toString() + " " + sqlValues.toString(), parameters).executeUpdate();
        }
        TrxManagerInfo.onPostInsert(session, entity);
        return entity;
    }

    protected static <T> T update(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        AuditInfo.context().setReplica(info.getEntityClass(), replica);
        EntityNative0.FreshEntity freshEntity = EntityNative0.FreshEntity.of(session, entity, info, replica, false);
        if (freshEntity.getIdColumsValue().isEmpty()) {
            throw new Exception("Id is required");
        }
        Integer action = EntityNative1.getSessionAction((SharedSessionContract)session);
        if (action == null) {
            action = 2;
        }
        if (1 == action) {
            TrxManagerInfo.onPreInsert(session.getSessionFactory(), entity);
        } else if (3 == action) {
            TrxManagerInfo.onPreDelete(session.getSessionFactory(), entity);
        } else {
            TrxManagerInfo.onPreUpdate(session.getSessionFactory(), entity);
        }
        IdInfo idInfo = info.getIdInfo();
        HashSet<String> ignoreFields = new HashSet<String>(idInfo.getFields());
        if (action == 2) {
            ignoreFields.add("createdBy");
            ignoreFields.add("createdOn");
        }
        HashSet<String> fieldNames = new HashSet<String>(info.getFieldInfoNames());
        fieldNames.removeAll(ignoreFields);
        EntityHelper.setAudit(entity, true);
        String table = EntityNative.tableReplica(info, replica);
        StringBuilder sql = new StringBuilder("update ").append(table).append(" set ");
        ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();
        for (String string : fieldNames) {
            info.getFieldInfo(string).getNativeDefinition().getUpdateAppender().appendUpdate(sql, parameters, entity);
        }
        sql.deleteCharAt(sql.length() - 1).append(" where 1=1 ");
        for (Map.Entry entry : freshEntity.getIdColumsValue().entrySet()) {
            sql.append("and ").append((String)entry.getKey()).append("=? ");
            parameters.add((EntityNative.Parameter)entry.getValue());
        }
        EntityNative.queryOf((SharedSessionContract)session, sql.toString(), parameters).executeUpdate();
        if (1 == action) {
            TrxManagerInfo.onPostInsert(session, entity);
        } else if (3 == action) {
            TrxManagerInfo.onPostDelete(session, entity);
        } else {
            TrxManagerInfo.onPostUpdate(session, entity);
        }
        return entity;
    }

    protected static <T> T delete(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        AuditInfo.context().setReplica(info.getEntityClass(), replica);
        if (entity instanceof EntitySoftDelete) {
            EntityNative0.FreshEntity freshEntity = EntityNative0.FreshEntity.of(session, entity, info, replica, true);
            if (freshEntity.getIdColumsValue().isEmpty()) {
                throw new Exception("Id is required");
            }
            EntitySoftDelete softDelete = (EntitySoftDelete)freshEntity.getObject();
            if (softDelete != null && softDelete.getDeletedOn() == null) {
                softDelete.setDeletedOn(TimeUtil.currentEpochMillis());
                EntityNative1.setSessionAction((SharedSessionContract)session, 3);
                return (T)EntityNative1.update(session, info, replica, softDelete);
            }
        } else {
            EntityNative0.FreshEntity freshEntity = EntityNative0.FreshEntity.of(session, entity, info, replica, false);
            if (freshEntity.getIdColumsValue().isEmpty()) {
                throw new Exception("Id is required");
            }
            TrxManagerInfo.onPreDelete(session.getSessionFactory(), entity);
            String sql = "delete from " + EntityNative.tableReplica(info, replica) + " where 1=1 ";
            ArrayList<EntityNative.Parameter> parameters = new ArrayList<EntityNative.Parameter>();
            for (Map.Entry<String, EntityNative.Parameter> entry : freshEntity.getIdColumsValue().entrySet()) {
                sql = sql + "and " + entry.getKey() + "=? ";
                parameters.add(entry.getValue());
            }
            EntityNative.queryOf((SharedSessionContract)session, sql, parameters).executeUpdate();
            TrxManagerInfo.onPostDelete(session, entity);
        }
        return entity;
    }

    protected static <T> T save(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        if (entity instanceof EntitySoftDelete) {
            EntityNative0.FreshEntity freshEntity = EntityNative0.FreshEntity.of(session, entity, info, replica, true);
            if (freshEntity.getIdColumsValue().isEmpty()) {
                throw new Exception("Id is required");
            }
            EntitySoftDelete softDelete = (EntitySoftDelete)freshEntity.getObject();
            if (softDelete != null) {
                if (softDelete.getDeletedOn() == null) {
                    throw new SQLIntegrityConstraintViolationException("Duplicate entry '" + entity.getClass().getSimpleName() + "' for key '" + freshEntity.getIdColumsValue().toString() + "'");
                }
                softDelete.setDeletedOn(null);
                EntityHelper.setAudit(softDelete, false);
                EntityNative1.setSessionAction((SharedSessionContract)session, 1);
                return (T)EntityNative1.update(session, info, replica, softDelete);
            }
            return EntityNative1.insert(session, info, replica, entity);
        }
        return EntityNative1.insert(session, info, replica, entity);
    }

    protected static <T> T saveOrUpdate(Session session, EntityInfo info, Integer replica, T entity) throws Exception {
        EntityNative0.FreshEntity freshEntity = EntityNative0.FreshEntity.of(session, entity, info, replica, true);
        if (freshEntity.getIdColumsValue().isEmpty()) {
            throw new RuntimeException("Id is required");
        }
        Object result = null;
        Object object = freshEntity.getObject();
        if (object != null) {
            boolean isReplaceSoftDelete;
            boolean bl = isReplaceSoftDelete = object instanceof EntitySoftDelete && ((EntitySoftDelete)object).getDeletedOn() != null;
            if (isReplaceSoftDelete) {
                info.merge(entity, object, false, null);
                ((EntitySoftDelete)object).setDeletedOn(null);
                EntityHelper.setAudit(object, false);
                EntityNative1.setSessionAction((SharedSessionContract)session, 1);
                EntityNative1.update(session, info, replica, object);
            } else if (info.merge(entity, object, false, null)) {
                result = EntityNative1.update(session, info, replica, object);
            }
        } else {
            result = EntityNative1.insert(session, info, replica, entity);
        }
        return (T)result;
    }
}

