/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.BasicDataType;
import net.ideahut.springboot.entity.DatabaseType;
import net.ideahut.springboot.entity.EntityBase;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.FieldInfo0;
import net.ideahut.springboot.entity.JoinColumns;
import net.ideahut.springboot.entity.NativeFieldDefinition;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.mapping.Column;
import org.hibernate.type.Type;

public class FieldInfo {
    @JsonIgnore
    private final EntityInfo entityInfo;
    private final boolean lazyObject;
    private final boolean lazyCollection;
    private final Class<?> collectionGenericType;
    private final boolean eagerObject;
    private final String format;
    private final Integer length;
    private final Integer scale;
    private final Integer precision;
    private final Column column;
    private final boolean embedded;
    private final ValueSet valueSet;
    private final ValueGet valueGet;
    private final boolean isLob;
    private JoinColumns joinColumns;
    private AttributeOverrides attributeOverrides;
    private Converter converter;
    private Type hibernateType;
    private NativeFieldDefinition nativeDefinition;
    private EnumType enumType;
    private Constructor<?> constructor;
    protected final Field field;
    protected final Method setter;
    protected final Method getter;
    protected Boolean nullable;

    public FieldInfo(EntityInfo entityInfo, final Field field, Column column, boolean lazyObject, boolean lazyCollection, Class<?> collectionGenericType, boolean eagerObject, Boolean nullable, Integer length, Integer scale, Integer precision, boolean embedded) {
        Enumerated annEnumerated;
        Object jsonbDateFormat;
        this.field = field;
        Class<?> modelClass = field.getDeclaringClass();
        String fieldName = field.getName();
        String methodName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        Method setterFi = null;
        try {
            setterFi = modelClass.getMethod("set" + methodName, field.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setter = setterFi;
        Method getterFi = null;
        try {
            getterFi = modelClass.getMethod("get" + methodName, new Class[0]);
            if (!getterFi.getReturnType().equals(field.getType())) {
                getterFi = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getter = getterFi;
        String formatFi = null;
        if (FieldInfo0.jsonFormatClass != null) {
            Object jsonFormat = FieldInfo0.findAnnotation(FieldInfo0.jsonFormatClass, this);
            if (jsonFormat != null) {
                try {
                    formatFi = ((String)FieldInfo0.jsonFormatClass.getMethod("pattern", new Class[0]).invoke(jsonFormat, new Object[0])).trim();
                }
                catch (Exception exception) {}
            }
        } else if (FieldInfo0.jsonbDateFormatClass != null && (jsonbDateFormat = FieldInfo0.findAnnotation(FieldInfo0.jsonbDateFormatClass, this)) != null) {
            try {
                formatFi = ((String)FieldInfo0.jsonbDateFormatClass.getMethod("value", new Class[0]).invoke(jsonbDateFormat, new Object[0])).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((annEnumerated = FieldInfo0.findAnnotation(Enumerated.class, this)) != null) {
            this.enumType = annEnumerated.value();
        }
        ValueSet valueSetEi = this.setter != null ? new ValueSet(){

            @Override
            public void set(Object target, Object value) throws Exception {
                FieldInfo.this.setter.invoke(target, value);
            }
        } : new ValueSet(){

            @Override
            public void set(Object target, Object value) throws Exception {
                field.set(target, value);
            }
        };
        ValueGet valueGetEi = this.getter != null ? new ValueGet(){

            @Override
            public Object get(Object target) throws Exception {
                return FieldInfo.this.getter.invoke(target, new Object[0]);
            }
        } : new ValueGet(){

            @Override
            public Object get(Object target) throws Exception {
                return field.get(target);
            }
        };
        Lob anLob = this.getAnnotation(Lob.class);
        boolean isLobEi = anLob != null;
        this.entityInfo = entityInfo;
        this.eagerObject = eagerObject;
        this.lazyObject = lazyObject;
        this.lazyCollection = lazyCollection;
        this.collectionGenericType = collectionGenericType;
        this.format = formatFi;
        this.nullable = nullable;
        this.length = length;
        this.scale = scale;
        this.precision = precision;
        this.column = column;
        this.embedded = embedded;
        this.valueGet = valueGetEi;
        this.valueSet = valueSetEi;
        this.isLob = isLobEi;
    }

    public EntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Class<?> getCollectionGenericType() {
        return this.collectionGenericType;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return FieldInfo0.findAnnotation(annotationClass, this);
    }

    public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        return FieldInfo0.findAnnotationsByType(annotationClass, (FieldInfo)this);
    }

    public Converter getConverter() {
        return this.converter;
    }

    public Type getHibernateType() {
        return this.hibernateType;
    }

    public boolean isEagerObject() {
        return this.eagerObject;
    }

    public boolean isLazyObject() {
        return this.lazyObject;
    }

    public boolean isLazyCollection() {
        return this.lazyCollection;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public String getFormat() {
        return this.format;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Column getColumn() {
        return this.column;
    }

    public JoinColumns getJoinColumns() {
        return this.joinColumns;
    }

    public boolean isLob() {
        return this.isLob;
    }

    public boolean hasJoinColumns() {
        return this.joinColumns != null && !this.joinColumns.isColumnEmpty();
    }

    public boolean hasJoinRelations() {
        return this.joinColumns != null && !this.joinColumns.isRelationEmpty();
    }

    public AttributeOverrides getAttributeOverrides() {
        return this.attributeOverrides;
    }

    public boolean hasAttributeOverrides() {
        return this.attributeOverrides != null && !this.attributeOverrides.isEmpty();
    }

    public void setValue(Object target, Object value) throws Exception {
        this.valueSet.set(target, value);
    }

    public Object getValue(Object target) throws Exception {
        return this.valueGet.get(target);
    }

    public Object convert(Object value) {
        if (this.converter == null) {
            return null;
        }
        try {
            return this.converter.convert(value);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    protected EnumType getEnumType() {
        return this.enumType;
    }

    protected void fieldValue(Object target, Object value) throws Exception {
        this.field.set(target, value);
    }

    protected Object fieldValue(Object target) throws Exception {
        return this.field.get(target);
    }

    protected NativeFieldDefinition getNativeDefinition() {
        return this.nativeDefinition;
    }

    protected <T> T createEntity() throws Exception {
        if (this.constructor != null) {
            return (T)this.constructor.newInstance(new Object[0]);
        }
        return null;
    }

    protected void prepareConverter() {
        EntityInfo etInfo;
        Class<?> type = this.getType();
        Converter converter = Converter.of(type, this.format, this.enumType);
        if (converter == null && (etInfo = this.entityInfo.getTrxManagerInfo().getEntityInfo(type)) != null) {
            converter = Converter.of(EntityBase.class, this.format, this.enumType);
            try {
                this.constructor = type.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                throw FrameworkUtil.exception(e);
            }
        }
        if (this.isLob) {
            DatabaseType databaseType = this.entityInfo.getTrxManagerInfo().getIntegrator().getDatabaseType();
            this.hibernateType = String.class.isAssignableFrom(type) ? databaseType.getStringLobType() : BasicDataType.BLOB_TYPE;
        } else if (converter != null) {
            this.hibernateType = converter.getHibernateType();
        }
        this.converter = converter;
    }

    protected void prepareAttributeOverrides(EntityInfo entInf) {
        this.attributeOverrides = new AttributeOverrides(this, entInf);
        if (!this.attributeOverrides.getColums().isEmpty()) {
            this.entityInfo.attributeOverrides.put(this.getName(), this.attributeOverrides);
        }
    }

    protected void prepareJoinColumns(EntityInfo entInf) {
        this.joinColumns = new JoinColumns(this, entInf);
        if (this.joinColumns.getColums().isEmpty() && this.joinColumns.hasJoinObject()) {
            this.entityInfo.joinColumns.put(this.getName(), this.joinColumns);
        }
    }

    protected void prepareDefinition() {
        this.nativeDefinition = NativeFieldDefinition.of(this);
    }

    private static interface ValueGet {
        public Object get(Object var1) throws Exception;
    }

    private static interface ValueSet {
        public void set(Object var1, Object var2) throws Exception;
    }
}

