/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.ColumnValue;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;
import net.ideahut.springboot.entity.JoinField;
import net.ideahut.springboot.entity.JoinObject;

public class JoinColumns {
    private final FieldInfo fieldInfo;
    @JsonIgnore
    private final EntityInfo entityInfo;
    private final Map<String, FieldInfo> colums;
    private final Map<String, String> relations;
    private final ColumnValue columnValue;
    private JoinObject joinObject;

    protected JoinColumns(FieldInfo fieldInfoEi, EntityInfo entityInfoEi) {
        ManyToOne anManyToOne;
        LinkedHashMap<String, FieldInfo> columsEi = new LinkedHashMap<String, FieldInfo>();
        LinkedHashMap<String, String> relationsEi = new LinkedHashMap<String, String>();
        boolean hasJoinColumns = false;
        jakarta.persistence.JoinColumns anJoinColumns = fieldInfoEi.getAnnotation(jakarta.persistence.JoinColumns.class);
        if (anJoinColumns != null) {
            hasJoinColumns = true;
            this.joinObject = this.populate(fieldInfoEi, entityInfoEi, columsEi, relationsEi, anJoinColumns.value());
        } else {
            JoinColumn[] anJcolumns = (JoinColumn[])fieldInfoEi.getAnnotationsByType(JoinColumn.class);
            hasJoinColumns = anJcolumns != null && anJcolumns.length != 0;
            this.joinObject = this.populate(fieldInfoEi, entityInfoEi, columsEi, relationsEi, anJcolumns);
        }
        if (columsEi.isEmpty() && this.joinObject == null) {
            PrimaryKeyJoinColumns anPkJoinColumns = fieldInfoEi.getAnnotation(PrimaryKeyJoinColumns.class);
            if (anPkJoinColumns != null) {
                this.joinObject = this.populate(fieldInfoEi, entityInfoEi, columsEi, anPkJoinColumns.value());
            } else {
                PrimaryKeyJoinColumn[] anPkColumns = (PrimaryKeyJoinColumn[])fieldInfoEi.getAnnotationsByType(PrimaryKeyJoinColumn.class);
                if (anPkColumns != null) {
                    this.joinObject = this.populate(fieldInfoEi, entityInfoEi, columsEi, anPkColumns);
                }
            }
        }
        if (columsEi.isEmpty() && this.joinObject == null && !hasJoinColumns && (anManyToOne = fieldInfoEi.getAnnotation(ManyToOne.class)) != null) {
            IdInfo refIdInfo = entityInfoEi.getIdInfo();
            if (EntityIdType.EMBEDDED == refIdInfo.getIdType()) {
                EntityInfo embeddedInfo = refIdInfo.getEmbeddedEntityInfo();
                for (String name : embeddedInfo.getFieldInfoNames()) {
                    FieldInfo feInfo = embeddedInfo.getFieldInfo(name);
                    columsEi.put(fieldInfoEi.getName() + "_" + feInfo.getColumn().getName(), feInfo);
                    relationsEi.put(fieldInfoEi.getName() + "_" + feInfo.getColumn().getName(), feInfo.getColumn().getName());
                }
            } else {
                for (String name : refIdInfo.getFields()) {
                    FieldInfo feInfo = entityInfoEi.getFieldInfo(name);
                    columsEi.put(fieldInfoEi.getName() + "_" + feInfo.getColumn().getName(), feInfo);
                    relationsEi.put(fieldInfoEi.getName() + "_" + feInfo.getColumn().getName(), feInfo.getColumn().getName());
                }
            }
        }
        this.fieldInfo = fieldInfoEi;
        this.entityInfo = entityInfoEi;
        this.colums = Collections.unmodifiableMap(columsEi);
        this.relations = Collections.unmodifiableMap(relationsEi);
        final IdInfo idInfo = entityInfoEi.getIdInfo();
        ColumnValue columnValueEi = EntityIdType.EMBEDDED == idInfo.getIdType() ? new ColumnValue(){

            @Override
            public boolean setValue(Object object, String column, Object value) throws Exception {
                FieldInfo colInfo = JoinColumns.this.colums.get(column);
                if (colInfo != null) {
                    FieldInfo fid = JoinColumns.this.entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                    Object oid = fid.getValue(object);
                    if (oid == null) {
                        oid = idInfo.getEmbeddedEntityInfo().createEntity();
                    }
                    colInfo.setValue(oid, colInfo.convert(value));
                    fid.setValue(object, oid);
                    return true;
                }
                return false;
            }

            @Override
            public EntityNative.Parameter getParameter(Object object, String column) throws Exception {
                EntityNative.Parameter parameter;
                FieldInfo finfo = JoinColumns.this.colums.get(column);
                Object value = JoinColumns.this.fieldInfo.getValue(object);
                if (value != null) {
                    FieldInfo fid = JoinColumns.this.entityInfo.getFieldInfo(idInfo.getFields().iterator().next());
                    Object oid = fid.getValue(value);
                    parameter = EntityNative.Parameter.of(finfo.getHibernateType(), finfo.getValue(oid));
                } else {
                    parameter = EntityNative.Parameter.of(finfo.getHibernateType(), null);
                }
                return parameter;
            }
        } : new ColumnValue(){

            @Override
            public boolean setValue(Object object, String column, Object value) throws Exception {
                FieldInfo colInfo = JoinColumns.this.colums.get(column);
                if (colInfo != null) {
                    colInfo.setValue(object, colInfo.convert(value));
                    return true;
                }
                return false;
            }

            @Override
            public EntityNative.Parameter getParameter(Object object, String column) throws Exception {
                FieldInfo finfo = JoinColumns.this.colums.get(column);
                Object value = JoinColumns.this.fieldInfo.getValue(object);
                return EntityNative.Parameter.of(finfo.getHibernateType(), value != null ? finfo.getValue(value) : null);
            }
        };
        this.columnValue = columnValueEi;
    }

    private JoinObject populate(FieldInfo fieldInfoEi, EntityInfo entityInfoEi, Map<String, FieldInfo> columsEi, Map<String, String> relationsEi, JoinColumn[] joinColumns) {
        JoinObject joinObject = null;
        if (joinColumns != null && joinColumns.length != 0) {
            EntityInfo sourceEntityInfo = fieldInfoEi.getEntityInfo();
            IdInfo sourceIdInfo = sourceEntityInfo.getIdInfo();
            FieldInfo sourceEmbeddedInfo = null;
            AttributeOverrides sourceAttrOvers = null;
            if (EntityIdType.EMBEDDED == sourceIdInfo.getIdType() && (sourceEmbeddedInfo = sourceEntityInfo.getFieldInfo(sourceIdInfo.getFields().iterator().next())).hasAttributeOverrides()) {
                sourceAttrOvers = sourceEmbeddedInfo.getAttributeOverrides();
            }
            EntityInfo targetEntityInfo = entityInfoEi;
            IdInfo targetIdInfo = targetEntityInfo.getIdInfo();
            FieldInfo targetEmbeddedInfo = null;
            AttributeOverrides targetAttrOvers = null;
            if (EntityIdType.EMBEDDED == targetIdInfo.getIdType() && (targetEmbeddedInfo = targetEntityInfo.getFieldInfo(targetIdInfo.getFields().iterator().next())).hasAttributeOverrides()) {
                targetAttrOvers = targetEmbeddedInfo.getAttributeOverrides();
            }
            joinObject = new JoinObject();
            joinObject.sourceObject = sourceEntityInfo;
            joinObject.targetObject = targetEntityInfo;
            boolean nullable = true;
            for (JoinColumn joinColumn : joinColumns) {
                String refName;
                String name = joinColumn.name();
                if (name.isEmpty()) continue;
                JoinField joinField = new JoinField();
                if (nullable && !joinColumn.nullable()) {
                    nullable = false;
                }
                if ((refName = joinColumn.referencedColumnName()).isEmpty()) {
                    refName = name;
                }
                FieldInfo tgtFieldInfo = null;
                boolean isTgtAttrOvers = false;
                if (targetAttrOvers != null) {
                    tgtFieldInfo = targetAttrOvers.getFieldInfo(refName);
                    isTgtAttrOvers = true;
                } else {
                    tgtFieldInfo = entityInfoEi.getColumnInfo(refName);
                }
                if (tgtFieldInfo == null && EntityIdType.STANDARD == targetIdInfo.getIdType()) {
                    tgtFieldInfo = targetEntityInfo.getFieldInfo(targetIdInfo.getFields().iterator().next());
                }
                if (tgtFieldInfo != null) {
                    if (isTgtAttrOvers) {
                        joinField.targetFields.add(targetEmbeddedInfo);
                    }
                    joinField.targetFields.add(tgtFieldInfo);
                    if (joinColumn.insertable() && joinColumn.updatable()) {
                        columsEi.put(name, tgtFieldInfo);
                    }
                    relationsEi.put(name, refName);
                }
                boolean isSrcAttrOvers = false;
                FieldInfo srcFieldInfo = sourceEntityInfo.getColumnInfo(name);
                if (srcFieldInfo == null && sourceAttrOvers != null) {
                    srcFieldInfo = sourceAttrOvers.getFieldInfo(name);
                    isSrcAttrOvers = true;
                }
                if (srcFieldInfo != null) {
                    if (isSrcAttrOvers) {
                        joinField.sourceFields.add(sourceEmbeddedInfo);
                    }
                    joinField.sourceFields.add(srcFieldInfo);
                }
                joinObject.joinFields.add(joinField);
            }
            fieldInfoEi.nullable = nullable;
        }
        return joinObject;
    }

    private JoinObject populate(FieldInfo fieldInfoEi, EntityInfo entityInfoEi, Map<String, FieldInfo> columsEi, PrimaryKeyJoinColumn[] pkJoinColumns) {
        JoinObject joinObject = null;
        if (pkJoinColumns != null && pkJoinColumns.length != 0 && pkJoinColumns.length == 1) {
            PrimaryKeyJoinColumn pkJoinColumn = pkJoinColumns[0];
            EntityInfo sourceEntityInfo = fieldInfoEi.getEntityInfo();
            EntityInfo targetEntityInfo = entityInfoEi;
            joinObject = new JoinObject();
            joinObject.sourceObject = sourceEntityInfo;
            joinObject.targetObject = targetEntityInfo;
            FieldInfo srcFieldInfo = sourceEntityInfo.getColumnInfo(pkJoinColumn.name());
            if (srcFieldInfo == null) {
                srcFieldInfo = sourceEntityInfo.getFieldInfo(sourceEntityInfo.getIdInfo().getFields().iterator().next());
            }
            FieldInfo tgtFieldInfo = targetEntityInfo.getFieldInfo(targetEntityInfo.getIdInfo().getFields().iterator().next());
            JoinField joinField = new JoinField();
            joinField.sourceFields.add(srcFieldInfo);
            joinField.targetFields.add(tgtFieldInfo);
            joinObject.joinFields.add(joinField);
            fieldInfoEi.nullable = false;
        }
        return joinObject;
    }

    public boolean isColumnEmpty() {
        return this.colums.isEmpty();
    }

    public Set<String> getColums() {
        return this.colums.keySet();
    }

    public FieldInfo getFieldInfo(String column) {
        return this.colums.get(column);
    }

    public boolean isRelationEmpty() {
        return this.relations.isEmpty();
    }

    public Map<String, String> getRelations() {
        return this.relations;
    }

    public boolean hasJoinObject() {
        return this.joinObject != null;
    }

    public Object createObject() throws Exception {
        return this.entityInfo.createEntity();
    }

    public boolean setValue(Object object, String column, Object value) throws Exception {
        if (object != null && value != null) {
            return this.columnValue.setValue(object, column, value);
        }
        return false;
    }

    public EntityNative.Parameter getParameter(Object object, String column) throws Exception {
        if (object != null) {
            return this.columnValue.getParameter(object, column);
        }
        return null;
    }

    public void writeToObject(Object object) throws Exception {
        if (this.joinObject != null && this.joinObject.sourceObject.getEntityClass().isAssignableFrom(object.getClass())) {
            EntityInfo targetObject = this.joinObject.targetObject;
            for (JoinField joinField : this.joinObject.joinFields) {
                FieldInfo sourceField;
                List<FieldInfo> sourceFields = joinField.sourceFields;
                List<FieldInfo> targetFields = joinField.targetFields;
                if (sourceFields.isEmpty() || targetFields.isEmpty()) continue;
                Object sourceValue = object;
                Iterator<FieldInfo> iterator = sourceFields.iterator();
                while (iterator.hasNext() && (sourceValue = (sourceField = iterator.next()).getValue(sourceValue)) != null) {
                }
                if (sourceValue == null) continue;
                Object targetValue = this.fieldInfo.getValue(object);
                if (targetValue == null) {
                    targetValue = targetObject.createEntity();
                }
                Object prevValue = targetValue;
                for (FieldInfo targetField : targetFields) {
                    if (Converter.isEntity(targetField.getConverter()) || targetField.isEmbedded()) {
                        Object nextValue = targetField.getValue(prevValue);
                        if (nextValue == null) {
                            nextValue = targetField.createEntity();
                        }
                        targetField.setValue(prevValue, nextValue);
                        prevValue = nextValue;
                        continue;
                    }
                    if (prevValue == null) continue;
                    targetField.setValue(prevValue, sourceValue);
                }
                this.fieldInfo.setValue(object, targetValue);
            }
        }
    }
}

