/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import java.util.List;
import java.util.Map;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.EntityIdType;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityNative;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.IdInfo;

interface NativeFreshAppender {
    public void append(Object var1, StringBuilder var2, List<EntityNative.Parameter> var3, Map<String, EntityNative.Parameter> var4) throws Exception;

    public static NativeFreshAppender of(final EntityInfo info) {
        NativeFreshAppender appender = null;
        final IdInfo idInfo = info.getIdInfo();
        if (EntityIdType.COMPOSITE.equals((Object)idInfo.getIdType())) {
            appender = new NativeFreshAppender(){

                @Override
                public void append(Object entity, StringBuilder query, List<EntityNative.Parameter> parameters, Map<String, EntityNative.Parameter> idColumsValues) throws Exception {
                    for (String name : idInfo.getFields()) {
                        FieldInfo field = info.getFieldInfo(name);
                        Object value = field.getValue(entity);
                        EntityNative.Parameter parameter = EntityNative.Parameter.of(field.getHibernateType(), value);
                        idColumsValues.put(field.getColumn().getName(), parameter);
                        query.append("and ").append(field.getColumn().getName()).append("=? ");
                        parameters.add(parameter);
                    }
                }
            };
        } else if (EntityIdType.EMBEDDED.equals((Object)idInfo.getIdType())) {
            final FieldInfo embedField = info.getFieldInfo(idInfo.getFields().iterator().next());
            appender = embedField.hasAttributeOverrides() ? new NativeFreshAppender(){

                @Override
                public void append(Object entity, StringBuilder query, List<EntityNative.Parameter> parameters, Map<String, EntityNative.Parameter> idColumsValues) throws Exception {
                    Object embedValue = embedField.getValue(entity);
                    AttributeOverrides attributeOverrides = embedField.getAttributeOverrides();
                    for (String column : attributeOverrides.getColums()) {
                        FieldInfo field = attributeOverrides.getFieldInfo(column);
                        Object value = field.getValue(embedValue);
                        EntityNative.Parameter parameter = EntityNative.Parameter.of(field.getHibernateType(), value);
                        idColumsValues.put(column, parameter);
                        query.append("and ").append(column).append("=? ");
                        parameters.add(parameter);
                    }
                }
            } : new NativeFreshAppender(){

                @Override
                public void append(Object entity, StringBuilder query, List<EntityNative.Parameter> parameters, Map<String, EntityNative.Parameter> idColumsValues) throws Exception {
                    Object embedValue = embedField.getValue(entity);
                    EntityInfo embedEntity = idInfo.getEmbeddedEntityInfo();
                    for (String fname : embedEntity.getFieldInfoNames()) {
                        FieldInfo field = embedEntity.getFieldInfo(fname);
                        Object value = field.getValue(embedValue);
                        EntityNative.Parameter parameter = EntityNative.Parameter.of(field.getHibernateType(), value);
                        idColumsValues.put(field.getColumn().getName(), parameter);
                        query.append("and ").append(field.getColumn().getName()).append("=? ");
                        parameters.add(parameter);
                    }
                }
            };
        } else if (EntityIdType.STANDARD.equals((Object)idInfo.getIdType())) {
            final FieldInfo stdField = info.getFieldInfo(idInfo.getFields().iterator().next());
            appender = new NativeFreshAppender(){

                @Override
                public void append(Object entity, StringBuilder query, List<EntityNative.Parameter> parameters, Map<String, EntityNative.Parameter> idColumsValues) throws Exception {
                    Object value = stdField.getValue(entity);
                    EntityNative.Parameter parameter = EntityNative.Parameter.of(stdField.getHibernateType(), value);
                    idColumsValues.put(stdField.getColumn().getName(), parameter);
                    query.append("and ").append(stdField.getColumn().getName()).append("=? ");
                    parameters.add(parameter);
                }
            };
        }
        return appender;
    }
}

