/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.EnumType;
import java.io.Reader;
import java.lang.reflect.Proxy;
import net.ideahut.springboot.converter.Converter;
import net.ideahut.springboot.entity.AttributeOverrides;
import net.ideahut.springboot.entity.BasicDataType;
import net.ideahut.springboot.entity.DatabaseType;
import net.ideahut.springboot.entity.FieldInfo;
import net.ideahut.springboot.entity.JoinColumns;
import org.apache.commons.io.IOUtils;
import org.hibernate.engine.jdbc.SerializableBlobProxy;
import org.hibernate.engine.jdbc.SerializableClobProxy;

interface NativeSelectValue {
    public Nsv valueOf(Object[] var1, Object var2, int var3) throws Exception;

    public static NativeSelectValue of(final FieldInfo info) {
        NativeSelectValue selectValue = null;
        if (info.hasAttributeOverrides()) {
            selectValue = new NativeSelectValue(){

                @Override
                public Nsv valueOf(Object[] data, Object entity, int start) throws Exception {
                    AttributeOverrides attributeOverrides = info.getAttributeOverrides();
                    Object value = attributeOverrides.createObject();
                    boolean setted = false;
                    int i = start;
                    for (String column : attributeOverrides.getColums()) {
                        if (attributeOverrides.setValue(value, column, data[i])) {
                            setted = true;
                        }
                        ++i;
                    }
                    if (setted) {
                        info.setValue(entity, value);
                    }
                    return Nsv.of(setted, i);
                }
            };
        } else if (info.hasJoinColumns()) {
            selectValue = new NativeSelectValue(){

                @Override
                public Nsv valueOf(Object[] data, Object entity, int start) throws Exception {
                    JoinColumns joinColumns = info.getJoinColumns();
                    Object value = joinColumns.createObject();
                    boolean setted = false;
                    int i = start;
                    for (String column : joinColumns.getColums()) {
                        if (joinColumns.setValue(value, column, data[i])) {
                            setted = true;
                        }
                        ++i;
                    }
                    if (setted) {
                        info.setValue(entity, value);
                    }
                    return Nsv.of(setted, i);
                }
            };
        } else if (Converter.isEntity(info.getConverter())) {
            selectValue = new NativeSelectValue(){

                @Override
                public Nsv valueOf(Object[] data, Object entity, int start) throws Exception {
                    boolean setted = false;
                    int i = start;
                    Object value = data[i];
                    if (value != null && info.getType().isAssignableFrom(value.getClass())) {
                        info.setValue(entity, value);
                        setted = true;
                    }
                    return Nsv.of(setted, ++i);
                }
            };
        } else {
            boolean isString = String.class.isAssignableFrom(info.getType());
            DatabaseType databaseType = info.getEntityInfo().getTrxManagerInfo().getIntegrator().getDatabaseType();
            selectValue = BasicDataType.isEqualJdbcType(info.getHibernateType(), BasicDataType.BINARY_TYPE) ? (DatabaseType.Oracle == databaseType ? NativeSelectValue.lobProxySelectValue(info, isString) : NativeSelectValue.binarySelectValue(info, isString)) : (BasicDataType.isEqualJdbcType(info.getHibernateType(), BasicDataType.BLOB_TYPE) || BasicDataType.isEqualJdbcType(info.getHibernateType(), BasicDataType.CLOB_TYPE) ? (DatabaseType.Oracle == databaseType ? NativeSelectValue.lobProxySelectValue(info, isString) : (DatabaseType.H2 == databaseType ? NativeSelectValue.lobProxySelectValue(info, isString) : (DatabaseType.HSQL == databaseType ? NativeSelectValue.lobProxySelectValue(info, isString) : (DatabaseType.Derby == databaseType ? NativeSelectValue.lobProxySelectValue(info, isString) : NativeSelectValue.defaultSelectValue(info))))) : NativeSelectValue.defaultSelectValue(info));
        }
        return selectValue;
    }

    public static NativeSelectValue defaultSelectValue(FieldInfo info) {
        if (Converter.isEnum(info.getConverter())) {
            return NativeSelectValue.enumSelectValue(info);
        }
        return NativeSelectValue.defaultSelectValue0(info);
    }

    public static NativeSelectValue defaultSelectValue0(final FieldInfo info) {
        return new NativeSelectValue(){

            @Override
            public Nsv valueOf(Object[] data, Object entity, int start) throws Exception {
                boolean setted = false;
                int i = start;
                Object value = data[i];
                if (value != null) {
                    Object fconv = info.convert(value);
                    info.setValue(entity, fconv);
                    setted = true;
                }
                return Nsv.of(setted, ++i);
            }
        };
    }

    public static NativeSelectValue enumSelectValue(final FieldInfo info) {
        if (EnumType.ORDINAL.equals((Object)info.getEnumType())) {
            return new NativeSelectValue(){

                @Override
                public Nsv valueOf(Object[] data, Object entity, int start) throws Exception {
                    boolean setted = false;
                    int i = start;
                    Object value = data[i];
                    if (value != null) {
                        Object fconv = info.convert(info.getNativeDefinition().getEnumDefinition().getOrdinalNameMap().get((Integer)value));
                        info.setValue(entity, fconv);
                        setted = true;
                    }
                    return Nsv.of(setted, ++i);
                }
            };
        }
        return NativeSelectValue.defaultSelectValue0(info);
    }

    public static NativeSelectValue binarySelectValue(final FieldInfo info, final boolean isString) {
        return new NativeSelectValue(){

            @Override
            public Nsv valueOf(Object[] data, Object entity, int start) throws Exception {
                boolean setted = false;
                int i = start;
                Object value = data[i];
                if (value != null) {
                    if (isString) {
                        value = new String((byte[])value);
                    }
                    Object fconv = info.convert(value);
                    info.setValue(entity, fconv);
                    setted = true;
                }
                return Nsv.of(setted, ++i);
            }
        };
    }

    public static NativeSelectValue lobProxySelectValue(final FieldInfo info, final boolean isString) {
        return new NativeSelectValue(){

            /*
             * Unable to fully structure code
             */
            @Override
            public Nsv valueOf(Object[] data, Object entity, int start) throws Exception {
                setted = false;
                i = start;
                value = data[i];
                if (value != null) {
                    if (Proxy.isProxyClass(value.getClass())) {
                        handler = Proxy.getInvocationHandler(value);
                        if (handler instanceof SerializableBlobProxy) {
                            try {
                                blob = ((SerializableBlobProxy)handler).getWrappedBlob();
                                value = blob.getBytes(1L, Integer.parseInt("" + blob.length()));
                                if (!isString) ** GOTO lbl26
                                value = new String((byte[])value);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        } else if (handler instanceof SerializableClobProxy) {
                            try {
                                clob = ((SerializableClobProxy)handler).getWrappedClob();
                                value = IOUtils.toString((Reader)clob.getCharacterStream());
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    } else if (value instanceof byte[] && isString) {
                        value = new String((byte[])value);
                    }
lbl26:
                    // 7 sources

                    fconv = info.convert(value);
                    info.setValue(entity, fconv);
                    setted = true;
                }
                return Nsv.of(setted, ++i);
            }
        };
    }

    public static class Nsv {
        private int last;
        private boolean setted;

        private Nsv() {
        }

        protected static Nsv of(boolean setted, int last) {
            Nsv nsv = new Nsv();
            nsv.setted = setted;
            nsv.last = last;
            return nsv;
        }

        public int getLast() {
            return this.last;
        }

        public boolean isSetted() {
            return this.setted;
        }
    }
}

