/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.entity;

import jakarta.persistence.OptimisticLockException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.entity.EntityAudit;
import net.ideahut.springboot.entity.EntityHelper;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityInfo0;
import net.ideahut.springboot.entity.EntityIntegrator;
import net.ideahut.springboot.entity.EntityPostListener;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.InternalHelper;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.StatelessSessionCallable;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionContract;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Table;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class TrxManagerInfo {
    private final String name;
    private final EntityTrxManager entityTrxManager;
    private final PlatformTransactionManager transactionManager;
    private final EntityIntegrator integrator;
    private final Map<Class<?>, EntityInfo> entityInfos;
    private final Map<String, EntityInfo> entityTables;

    protected static void onPreInsert(SessionFactory sessionFactory, Object entity) {
        InternalHelper.Stage.onPreInsert(sessionFactory, entity);
    }

    protected static void onPostInsert(Session session, Object entity) {
        PostListener.add((SharedSessionContract)session, 1, entity);
    }

    protected static void onPreUpdate(SessionFactory sessionFactory, Object entity) {
        InternalHelper.Stage.onPreUpdate(sessionFactory, entity);
    }

    protected static void onPostUpdate(Session session, Object entity) {
        PostListener.add((SharedSessionContract)session, 2, entity);
    }

    protected static void onPreDelete(SessionFactory sessionFactory, Object entity) {
        InternalHelper.Stage.onPreDelete(sessionFactory, entity);
    }

    protected static void onPostDelete(Session session, Object entity) {
        PostListener.add((SharedSessionContract)session, 3, entity);
    }

    public TrxManagerInfo(String name, EntityTrxManager entityTrxManager, PlatformTransactionManager transactionManager) throws Exception {
        this.name = name;
        this.entityTrxManager = entityTrxManager;
        this.transactionManager = transactionManager;
        this.integrator = EntityIntegrator.of(transactionManager);
        HashMap entityInfosTmi = new HashMap();
        HashMap<CallSite, EntityInfo> entityTablesTmi = new HashMap<CallSite, EntityInfo>();
        Collection<Class<?>> entityClasses = this.integrator.getAnnotatedClasses();
        for (Class<?> entityClass : entityClasses) {
            EntityInfo entityInfo = new EntityInfo(this, entityClass);
            entityInfosTmi.put(entityClass, entityInfo);
            Table table = entityInfo.getTable();
            if (table == null) continue;
            String schema = table.getSchema() != null ? table.getSchema() : "";
            entityTablesTmi.put((CallSite)((Object)(schema + "_" + table.getName())), entityInfo);
        }
        this.entityInfos = Collections.unmodifiableMap(entityInfosTmi);
        this.entityTables = Collections.unmodifiableMap(entityTablesTmi);
        for (EntityInfo entityInfo : this.entityInfos.values()) {
            EntityInfo0.prepareMapper(entityInfo);
            entityInfo.prepareConverters();
        }
        for (EntityInfo entityInfo : this.entityInfos.values()) {
            entityInfo.prepareAttributeOverrides();
        }
        for (EntityInfo entityInfo : this.entityInfos.values()) {
            entityInfo.prepareJoinColumns();
        }
        for (EntityInfo entityInfo : this.entityInfos.values()) {
            entityInfo.prepareDefinition();
        }
    }

    public String getName() {
        return this.name;
    }

    public EntityTrxManager getEntityTrxManager() {
        return this.entityTrxManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public EntityIntegrator getIntegrator() {
        return this.integrator;
    }

    public Set<Class<?>> getEntityClasses() {
        return this.entityInfos.keySet();
    }

    public EntityInfo getEntityInfo(Class<?> entityClass) {
        return this.entityInfos.get(entityClass);
    }

    public EntityInfo getEntityInfo(String tableSchema, String tableName) {
        tableSchema = tableSchema != null ? tableSchema : "";
        return this.entityTables.get(tableSchema + "_" + tableName);
    }

    public TrxManagerInfo loadLazy(Object object, Class<?> entityClass, Collection<String> fields) {
        EntityInfo entityInfo = this.getEntityInfo(entityClass);
        Assert.notNull((Object)entityInfo, (String)("Entity info is not found for class: " + entityClass));
        EntityHelper.loadLazy(object, entityInfo, fields);
        return this;
    }

    public TrxManagerInfo loadLazy(Object object, Collection<String> fields) {
        if (object != null) {
            this.loadLazy(object, object.getClass(), fields);
        }
        return this;
    }

    public TrxManagerInfo loadLazy(Object object, Class<?> entityClass) {
        return this.loadLazy(object, entityClass, null);
    }

    public TrxManagerInfo loadLazy(Object object) {
        if (object != null) {
            this.loadLazy(object, object.getClass(), null);
        }
        return this;
    }

    public TrxManagerInfo nullAudit(Object object) {
        if (object instanceof EntityAudit) {
            ((EntityAudit)object).setCreatedBy(null);
            ((EntityAudit)object).setCreatedOn(null);
            ((EntityAudit)object).setUpdatedBy(null);
            ((EntityAudit)object).setUpdatedOn(null);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T transaction(boolean autoCommit, SessionCallable<T> callable) {
        SessionFactoryImplementor factory = this.integrator.getSessionFactory();
        Transaction transaction = null;
        Session session = null;
        Exception exception = null;
        Object result = null;
        try {
            session = factory.openSession();
            transaction = session.beginTransaction();
            result = callable.call(session);
            if (autoCommit) {
                EntityHelper.commit(transaction);
            }
        }
        catch (Exception e) {
            String message;
            if (autoCommit && transaction != null) {
                EntityHelper.rollback(transaction);
            }
            exception = e;
            Throwable cause = e.getCause();
            if (cause instanceof OptimisticLockException && InternalHelper.Stage.isDelete((SharedSessionContract)session) && (message = cause.getMessage()) != null && message.indexOf("actual row count: 0; expected: 1") != -1) {
                result = null;
                exception = null;
            }
        }
        finally {
            EntityHelper.close(session);
        }
        if (exception != null) {
            throw FrameworkUtil.exception(exception);
        }
        PostListener.apply((SharedSessionContract)session, (SessionFactory)factory);
        return result;
    }

    public <T> T transaction(SessionCallable<T> callable) {
        return this.transaction(false, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T transaction(boolean autoCommit, StatelessSessionCallable<T> callable) {
        SessionFactoryImplementor factory = this.integrator.getSessionFactory();
        Transaction transaction = null;
        StatelessSession session = null;
        Exception exception = null;
        Object result = null;
        try {
            session = factory.openStatelessSession();
            transaction = session.beginTransaction();
            result = callable.call(session);
            if (autoCommit) {
                EntityHelper.commit(transaction);
            }
        }
        catch (Exception e) {
            String message;
            if (autoCommit && transaction != null) {
                EntityHelper.rollback(transaction);
            }
            exception = e;
            Throwable cause = e.getCause();
            if (cause instanceof OptimisticLockException && InternalHelper.Stage.isDelete((SharedSessionContract)session) && (message = cause.getMessage()) != null && message.indexOf("actual row count: 0; expected: 1") != -1) {
                result = null;
                exception = null;
            }
        }
        finally {
            EntityHelper.close(session);
        }
        if (exception != null) {
            throw FrameworkUtil.exception(exception);
        }
        PostListener.apply((SharedSessionContract)session, (SessionFactory)factory);
        return result;
    }

    public <T> T transaction(StatelessSessionCallable<T> callable) {
        return this.transaction(false, callable);
    }

    protected static final class Action {
        protected static final int INSERT = 1;
        protected static final int UPDATE = 2;
        protected static final int DELETE = 3;

        protected Action() {
        }
    }

    private static final class PostListener {
        private static final String ATTR_NAME = PostListener.class.getName();

        private PostListener() {
        }

        private static void add(SharedSessionContract session, int action, Object entity) {
            HashSet<PostObject> posts;
            RequestContext context = RequestContext.currentContext();
            HashMap<SharedSessionContract, HashSet<PostObject>> sessions = (HashMap<SharedSessionContract, HashSet<PostObject>>)context.getAttribute(ATTR_NAME);
            if (sessions == null) {
                sessions = new HashMap<SharedSessionContract, HashSet<PostObject>>();
                context.setAttribute(ATTR_NAME, sessions);
            }
            if ((posts = (HashSet<PostObject>)sessions.get(session)) == null) {
                posts = new HashSet<PostObject>();
                sessions.put(session, posts);
            }
            posts.add(new PostObject(action, entity));
        }

        private static void apply(SharedSessionContract session, SessionFactory factory) {
            Set posts;
            RequestContext context;
            Map sessions;
            if (session != null && factory != null && (sessions = (Map)(context = RequestContext.currentContext()).getAttribute(ATTR_NAME)) != null && (posts = (Set)sessions.remove(session)) != null && !posts.isEmpty()) {
                List<EntityPostListener> listeners = EntityIntegrator.getEntityPostListeners(factory);
                if (listeners != null) {
                    block5: for (PostObject post : posts) {
                        switch (post.action) {
                            case 1: {
                                for (EntityPostListener listener : listeners) {
                                    listener.onPostInsert(post.entity);
                                }
                                continue block5;
                            }
                            case 2: {
                                for (EntityPostListener listener : listeners) {
                                    listener.onPostUpdate(post.entity);
                                }
                                continue block5;
                            }
                            case 3: {
                                for (EntityPostListener listener : listeners) {
                                    listener.onPostDelete(post.entity);
                                }
                                break;
                            }
                        }
                    }
                }
                posts.clear();
                posts = null;
            }
        }
    }

    private static final class PostObject {
        private final int action;
        private final Object entity;

        private PostObject(int action, Object entity) {
            this.action = action;
            this.entity = entity;
        }
    }
}

