/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.init;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.object.Option;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.object.Result;

public interface InitMapper {
    public static void loadObject(ObjectMapper mapper, Object object) throws Exception {
        if (mapper != null && object != null) {
            String str = mapper.writeValueAsString(object);
            mapper.readValue(str, object.getClass());
            mapper.convertValue(object, JsonNode.class);
        }
    }

    public static void loadObject(DataMapper mapper, Object object) throws Exception {
        if (mapper != null && object != null) {
            InitMapper.loadObject((ObjectMapper)mapper.mapper(1), object);
            InitMapper.loadObject((ObjectMapper)mapper.mapper(2), object);
        }
    }

    public static void loadDefault(ObjectMapper mapper) throws Exception {
        if (mapper != null) {
            InitMapper.loadObject(mapper, (Object)Result.success());
            InitMapper.loadObject(mapper, (Object)new Message());
            InitMapper.loadObject(mapper, (Object)Page.empty());
            InitMapper.loadObject(mapper, (Object)new Option());
            InitMapper.loadObject(mapper, (Object)new MapStringObject());
        }
    }

    public static void loadDefault(DataMapper mapper) throws Exception {
        if (mapper != null) {
            InitMapper.loadDefault((ObjectMapper)mapper.mapper(1));
            InitMapper.loadDefault((ObjectMapper)mapper.mapper(2));
        }
    }

    public void onInitMapper() throws Exception;
}

