/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.job;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.job.JobGroupDto;
import net.ideahut.springboot.job.JobService;
import net.ideahut.springboot.job.JobTriggerDto;
import net.ideahut.springboot.job.SchedulerHandler;
import net.ideahut.springboot.job.SchedulerHelper;
import net.ideahut.springboot.util.FrameworkUtil;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.core.QuartzScheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class SchedulerHandlerImpl
implements SchedulerHandler,
InitializingBean {
    private SchedulerFactory schedulerFactory;
    private Scheduler scheduler;
    private String instanceId;
    private Set<String> jobPackages;
    private JobService jobService;
    private ApplicationContext applicationContext;

    public SchedulerHandlerImpl setSchedulerFactory(SchedulerFactory schedulerFactory) {
        this.schedulerFactory = schedulerFactory;
        return this;
    }

    public SchedulerHandlerImpl setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public SchedulerHandlerImpl setJobPackages(Set<String> jobPackages) {
        this.jobPackages = jobPackages;
        return this;
    }

    public SchedulerHandlerImpl setJobPackages(String ... jobPackages) {
        if (jobPackages != null) {
            this.jobPackages = new LinkedHashSet<String>();
            for (String jobPackage : jobPackages) {
                this.jobPackages.add(jobPackage);
            }
        }
        return this;
    }

    public SchedulerHandlerImpl setJobService(JobService jobService) {
        this.jobService = jobService;
        return this;
    }

    public SchedulerHandlerImpl setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.applicationContext, (String)"applicationContext is required");
        Assert.notNull((Object)this.jobService, (String)"jobService is required");
        Assert.hasLength((String)this.instanceId, (String)"instanceId is required");
        if (this.jobPackages == null) {
            this.jobPackages = new LinkedHashSet<String>();
        }
        if (this.schedulerFactory == null) {
            this.schedulerFactory = new StdSchedulerFactory();
        }
    }

    @Override
    public Set<String> packages() {
        return this.jobPackages;
    }

    @Override
    public List<JobGroupDto> groups(Boolean isActive) throws SchedulerException {
        return this.jobService.getGroups(this.instanceId, isActive);
    }

    @Override
    public List<JobGroupDto> triggers(Boolean isActive, Collection<String> groupIds) throws SchedulerException {
        List groups = this.jobService.getGroupsAndTriggers(this.instanceId, isActive, groupIds, Boolean.valueOf(false));
        if (this.scheduler != null) {
            for (JobGroupDto group : groups) {
                for (JobTriggerDto trigger : group.getTriggers()) {
                    TriggerKey key = new TriggerKey(trigger.getTriggerId(), trigger.getGroup().getGroupId());
                    JobTriggerDto.Status status = new JobTriggerDto.Status();
                    status.setScheduled(Boolean.valueOf(false));
                    SchedulerHelper.updateStatus(status, this.scheduler, key);
                    trigger.setStatus(status);
                    trigger.setLastRunData(null);
                    trigger.setLastRunTime(null);
                    trigger.setInstance(null);
                    trigger.setConfigurations(null);
                }
            }
        }
        return groups;
    }

    @Override
    public synchronized boolean start() throws SchedulerException {
        if (this.scheduler != null) {
            return true;
        }
        this.scheduler = this.schedulerFactory.getScheduler();
        SchedulerHelper.start(this.scheduler, this.jobService, this.jobPackages, this.instanceId, this.applicationContext);
        return true;
    }

    @Override
    public synchronized boolean stop(boolean waitForJobsToComplete) throws SchedulerException {
        if (this.scheduler == null) {
            return true;
        }
        this.scheduler.shutdown(waitForJobsToComplete);
        this.scheduler = null;
        return true;
    }

    @Override
    public boolean running() throws SchedulerException {
        return this.scheduler != null && this.scheduler.isStarted();
    }

    @Override
    public SchedulerMetaData metadata() throws SchedulerException {
        if (this.scheduler != null) {
            return this.scheduler.getMetaData();
        }
        String version = QuartzScheduler.getVersionMajor() + "." + QuartzScheduler.getVersionMinor() + "." + QuartzScheduler.getVersionIteration();
        return new SchedulerMetaData(null, null, Void.class, false, false, false, true, null, 0, Void.class, false, false, Void.class, 0, version);
    }

    @Override
    public synchronized JobTriggerDto pause(String triggerId) throws SchedulerException {
        JobTriggerDto triggerDto = SchedulerHelper.getTriggerDto(this.scheduler, this.jobService, triggerId);
        TriggerKey triggerKey = SchedulerHelper.getTriggerKey(this.scheduler, triggerDto);
        Trigger.TriggerState triggerState = this.scheduler.getTriggerState(triggerKey);
        if (Trigger.TriggerState.PAUSED != triggerState) {
            this.scheduler.pauseTrigger(triggerKey);
        }
        SchedulerHelper.updateStatus(triggerDto.getStatus(), this.scheduler, triggerKey);
        return triggerDto;
    }

    @Override
    public synchronized JobTriggerDto resume(String triggerId) throws SchedulerException {
        JobTriggerDto triggerDto = SchedulerHelper.getTriggerDto(this.scheduler, this.jobService, triggerId);
        TriggerKey triggerKey = SchedulerHelper.getTriggerKey(this.scheduler, triggerDto);
        Trigger.TriggerState triggerState = this.scheduler.getTriggerState(triggerKey);
        if (Trigger.TriggerState.PAUSED == triggerState) {
            this.scheduler.resumeTrigger(triggerKey);
        }
        SchedulerHelper.updateStatus(triggerDto.getStatus(), this.scheduler, triggerKey);
        return triggerDto;
    }

    @Override
    public synchronized JobTriggerDto trigger(String triggerId) throws SchedulerException {
        JobTriggerDto triggerDto = SchedulerHelper.getTriggerDto(this.scheduler, this.jobService, triggerId);
        JobKey jobKey = new JobKey(triggerDto.getTriggerId(), triggerDto.getGroup().getGroupId());
        Assert.isTrue((boolean)this.scheduler.checkExists(jobKey), (String)"JobKey is not available");
        this.scheduler.triggerJob(jobKey);
        TriggerKey triggerKey = new TriggerKey(triggerDto.getTriggerId(), triggerDto.getGroup().getGroupId());
        SchedulerHelper.updateStatus(triggerDto.getStatus(), this.scheduler, triggerKey);
        return triggerDto;
    }

    @Override
    public JobTriggerDto delete(String triggerId) throws SchedulerException {
        JobTriggerDto triggerDto = SchedulerHelper.getTriggerDto(this.scheduler, this.jobService, triggerId);
        JobKey jobKey = new JobKey(triggerDto.getTriggerId(), triggerDto.getGroup().getGroupId());
        Assert.isTrue((boolean)this.scheduler.checkExists(jobKey), (String)"JobKey is not available");
        this.scheduler.deleteJob(jobKey);
        TriggerKey triggerKey = new TriggerKey(triggerDto.getTriggerId(), triggerDto.getGroup().getGroupId());
        SchedulerHelper.updateStatus(triggerDto.getStatus(), this.scheduler, triggerKey);
        return triggerDto;
    }

    @Override
    public JobTriggerDto add(String triggerId) throws SchedulerException {
        JobTriggerDto triggerDto = SchedulerHelper.getTriggerDto(this.scheduler, this.jobService, triggerId);
        SchedulerHelper.SchedulerJob schedulerJob = SchedulerHelper.createSchedulerJob(triggerDto.getGroup(), triggerDto, this.jobPackages, this.applicationContext, this.jobService);
        this.scheduler.deleteJob(schedulerJob.getJobDetail().getKey());
        this.scheduler.scheduleJob(schedulerJob.getJobDetail(), schedulerJob.getJobTrigger());
        if (FrameworkUtil.isTrue(triggerDto.getIsRunOnStartup())) {
            this.scheduler.triggerJob(schedulerJob.getJobDetail().getKey(), schedulerJob.getJobDetail().getJobDataMap());
        }
        TriggerKey triggerKey = new TriggerKey(triggerDto.getTriggerId(), triggerDto.getGroup().getGroupId());
        SchedulerHelper.updateStatus(triggerDto.getStatus(), this.scheduler, triggerKey);
        return triggerDto;
    }

    @Override
    public Map<String, JobTriggerDto.Status> status(Collection<String> triggerIds) throws SchedulerException {
        HashMap<String, JobTriggerDto.Status> statuses = new HashMap<String, JobTriggerDto.Status>();
        if (triggerIds != null && !triggerIds.isEmpty()) {
            LinkedHashSet<String> ids = new LinkedHashSet<String>(triggerIds);
            Map map = this.jobService.getTriggerMap(triggerIds);
            for (String id : ids) {
                JobTriggerDto.Status status = new JobTriggerDto.Status();
                status.setScheduled(Boolean.valueOf(false));
                JobTriggerDto dto = (JobTriggerDto)map.get(id);
                if (dto != null) {
                    TriggerKey key = new TriggerKey(dto.getTriggerId(), dto.getGroup().getGroupId());
                    SchedulerHelper.updateStatus(status, this.scheduler, key);
                }
                statuses.put(id, status);
            }
        }
        return statuses;
    }
}

