/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.mail;

import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.Properties;
import net.ideahut.springboot.mail.MailHandler;
import net.ideahut.springboot.mail.MailObject;
import net.ideahut.springboot.mail.MailProperties;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.Assert;

public class MailHandlerImpl
implements MailHandler,
InitializingBean {
    private String username;
    private String password;
    private InternetAddress defaultFrom;
    private Properties properties;
    private TaskHandler taskHandler;
    private MailProperties mailProperties;

    public MailHandlerImpl setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public MailHandlerImpl setMailProperties(MailProperties mailProperties) {
        this.mailProperties = mailProperties;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.mailProperties, (String)"mailProperties is required");
        Assert.notNull((Object)this.taskHandler, (String)"taskHandler is required");
        this.username = this.mailProperties.getUsername();
        this.username = this.username != null ? this.username : "";
        this.password = this.mailProperties.getPassword();
        this.password = this.password != null ? this.password : "";
        this.properties = this.mailProperties.getProperties();
        this.properties = this.properties != null ? this.properties : new Properties();
        String from = this.mailProperties.getFrom();
        from = from != null ? from : "";
        this.defaultFrom = !from.isEmpty() ? new InternetAddress(from, from) : new InternetAddress(this.username, this.username);
    }

    @Override
    public void send(MailObject mailObject, boolean asynchronous) throws Exception {
        if (asynchronous) {
            this.taskHandler.execute(() -> {
                try {
                    this.send(mailObject);
                }
                catch (Exception e) {
                    throw FrameworkUtil.exception(e);
                }
            });
        } else {
            this.send(mailObject);
        }
    }

    @Override
    public void send(MailObject mailObject) throws Exception {
        MailObject.Attachment[] attachments;
        InternetAddress[] bcc;
        MimeMessage mimeMessage = new MimeMessage(this.session());
        String encoding = mailObject.getEncoding();
        encoding = encoding != null ? encoding : "UTF-8";
        MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, mailObject.isMultipart(), encoding);
        InternetAddress from = mailObject.getFrom();
        if (from == null) {
            from = this.defaultFrom;
        }
        mimeMessageHelper.setFrom(from);
        mimeMessageHelper.setTo(mailObject.getTo());
        InternetAddress[] cc = mailObject.getCc();
        if (cc != null && cc.length != 0) {
            mimeMessageHelper.setCc(cc);
        }
        if ((bcc = mailObject.getBcc()) != null && bcc.length != 0) {
            mimeMessageHelper.setBcc(bcc);
        }
        mimeMessageHelper.setSubject(mailObject.getSubject());
        String plainText = mailObject.getPlainText();
        String htmlText = mailObject.getHtmlText();
        if (plainText != null && htmlText != null) {
            mimeMessageHelper.setText(plainText, htmlText);
        } else if (htmlText != null) {
            mimeMessageHelper.setText(htmlText, true);
        } else {
            mimeMessageHelper.setText(plainText != null ? plainText : "");
        }
        MailObject.Inline[] inlines = mailObject.getInline();
        if (inlines != null) {
            for (MailObject.Inline inline : inlines) {
                mimeMessageHelper.addInline(inline.getContentId(), (InputStreamSource)new ByteArrayResource(inline.getContentData()), inline.getContentType());
            }
        }
        if ((attachments = mailObject.getAttachment()) != null) {
            for (MailObject.Attachment attachment : attachments) {
                mimeMessageHelper.addAttachment(attachment.getName(), (InputStreamSource)new ByteArrayResource(attachment.getData()), attachment.getContentType());
            }
        }
        Transport.send((Message)mimeMessage);
    }

    private Session session() {
        if (this.username != null && !this.username.isEmpty()) {
            return Session.getInstance((Properties)this.properties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(MailHandlerImpl.this.username, MailHandlerImpl.this.password);
                }
            });
        }
        return Session.getInstance((Properties)this.properties);
    }
}

