/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.rest;

import net.ideahut.springboot.rest.RestResponse;
import net.ideahut.springboot.util.FrameworkUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class RestClient
extends HttpClient {
    private static final ProtocolSocketFactory defaultSSLProtocolSocketFactory;

    protected static ProtocolSocketFactory getDefaultSSLProtocolSocketFactory() {
        return defaultSSLProtocolSocketFactory;
    }

    public RestClient() {
    }

    public RestClient(HttpClientParams params, HttpConnectionManager httpConnectionManager) {
        super(params, httpConnectionManager);
    }

    public RestClient(HttpClientParams params) {
        super(params);
    }

    public RestClient(HttpConnectionManager httpConnectionManager) {
        super(httpConnectionManager);
    }

    public RestResponse execute(HttpMethod method) throws Exception {
        return RestResponse.of(this, method);
    }

    public void close() {
        HttpConnectionManager connectionManager = super.getHttpConnectionManager();
        if (connectionManager instanceof SimpleHttpConnectionManager) {
            ((SimpleHttpConnectionManager)connectionManager).shutdown();
        } else if (connectionManager instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)connectionManager).shutdown();
        }
    }

    public static RestClient of(HttpConnectionManager connectionManager, int connectTimeoutMillis, int readTimeoutMillis) {
        RestClient client = new RestClient(connectionManager);
        client.getParams().setCookiePolicy("compatibility");
        if (connectTimeoutMillis > 0) {
            client.getHttpConnectionManager().getParams().setConnectionTimeout(connectTimeoutMillis);
        }
        if (readTimeoutMillis > 0) {
            client.getHttpConnectionManager().getParams().setSoTimeout(readTimeoutMillis);
        }
        client.setState(new HttpState());
        return client;
    }

    public static RestClient of(int connectTimeoutMillis, int readTimeoutMillis) {
        return RestClient.of((HttpConnectionManager)new MultiThreadedHttpConnectionManager(), connectTimeoutMillis, readTimeoutMillis);
    }

    public static RestClient of() {
        return RestClient.of(0, 0);
    }

    static {
        ProtocolSocketFactory defaultSSLProtocolSocketFactory0 = null;
        try {
            defaultSSLProtocolSocketFactory0 = (ProtocolSocketFactory)FrameworkUtil.instanceOf("org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultSSLProtocolSocketFactory = defaultSSLProtocolSocketFactory0;
    }
}

