/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.security.RedisMemoryCredentialHelper;
import net.ideahut.springboot.security.SecurityCredential;
import net.ideahut.springboot.security.SecurityUser;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.RequestUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

public class RedisMemoryCredential
implements SecurityCredential,
InitializingBean,
BeanReload,
BeanConfigure<RedisMemoryCredential> {
    private final RedisMemoryCredentialHelper.Configuration configuration = new RedisMemoryCredentialHelper.Configuration();
    private boolean reconfigured = false;
    private DataMapper dataMapper;
    private RedisTemplate<String, byte[]> redisTemplate;
    private String configFile;
    private Collection<SecurityUser> users;
    private String passwordType;
    private String redisPrefix;
    private Integer redisExpiry;

    public RedisMemoryCredential setConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public RedisMemoryCredential setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public RedisMemoryCredential setUsers(Collection<SecurityUser> users) {
        this.users = users;
        return this;
    }

    public RedisMemoryCredential setPasswordType(String passwordType) {
        this.passwordType = passwordType;
        return this;
    }

    public RedisMemoryCredential setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public RedisMemoryCredential setRedisPrefix(String redisPrefix) {
        this.redisPrefix = redisPrefix;
        return this;
    }

    public RedisMemoryCredential setRedisExpiry(Integer redisExpiry) {
        this.redisExpiry = redisExpiry;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.redisTemplate, (String)"redisTemplate is required");
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        this.configFile = this.configFile != null ? this.configFile.trim() : "";
        String string = this.redisPrefix = this.redisPrefix != null ? this.redisPrefix.trim() : "";
        if (this.redisPrefix.isEmpty()) {
            this.redisPrefix = RedisMemoryCredential.class.getSimpleName();
        }
        if (this.redisExpiry == null || this.redisExpiry <= 0) {
            this.redisExpiry = 30;
        }
        this.configuration.dataMapper = this.dataMapper;
        this.configuration.redisTemplate = this.redisTemplate;
        this.configuration.redisPrefix = this.redisPrefix;
    }

    @Override
    public Callable<RedisMemoryCredential> configureBean(ApplicationContext applicationContext) {
        final RedisMemoryCredential self = this;
        return new Callable<RedisMemoryCredential>(){

            @Override
            public RedisMemoryCredential call() throws Exception {
                RedisMemoryCredential.this.reloadBean();
                RedisMemoryCredential.this.reconfigured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.reconfigured;
    }

    public boolean reloadBean() throws Exception {
        if (!RedisMemoryCredentialHelper.lock(this.redisTemplate, this.redisPrefix, true)) {
            return false;
        }
        try {
            Set<SecurityUser> usersEi = null;
            if (!this.configFile.isEmpty()) {
                this.configFile = FrameworkUtil.replacePath(this.configFile);
                byte[] bytes = FrameworkUtil.resourceBytes(this.configFile);
                JsonNode node = this.dataMapper.read(bytes, JsonNode.class);
                if (node.has("users")) {
                    usersEi = this.dataMapper.convert((Object)node.get("users"), RedisMemoryCredentialHelper.TypeRef.USER_SET);
                }
                this.configuration.redisExpiry = node.has("redisExpiry") ? node.get("redisExpiry").asInt() : this.redisExpiry.intValue();
                this.configuration.passwordType = node.has("passwordType") ? node.get("passwordType").asText() : this.passwordType;
            } else {
                usersEi = this.users != null ? new HashSet<SecurityUser>(this.users) : null;
                this.configuration.redisExpiry = this.redisExpiry;
                this.configuration.passwordType = this.passwordType;
            }
            Assert.notEmpty(usersEi, (String)"users are required");
            String string = this.configuration.passwordType = this.configuration.passwordType != null ? this.configuration.passwordType.trim().toLowerCase() : "";
            if (this.configuration.redisExpiry == null || this.configuration.redisExpiry <= 0) {
                this.configuration.redisExpiry = 30;
            }
            RedisMemoryCredentialHelper.setUsers(this.configuration, usersEi);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            RedisMemoryCredentialHelper.lock(this.redisTemplate, this.redisPrefix, false);
        }
        return true;
    }

    public boolean isValidCredential(MapStringObject parameter) {
        BeanConfigure.checkBeanConfigure(this);
        boolean valid = true;
        String authorization = (String)parameter.getValue("authorization", (Object)"");
        ValueOperations operations = this.redisTemplate.opsForValue();
        byte[] bytes = (byte[])operations.get((Object)(RedisMemoryCredentialHelper.Key.auth(this.redisPrefix) + authorization));
        if (bytes != null) {
            String host;
            SecurityUser user = this.dataMapper.read(bytes, SecurityUser.class);
            Set hosts = user.getHosts();
            if (hosts != null && !hosts.isEmpty() && !hosts.contains(host = RequestUtil.getRemoteHost())) {
                valid = false;
            }
            if (valid) {
                RequestContext.currentContext().setAttribute(SecurityUser.Attribute.CONTEXT, (Object)user);
            }
        } else {
            String username = (String)parameter.getValue("username", (Object)"");
            String password = (String)parameter.getValue("password", (Object)"");
            valid = !username.isEmpty() && !password.isEmpty() ? RedisMemoryCredentialHelper.registerUser(this.configuration, parameter) : false;
        }
        return valid;
    }

    public boolean registerUser(MapStringObject parameter) {
        BeanConfigure.checkBeanConfigure(this);
        return RedisMemoryCredentialHelper.registerUser(this.configuration, parameter);
    }

    public void invalidate(MapStringObject parameter) {
        BeanConfigure.checkBeanConfigure(this);
        RedisMemoryCredentialHelper.invalidate(this.configuration, parameter);
    }
}

