/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.security;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.context.RequestContext;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.security.SecurityUser;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.RequestUtil;
import org.mindrot.jbcrypt.BCrypt;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

final class RedisMemoryCredentialHelper {
    private RedisMemoryCredentialHelper() {
    }

    protected static synchronized boolean lock(RedisTemplate<String, byte[]> redisTemplate, String redisPrefix, boolean yes) {
        String lockKey = Key.lock(redisPrefix);
        if (yes) {
            ValueOperations lockOps = redisTemplate.opsForValue();
            byte[] lockBytes = (byte[])lockOps.get((Object)lockKey);
            if (lockBytes != null) {
                return false;
            }
            lockOps.set((Object)lockKey, (Object)"1".getBytes());
        } else {
            redisTemplate.delete((Object)lockKey);
        }
        return true;
    }

    protected static void clear(Configuration configuration) {
        ValueOperations operations = configuration.redisTemplate.opsForValue();
        HashSet<Object> keys = new HashSet<Object>();
        String lkey = Key.userkeys(configuration.redisPrefix);
        keys.add(lkey);
        byte[] bytes = (byte[])operations.get((Object)lkey);
        if (bytes != null) {
            Set<String> users = configuration.dataMapper.read(bytes, TypeRef.STRING_SET);
            String upre = Key.user(configuration.redisPrefix);
            for (String user : users) {
                keys.add(upre + user);
            }
        }
        configuration.redisTemplate.delete(keys);
    }

    protected static void setUsers(Configuration configuration, Collection<SecurityUser> users) {
        HashSet<String> userKeys = new HashSet<String>();
        HashMap<Object, byte[]> redisValues = new HashMap<Object, byte[]>();
        String preuser = Key.user(configuration.redisPrefix);
        for (SecurityUser user : users) {
            Assert.hasLength((String)user.getUsername(), (String)"username is required");
            Assert.hasLength((String)user.getPassword(), (String)"password is required");
            HashSet hosts = user.getHosts();
            if (hosts == null) {
                hosts = new HashSet();
            }
            if (hosts.contains("*")) {
                hosts.clear();
            }
            user.setHosts(hosts);
            String ckey = preuser + user.getUsername();
            byte[] cval = configuration.dataMapper.writeAsBytes(user, 1);
            redisValues.put(ckey, cval);
            userKeys.add(user.getUsername());
        }
        byte[] userValues = configuration.dataMapper.writeAsBytes(userKeys, 1);
        redisValues.put(Key.userkeys(configuration.redisPrefix), userValues);
        RedisMemoryCredentialHelper.clear(configuration);
        configuration.redisTemplate.opsForValue().multiSet(redisValues);
    }

    protected static SecurityUser getUser(Configuration configuration, String username) {
        ValueOperations operations = configuration.redisTemplate.opsForValue();
        byte[] bytes = (byte[])operations.get((Object)(Key.user(configuration.redisPrefix) + username));
        if (bytes == null) {
            return null;
        }
        return configuration.dataMapper.read(bytes, SecurityUser.class);
    }

    protected static boolean registerUser(Configuration configuration, MapStringObject parameter) {
        String host;
        String authorization = (String)parameter.getValue("authorization", (Object)"");
        Assert.hasLength((String)authorization, (String)"authorization is required");
        String username = (String)parameter.getValue("username", (Object)"");
        Assert.hasLength((String)username, (String)"username is required");
        String password = (String)parameter.getValue("password", (Object)"");
        Assert.hasLength((String)password, (String)"password is required");
        SecurityUser user = RedisMemoryCredentialHelper.getUser(configuration, username);
        if (user == null) {
            return false;
        }
        Set hosts = user.getHosts();
        if (hosts != null && !hosts.isEmpty() && !hosts.contains(host = RequestUtil.getRemoteHost())) {
            return false;
        }
        boolean valid = false;
        if ("bcrypt".equals(configuration.passwordType)) {
            valid = BCrypt.checkpw((String)password, (String)user.getPassword());
        } else if (configuration.passwordType.startsWith("sha") || configuration.passwordType.startsWith("md")) {
            String hash = FrameworkUtil.digest(configuration.passwordType, password);
            valid = password.equals(hash);
        } else {
            valid = password.equals(user.getPassword());
        }
        if (valid) {
            user.setAttribute(SecurityUser.Attribute.HOST, RequestUtil.getRemoteHost());
            user.setAttribute(SecurityUser.Attribute.AGENT, RequestUtil.getUserAgent());
            byte[] bytes = configuration.dataMapper.writeAsBytes(user, 1);
            configuration.redisTemplate.opsForValue().set((Object)(Key.auth(configuration.redisPrefix) + authorization), (Object)bytes, (long)configuration.redisExpiry.intValue(), TimeUnit.MINUTES);
            RequestContext.currentContext().setAttribute(SecurityUser.Attribute.CONTEXT, (Object)user);
        }
        return valid;
    }

    protected static void invalidate(Configuration configuration, MapStringObject parameter) {
        String authorization = (String)parameter.getValue("authorization", (Object)"");
        Assert.hasLength((String)authorization, (String)"authorization is required");
        configuration.redisTemplate.delete((Object)(Key.auth(configuration.redisPrefix) + authorization));
    }

    protected static final class Key {
        private Key() {
        }

        protected static String lock(String prefix) {
            return prefix + "--LOCK--";
        }

        protected static String userkeys(String prefix) {
            return prefix + "--USERS--";
        }

        protected static String user(String prefix) {
            return prefix + "::USER::";
        }

        protected static String auth(String prefix) {
            return prefix + "::AUTH::";
        }
    }

    protected static final class Configuration {
        protected DataMapper dataMapper;
        protected RedisTemplate<String, byte[]> redisTemplate;
        protected String passwordType;
        protected String redisPrefix;
        protected Integer redisExpiry;

        protected Configuration() {
        }
    }

    protected static final class TypeRef {
        protected static final TypeReference<Set<String>> STRING_SET = new TypeReference<Set<String>>(){};
        protected static final TypeReference<Set<SecurityUser>> USER_SET = new TypeReference<Set<SecurityUser>>(){};

        protected TypeRef() {
        }
    }
}

