/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.MessageDigest;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.ideahut.springboot.annotation.Login;
import net.ideahut.springboot.annotation.Public;
import net.ideahut.springboot.entity.EntitySoftDelete;
import net.ideahut.springboot.util.FrameworkUtil0;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.filter.GenericFilterBean;

public final class FrameworkUtil {
    public static final String PACKAGE = "net.ideahut.springboot";
    private static final Set<String> hibernateKeys = FrameworkUtil0.hibernateKeys;

    private FrameworkUtil() {
    }

    public static Map<String, Object> getHibernateSettings(Environment environment, String prefix) {
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        for (String key : hibernateKeys) {
            String value = environment.getProperty(prefix + "." + key);
            if (value == null) continue;
            settings.put(key, value);
        }
        return settings;
    }

    public static Map<String, Object> getHibernateSettings(Map<String, ?> map) {
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (!hibernateKeys.contains(entry.getKey())) continue;
            settings.put(entry.getKey(), entry.getValue());
        }
        return settings;
    }

    public static Properties getHibernateProperties(Environment environment, String prefix) {
        Properties properties = new Properties();
        for (String key : hibernateKeys) {
            String value = environment.getProperty(prefix + "." + key);
            if (value == null) continue;
            properties.setProperty(key, value);
        }
        return properties;
    }

    public static Properties getHibernateProperties(Map<String, ?> map) {
        Properties properties = new Properties();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            if (!hibernateKeys.contains(entry.getKey())) continue;
            properties.setProperty(entry.getKey(), entry.getValue() != null ? "" + entry.getValue() : null);
        }
        return properties;
    }

    public static <T extends GenericFilterBean> FilterRegistrationBean<T> createFilterBean(Environment environment, T filter, int order, String ... urlPatterns) {
        filter.setEnvironment(environment);
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter(filter);
        bean.addUrlPatterns(urlPatterns);
        bean.setOrder(order);
        return bean;
    }

    public static <T> Class<T> classOf(String name, boolean initialize, ClassLoader loader) {
        try {
            return Class.forName(name, initialize, loader);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public static <T> Class<T> classOf(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    public static RuntimeException exception(Throwable e) {
        throw new RuntimeException(e);
    }

    public static RuntimeException exception(String text) {
        throw new RuntimeException(text);
    }

    public static <T> T instanceOf(Class<?> type, Class<?> ... constructorTypes) throws Exception {
        return (T)type.getConstructor(constructorTypes).newInstance(new Object[0]);
    }

    public static <T> T instanceOf(String classname, Class<?> ... constructorTypes) throws Exception {
        Class<T> type = FrameworkUtil.classOf(classname);
        return FrameworkUtil.instanceOf(type, constructorTypes);
    }

    public static byte[] resourceBytes(String target) throws Exception {
        byte[] bytes;
        String source;
        String string = source = target != null ? target.trim() : "";
        if (source.isEmpty()) {
            return new byte[0];
        }
        if (source.startsWith("https://") || source.startsWith("http://")) {
            URL url = new URL(source);
            bytes = IOUtils.toByteArray((InputStream)url.openStream());
        } else if (source.startsWith("file:")) {
            String path = source.substring(5);
            bytes = FileUtils.readFileToByteArray((File)new File(path));
        } else {
            bytes = IOUtils.toByteArray((InputStream)new ClassPathResource(source).getInputStream());
        }
        return bytes;
    }

    public static boolean isDeleted(Object entity) {
        if (entity instanceof EntitySoftDelete) {
            return ((EntitySoftDelete)entity).getDeletedOn() != null;
        }
        return true;
    }

    public static boolean isTrue(Character character) {
        if (character == null) {
            return false;
        }
        if ('Y' == character.charValue()) {
            return true;
        }
        if ('N' == character.charValue()) {
            return false;
        }
        throw new RuntimeException("Undefined boolean character: " + character);
    }

    public static boolean isPublic(Method method) {
        Public annotation = method.getAnnotation(Public.class);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(Public.class);
        }
        return annotation != null && annotation.value();
    }

    public static boolean isLogin(Method method) {
        Login annotation = method.getAnnotation(Login.class);
        if (annotation == null) {
            annotation = method.getDeclaringClass().getAnnotation(Login.class);
        }
        return annotation != null && annotation.value();
    }

    public static String replacePath(String text) {
        return FrameworkUtil.replacePath(text, true);
    }

    public static String replacePath(String text, boolean normalized) {
        if (text != null) {
            String str = new String(text);
            str = str.replace("{user.home}", System.getProperty("user.home")).replace("{java.home}", System.getProperty("java.home")).replace("{java.io.tmpdir}", System.getProperty("java.io.tmpdir")).replace("{user.dir}", System.getProperty("user.dir"));
            if (normalized) {
                str = str.replace("\\", "/").replace("/", File.separator);
            }
            return str;
        }
        return text;
    }

    public static String digest(String algorithm, String text) {
        if (text == null) {
            return "";
        }
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] b = md.digest(text.getBytes("UTF-8"));
            Object result = "";
            for (int i = 0; i < b.length; ++i) {
                result = (String)result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }
        catch (Exception e) {
            return "";
        }
    }
}

