/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

final class FrameworkUtil0 {
    private static final String[] hibernateClasses = new String[]{"org.hibernate.cfg.AvailableSettings", "org.hibernate.cfg.BatchSettings", "org.hibernate.cfg.BytecodeSettings", "org.hibernate.cfg.CacheSettings", "org.hibernate.cfg.EnvironmentSettings", "org.hibernate.cfg.FetchSettings", "org.hibernate.cfg.JdbcSettings", "org.hibernate.cfg.JpaComplianceSettings", "org.hibernate.cfg.ManagedBeanSettings", "org.hibernate.cfg.MappingSettings", "org.hibernate.cfg.MultiTenancySettings", "org.hibernate.cfg.PersistenceSettings", "org.hibernate.cfg.QuerySettings", "org.hibernate.cfg.SchemaToolingSettings", "org.hibernate.cfg.SessionEventSettings", "org.hibernate.cfg.StatisticsSettings", "org.hibernate.cfg.TransactionSettings", "org.hibernate.cfg.ValidationSettings", "net.ideahut.springboot.entity.EntityIntegrator"};
    protected static final Set<String> hibernateKeys;

    FrameworkUtil0() {
    }

    private static Set<String> getHibernateKeys(String classname) {
        HashSet<String> keys = new HashSet<String>();
        try {
            Class<?> clazz = Class.forName(classname);
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                String key = String.valueOf(field.get(null));
                if (!key.startsWith("hibernate.")) continue;
                keys.add(key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return keys;
    }

    static {
        LinkedHashSet<String> _hibernateKeys = new LinkedHashSet<String>();
        for (String classname : hibernateClasses) {
            Set<String> keys = FrameworkUtil0.getHibernateKeys(classname);
            _hibernateKeys.addAll(keys);
        }
        hibernateKeys = _hibernateKeys;
    }
}

