/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import net.ideahut.springboot.admin.AdminHandler;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.AdminTrxManagerInfo;
import net.ideahut.springboot.admin.HelperAdmin;
import net.ideahut.springboot.admin.HelperAudit;
import net.ideahut.springboot.admin.HelperCache;
import net.ideahut.springboot.admin.HelperCrud;
import net.ideahut.springboot.admin.HelperEntity;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.admin.HelperObject;
import net.ideahut.springboot.admin.HelperRedis;
import net.ideahut.springboot.admin.HelperReload;
import net.ideahut.springboot.admin.HelperRequest;
import net.ideahut.springboot.admin.HelperScheduler;
import net.ideahut.springboot.audit.AuditAccessible;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.cache.CacheInfo;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudRequest;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.grid.GridAdditional;
import net.ideahut.springboot.grid.GridHandler;
import net.ideahut.springboot.grid.GridOption;
import net.ideahut.springboot.job.SchedulerHandler;
import net.ideahut.springboot.job.dto.JobGroupDto;
import net.ideahut.springboot.job.dto.JobTriggerDto;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.object.ApplicationInfo;
import net.ideahut.springboot.object.BeanInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.object.RequestInfo;
import net.ideahut.springboot.object.VersionInfo;
import net.ideahut.springboot.redis.RedisInfo;
import net.ideahut.springboot.security.SecurityCredential;
import net.ideahut.springboot.security.SecurityUser;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class AdminHandlerImpl
implements AdminHandler,
InitializingBean,
BeanReload,
BeanConfigure<AdminHandler> {
    private boolean configured = false;
    protected DataMapper dataMapper;
    private RedisTemplate<String, byte[]> redisTemplate;
    private String configFile;
    private SyncToCentral syncToCentral;
    private CheckTokenCentral checkTokenCentral;
    private AfterReload afterReload;
    private AdminProperties inProperties;
    private Map<String, GridOption> gridOptions;
    private Map<String, GridAdditional> gridAdditionals;
    private MapStringObject info;
    private List<AdminMenu> menus;
    private CrudHandler crudHandler;
    protected GridHandler gridHandler;
    protected AdminProperties properties;
    protected Map<String, BeanReload> reloads;
    protected Map<String, HelperObject.AdminCacheInfo> cacheGroupInfos;
    protected Map<String, HelperObject.AdminCacheInfo> cacheSingleInfos;
    protected Map<String, HelperObject.AdminRedisInfo> redisInfos;
    protected Map<String, HelperObject.AdminAuditInfo> auditInfos;
    protected Map<String, AdminTrxManagerInfo> trxManagerInfos;
    protected Map<String, SchedulerHandler> schedulers;
    protected List<RequestInfo> requestInfos;
    protected List<BeanInfo> beanInfos;
    private ApplicationContext applicationContext;
    private MessageHandler messageHandler;

    public AdminHandlerImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public AdminHandlerImpl setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public AdminHandlerImpl setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        return this;
    }

    public AdminHandlerImpl setConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public AdminHandlerImpl setProperties(AdminProperties properties) {
        this.inProperties = properties;
        return this;
    }

    public AdminHandlerImpl setGridOptions(Map<String, GridOption> gridOptions) {
        this.gridOptions = gridOptions;
        return this;
    }

    public AdminHandlerImpl putGridOption(String name, GridOption gridOption) {
        if (name != null && gridOption != null) {
            if (this.gridOptions == null) {
                this.gridOptions = new HashMap<String, GridOption>();
            }
            this.gridOptions.put(name, gridOption);
        }
        return this;
    }

    public AdminHandlerImpl setGridAdditionals(Map<String, GridAdditional> gridAdditionals) {
        this.gridAdditionals = gridAdditionals;
        return this;
    }

    public AdminHandlerImpl putGridAdditional(String name, GridAdditional gridAdditional) {
        if (name != null && gridAdditional != null) {
            if (this.gridAdditionals == null) {
                this.gridAdditionals = new HashMap<String, GridAdditional>();
            }
            this.gridAdditionals.put(name, gridAdditional);
        }
        return this;
    }

    public AdminHandlerImpl setSyncToCentral(SyncToCentral syncToCentral) {
        this.syncToCentral = syncToCentral;
        return this;
    }

    public AdminHandlerImpl setCheckTokenCentral(CheckTokenCentral checkTokenCentral) {
        this.checkTokenCentral = checkTokenCentral;
        return this;
    }

    public AdminHandlerImpl setAfterReload(AfterReload afterReload) {
        this.afterReload = afterReload;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        String string = this.configFile = this.configFile != null ? this.configFile.trim() : "";
        if (!this.configFile.isEmpty()) {
            this.configFile = FrameworkUtil.replacePath(this.configFile);
            byte[] bytes = FrameworkUtil.resourceBytes(this.configFile);
            this.properties = this.dataMapper.read(bytes, AdminProperties.class);
        } else {
            Assert.notNull((Object)this.inProperties, (String)"properties or configFile is required");
            this.properties = this.dataMapper.copy((Object)this.inProperties, AdminProperties.class);
        }
        HelperAdmin.checkProperties(this.properties);
    }

    @Override
    public Callable<AdminHandler> onConfigureBean(ApplicationContext applicationContext) {
        final AdminHandlerImpl self = this;
        self.applicationContext = applicationContext;
        return new Callable<AdminHandler>(){

            @Override
            public AdminHandler call() throws Exception {
                AdminHandlerImpl.this.onReloadBean();
                AdminHandlerImpl.this.configured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.configured;
    }

    public boolean onReloadBean() throws Exception {
        AdminProperties propertiesEi = null;
        if (!this.configFile.isEmpty()) {
            byte[] bytes = FrameworkUtil.resourceBytes(this.configFile);
            propertiesEi = this.dataMapper.read(bytes, AdminProperties.class);
        } else {
            propertiesEi = this.dataMapper.copy((Object)this.inProperties, AdminProperties.class);
        }
        HelperAdmin.checkProperties(propertiesEi);
        if (this.syncToCentral != null) {
            this.syncToCentral.doSyncToCentral(propertiesEi);
        } else {
            HelperAdmin.syncToCentral(propertiesEi);
        }
        AdminProperties.Crud crud = propertiesEi.getCrud();
        if (crud == null) {
            crud = new AdminProperties.Crud();
            propertiesEi.setCrud(crud);
        }
        if (crud.getUseNative() == null) {
            crud.setUseNative(Boolean.FALSE);
        }
        if (crud.getMaxLimit() == null || crud.getMaxLimit() <= 0) {
            crud.setMaxLimit(Integer.valueOf(100));
        }
        this.properties = propertiesEi;
        AdminProperties.Grid grid = this.properties.getGrid();
        if (grid != null && !Boolean.FALSE.equals(grid.getEnable())) {
            this.gridHandler = HelperAdmin.getGridHandler(grid.getDefinition(), this.dataMapper, this.redisTemplate, this.messageHandler, grid.getLocation(), this.gridOptions, this.gridAdditionals);
            if (this.gridHandler instanceof BeanConfigure) {
                ((BeanConfigure)((Object)this.gridHandler)).onConfigureBean(this.applicationContext).call();
            }
        }
        ApplicationInfo application = FrameworkUtil.getApplicationInfo(this.applicationContext);
        VersionInfo version = FrameworkUtil.getVersionInfo(this.applicationContext);
        this.info = new MapStringObject().setValue("application", (Object)application).setValue("version", (Object)version);
        this.info = MapStringObject.unmodifiable((MapStringObject)this.info);
        this.beanInfos = FrameworkUtil.getBeanInfos(this.applicationContext);
        AdminProperties.Modules modules = this.properties.getModules();
        this.reloads = HelperReload.getBeans(this.applicationContext, modules.getReload());
        this.cacheGroupInfos = HelperCache.getGroupInfos(this.applicationContext, modules.getCache());
        this.cacheSingleInfos = HelperCache.getSingleInfos(this.applicationContext, modules.getCache());
        this.crudHandler = HelperCrud.getHandler(this.applicationContext, this.properties.getCrud());
        this.redisInfos = HelperRedis.getInfos(this.applicationContext, modules.getRedis());
        this.auditInfos = HelperAudit.getInfos(this.applicationContext, modules.getAudit());
        this.trxManagerInfos = HelperEntity.getTrxManagerInfos(this.applicationContext);
        this.schedulers = HelperScheduler.getHandlers(this.applicationContext, modules.getScheduler());
        this.requestInfos = HelperRequest.getInfos(this.applicationContext, modules.getRequest());
        this.menus = Collections.unmodifiableList(HelperMenu.getMenus(this));
        if (this.afterReload != null) {
            this.afterReload.doAfterReload(this.properties);
        }
        return true;
    }

    @Override
    public AdminProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getRedirect(SecurityCredential credential, String path, Map<String, List<String>> params, String query) {
        return HelperAdmin.getRedirect(this, credential, path, params, query);
    }

    @Override
    public boolean isAdminPath(String path) {
        if (path.startsWith(this.properties.getApi().getRequestPath())) {
            return true;
        }
        return this.properties.getResource() != null && path.startsWith(this.properties.getResource().getRequestPath());
    }

    @Override
    public SecurityUser getSecurityUser(String token) throws Exception {
        if (this.checkTokenCentral != null) {
            return this.checkTokenCentral.doCheckTokenCentral(this.properties, token);
        }
        return HelperAdmin.getSecurityUser(this.dataMapper, this.properties, token);
    }

    @Override
    public MapStringObject info() {
        return this.info;
    }

    @Override
    public List<AdminMenu> menus() {
        return this.menus;
    }

    @Override
    public CrudResult crud(CrudAction action, byte[] data) {
        BeanConfigure.checkBeanConfigure(this);
        if (this.crudHandler == null) {
            throw new UnsupportedOperationException(CrudHandler.class.getSimpleName() + " is not found");
        }
        CrudRequest request = this.crudHandler.getRequest(data);
        return this.crudHandler.execute(action, request);
    }

    @Override
    public Page beans(BeanInfo search, Integer index, Integer size, String order) {
        BeanConfigure.checkBeanConfigure(this);
        return HelperAdmin.beanList(this.beanInfos, search, index, size, order);
    }

    @Override
    public ObjectNode grid(String parent, String name) {
        BeanConfigure.checkBeanConfigure(this);
        ObjectNode grid = null;
        if (this.gridHandler != null && (grid = this.gridHandler.getGrid(parent, name)) != null) {
            this.gridHandler.translate(grid);
            ArrayNode actions = grid.putArray("actions");
            for (CrudAction action : CrudAction.values()) {
                actions.add(action.name());
            }
        }
        return grid;
    }

    @Override
    public Set<String> reload() {
        Assert.notNull(this.reloads, (String)"Module reload unsupported");
        return this.reloads.keySet();
    }

    @Override
    public boolean reload(String name) throws Exception {
        Assert.notNull(this.reloads, (String)"Module reload unsupported");
        BeanReload reload = this.reloads.get(name);
        Assert.notNull((Object)reload, (String)("Reaload bean is not found: " + name));
        return reload.onReloadBean();
    }

    @Override
    public Collection<CacheInfo> cacheSingleInfos() {
        return HelperCache.infos(this.cacheSingleInfos);
    }

    @Override
    public CacheInfo cacheGroupInfo(String name) {
        HelperObject.AdminCacheInfo adinfo = this.cacheGroupInfos != null ? this.cacheGroupInfos.get(name) : null;
        return adinfo != null ? adinfo.getInfo() : null;
    }

    @Override
    public Page cacheKeys(CacheInfo info, Integer index, Integer size) {
        return HelperCache.keys(this.cacheGroupInfos, this.cacheSingleInfos, info, index, size);
    }

    @Override
    public void cacheDeleteKeys(CacheInfo info, Collection<String> keys) {
        HelperCache.delete(this.cacheGroupInfos, this.cacheSingleInfos, info, keys);
    }

    @Override
    public void cacheClear(CacheInfo info) {
        HelperCache.clear(this.cacheGroupInfos, this.cacheSingleInfos, info);
    }

    @Override
    public Collection<RedisInfo> redisInfos() {
        return HelperRedis.infos(this.redisInfos);
    }

    @Override
    public String redisPreFlushDb(String name) {
        return HelperRedis.flushPre("DB", this.redisInfos, name);
    }

    @Override
    public void redisFlushDb(String name, String code) {
        HelperRedis.flushPost("DB", this.redisInfos, name, code);
    }

    @Override
    public String redisPreFlushAll(String name) {
        return HelperRedis.flushPre("ALL", this.redisInfos, name);
    }

    @Override
    public void redisFlushAll(String name, String code) {
        HelperRedis.flushPost("ALL", this.redisInfos, name, code);
    }

    @Override
    public Properties redisProperties(String name) {
        HelperObject.AdminRedisInfo rinfo = this.redisInfos != null ? this.redisInfos.get(name) : null;
        Assert.notNull((Object)rinfo, (String)("RedisInfo is not found: " + name));
        return HelperRedis.getProperties(rinfo);
    }

    @Override
    public AuditAccessible.AuditMember auditInfo(String handler, String manager, String type) {
        return HelperAudit.info(this.auditInfos, handler, manager, type);
    }

    @Override
    public Page auditList(String handler, byte[] data) {
        return HelperAudit.list(this.auditInfos, handler, data);
    }

    @Override
    public AdminTrxManagerInfo managerInfo(String managerName) {
        return HelperEntity.managerInfo(this.dataMapper, this.trxManagerInfos, managerName);
    }

    @Override
    public Page managerEntities(String managerName, AdminTrxManagerInfo.Entity search, Integer index, Integer size, String order) {
        return HelperEntity.managerEntities(this.trxManagerInfos, managerName, search, index, size, order);
    }

    @Override
    public AdminTrxManagerInfo.Entity managerEntity(String managerName, String entityClass) {
        return HelperEntity.managerEntity(this.trxManagerInfos, managerName, entityClass);
    }

    @Override
    public List<String> entityReplica(String managerName, String entityClass, Integer numReplica) {
        return HelperEntity.entityReplica(this.applicationContext, managerName, entityClass, numReplica);
    }

    @Override
    public String entityGrid(String managerName, String entityClass) throws Exception {
        return HelperEntity.entityGrid(this.applicationContext, managerName, entityClass);
    }

    @Override
    public Set<String> schedulerPackages(String name) {
        return HelperScheduler.packages(this.schedulers, name);
    }

    @Override
    public MapStringObject schedulerMetadata(String name) throws Exception {
        return HelperScheduler.metadata(this.dataMapper, this.schedulers, name);
    }

    @Override
    public List<JobGroupDto> schedulerGroups(String name, Boolean isActive) throws Exception {
        return HelperScheduler.groups(this.schedulers, name, isActive);
    }

    @Override
    public List<JobGroupDto> schedulerTriggers(String name, Boolean isActive, Collection<String> groupIds) throws Exception {
        return HelperScheduler.triggers(this.schedulers, name, isActive, groupIds);
    }

    @Override
    public boolean schedulerStart(String name) throws Exception {
        return HelperScheduler.start(this.schedulers, name);
    }

    @Override
    public boolean schedulerStop(String name) throws Exception {
        return HelperScheduler.stop(this.schedulers, name);
    }

    @Override
    public boolean schedulerRunning(String name) throws Exception {
        return HelperScheduler.running(this.schedulers, name);
    }

    @Override
    public JobTriggerDto schedulerPause(String name, String triggerId) throws Exception {
        return HelperScheduler.pause(this.schedulers, name, triggerId);
    }

    @Override
    public JobTriggerDto schedulerResume(String name, String triggerId) throws Exception {
        return HelperScheduler.resume(this.schedulers, name, triggerId);
    }

    @Override
    public JobTriggerDto schedulerTrigger(String name, String triggerId) throws Exception {
        return HelperScheduler.trigger(this.schedulers, name, triggerId);
    }

    @Override
    public JobTriggerDto schedulerDelete(String name, String triggerId) throws Exception {
        return HelperScheduler.delete(this.schedulers, name, triggerId);
    }

    @Override
    public JobTriggerDto schedulerAdd(String name, String triggerId) throws Exception {
        return HelperScheduler.add(this.schedulers, name, triggerId);
    }

    @Override
    public Page requestList(RequestInfo.Search search, Integer index, Integer size, String order) {
        return HelperRequest.getPage(this.requestInfos, search, index, size, order);
    }

    public static interface SyncToCentral {
        public void doSyncToCentral(AdminProperties var1) throws Exception;
    }

    public static interface CheckTokenCentral {
        public SecurityUser doCheckTokenCentral(AdminProperties var1, String var2) throws Exception;
    }

    public static interface AfterReload {
        public void doAfterReload(AdminProperties var1) throws Exception;
    }
}

