/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.ideahut.springboot.admin.AdminHandler;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.grid.GridAdditional;
import net.ideahut.springboot.grid.GridHandler;
import net.ideahut.springboot.grid.GridHandlerImpl;
import net.ideahut.springboot.grid.GridOption;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.message.MessageHandler;
import net.ideahut.springboot.object.BeanInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.security.SecurityCredential;
import net.ideahut.springboot.security.SecurityUser;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.StringUtil;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

final class HelperAdmin {
    private static final Logger log = LoggerFactory.getLogger(HelperAdmin.class);

    private HelperAdmin() {
    }

    static Page beanList(List<BeanInfo> beanInfos, BeanInfo search, Integer index, Integer size, String order) {
        index = index != null && index > 0 ? index : 1;
        size = size != null && size > 0 ? size : 10;
        Page page = Page.of((Integer)index, (Integer)size);
        if (beanInfos != null && !beanInfos.isEmpty()) {
            int max;
            List<BeanInfo> datas = HelperAdmin.beanFilter(beanInfos, search);
            HelperAdmin.beanOrder(datas, order);
            int records = datas.size();
            int min = (index - 1) * size;
            if (min > records - 1) {
                if (index > 1) {
                    index = index - 1;
                }
                min = (index - 1) * size;
                page.setIndex(index);
            }
            if ((max = min + size) > records) {
                max = records;
            }
            page.setRecords(Long.valueOf(records));
            page.setData(datas.subList(min, max));
        }
        return page;
    }

    private static List<BeanInfo> beanFilter(List<BeanInfo> beanInfos, BeanInfo search) {
        List<BeanInfo> datas = new ArrayList<BeanInfo>(beanInfos);
        if (search != null) {
            String className;
            String beanName;
            String string = beanName = search.getBeanName() != null ? search.getBeanName().trim().toLowerCase() : "";
            if (!beanName.isEmpty()) {
                datas = datas.stream().filter(o -> o.getBeanName().toLowerCase().contains(beanName)).toList();
            }
            String string2 = className = search.getClassName() != null ? search.getClassName().trim().toLowerCase() : "";
            if (!className.isEmpty()) {
                datas = datas.stream().filter(o -> o.getClassName().toLowerCase().contains(className)).toList();
            }
            if (search.getIsProxy() != null) {
                datas = datas.stream().filter(o -> o.getIsProxy().equals(search.getIsProxy())).toList();
            }
            if (search.getIsReconfigure() != null) {
                datas = datas.stream().filter(o -> o.getIsReconfigure().equals(search.getIsReconfigure())).toList();
            }
            if (search.getIsReloadable() != null) {
                datas = datas.stream().filter(o -> o.getIsReloadable().equals(search.getIsReloadable())).toList();
            }
        }
        return new ArrayList<BeanInfo>(datas);
    }

    private static void beanOrder(List<BeanInfo> datas, String order) {
        String sortby;
        String string = sortby = order != null ? order.trim() : "";
        if (!sortby.isEmpty() && datas.size() > 1) {
            boolean descending = sortby.startsWith("-");
            if (descending) {
                sortby = sortby.substring(1);
            }
            if ("beanName".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getBeanName().compareTo(o1.getBeanName()) : o1.getBeanName().compareTo(o2.getBeanName()));
            } else if ("className".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getClassName().compareTo(o1.getClassName()) : o1.getClassName().compareTo(o2.getClassName()));
            } else if ("isProxy".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getIsProxy().compareTo(o1.getIsProxy()) : o1.getIsProxy().compareTo(o2.getIsProxy()));
            } else if ("isReloadable".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getIsReloadable().compareTo(o1.getIsReloadable()) : o1.getIsReloadable().compareTo(o2.getIsReloadable()));
            } else if ("isReconfigure".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getIsReconfigure().compareTo(o1.getIsReconfigure()) : o1.getIsReconfigure().compareTo(o2.getIsReconfigure()));
            }
        }
    }

    static void checkProperties(AdminProperties properties) {
        String versionHeader;
        String tokenParam;
        AdminProperties.Central central;
        String resourceEndpoint;
        AdminProperties.Resource resource;
        AdminProperties.Grid grid = properties.getGrid();
        if (grid != null) {
            if (!Boolean.FALSE.equals(grid.getEnable())) {
                Assert.hasLength((String)grid.getLocation(), (String)"properties.grid.location is required");
            }
            if (grid.getLocation() != null) {
                grid.setLocation(FrameworkUtil.replacePath(grid.getLocation()));
            }
        }
        if ((resource = properties.getResource()) != null) {
            String redirectParameter;
            Assert.hasLength((String)resource.getLocations(), (String)"properties.resource.locations is required");
            resource.setLocations(FrameworkUtil.replacePath(resource.getLocations()));
            Assert.hasLength((String)resource.getRequestPath(), (String)"properties.resource.requestPath is required");
            Assert.hasLength((String)resource.getIndexFile(), (String)"properties.resource.indexFile is required");
            if (resource.getTitle() == null) {
                resource.setTitle("");
            }
            if (resource.getAllowedPaths() == null) {
                resource.setAllowedPaths(new HashSet());
            }
            if (resource.getAlwaysToIndex() == null) {
                resource.setAlwaysToIndex(Boolean.TRUE);
            }
            String string = redirectParameter = (redirectParameter = resource.getRedirectParameter()) != null ? redirectParameter.trim() : "";
            if (redirectParameter.isEmpty()) {
                redirectParameter = "_next_";
            }
            resource.setRedirectParameter(redirectParameter);
            String authParameter = resource.getAuthParameter();
            String string2 = authParameter = authParameter != null ? authParameter.trim() : "";
            if (authParameter.isEmpty()) {
                authParameter = "_auth_";
            }
            resource.setAuthParameter(authParameter);
            resource.setRequestPath(StringUtil.removeEnd((String)resource.getRequestPath(), (String)"/"));
            HashSet<String> allowedPaths = new HashSet<String>();
            if (resource.getAllowedPaths() != null) {
                for (String allowedPath : resource.getAllowedPaths()) {
                    String path = StringUtil.removeEnd((String)allowedPath, (String)"/");
                    path = StringUtil.removeStart((String)path, (String)"/");
                    allowedPaths.add(path);
                }
            }
            allowedPaths.add(resource.getIndexFile());
            resource.setAllowedPaths(allowedPaths);
        }
        AdminProperties.Api api = properties.getApi();
        Assert.notNull((Object)api, (String)"properties.api is required");
        Assert.hasLength((String)api.getRequestPath(), (String)"properties.api.requestPath is required");
        api.setRequestPath(StringUtil.removeEnd((String)api.getRequestPath(), (String)"/"));
        String loginPath = api.getLoginPath();
        loginPath = loginPath != null ? loginPath.trim() : "";
        loginPath = !loginPath.isEmpty() ? loginPath : "/login";
        api.setLoginPath(StringUtil.removeEnd((String)loginPath, (String)"/"));
        String logoutPath = api.getLogoutPath();
        logoutPath = logoutPath != null ? logoutPath.trim() : "";
        logoutPath = !logoutPath.isEmpty() ? logoutPath : "/logout";
        api.setLogoutPath(StringUtil.removeEnd((String)logoutPath, (String)"/"));
        String infoHeader = api.getInfoHeader();
        String string = infoHeader = infoHeader != null ? infoHeader.trim() : "";
        if (infoHeader.isEmpty()) {
            infoHeader = "Admin-Info";
        }
        api.setInfoHeader(infoHeader);
        if (properties.getModules() == null) {
            properties.setModules(new AdminProperties.Modules());
        }
        if (properties.getCentral() == null) {
            properties.setCentral(new AdminProperties.Central());
        }
        String string3 = resourceEndpoint = (resourceEndpoint = (central = properties.getCentral()).getResourceEndpoint()) != null ? resourceEndpoint : "";
        if (!HelperAdmin.isHttp(resourceEndpoint)) {
            resourceEndpoint = "";
        }
        central.setResourceEndpoint(resourceEndpoint);
        String tokenEndpoint = central.getTokenEndpoint();
        String string4 = tokenEndpoint = tokenEndpoint != null ? tokenEndpoint : "";
        if (!HelperAdmin.isHttp(tokenEndpoint)) {
            tokenEndpoint = "";
        }
        central.setTokenEndpoint(tokenEndpoint);
        String string5 = tokenParam = central.getTokenParam() != null ? central.getTokenParam().trim() : "";
        if (tokenParam.isEmpty()) {
            tokenParam = "_token_";
        }
        central.setTokenParam(tokenParam);
        central.setResourceDirectory(central.getResourceDirectory() != null ? FrameworkUtil.replacePath(central.getResourceDirectory().trim()) : "");
        String string6 = versionHeader = central.getVersionHeader() != null ? central.getVersionHeader().trim() : "";
        if (versionHeader.isEmpty()) {
            versionHeader = "Admin-Version";
        }
        central.setVersionHeader(versionHeader);
    }

    static String getRedirect(AdminHandler adminHandler, SecurityCredential credential, String servletPath, Map<String, List<String>> reqparams, String queryString) {
        String indexPath;
        boolean isIndexPage;
        AdminProperties properties = adminHandler.getProperties();
        AdminProperties.Resource resource = properties.getResource();
        String pathResource = resource.getRequestPath() + "/";
        if (((String)servletPath).length() < pathResource.length() && !((String)servletPath).endsWith("/")) {
            servletPath = (String)servletPath + "/";
        }
        Map parameters = StringUtil.queryStringToMap((String)queryString);
        if (reqparams != null) {
            parameters.putAll(reqparams);
        }
        if (isIndexPage = (indexPath = pathResource + resource.getIndexFile()).equals(servletPath)) {
            AdminProperties.Central central = properties.getCentral();
            if (central != null) {
                String token;
                List ptoken = (List)parameters.get(central.getTokenParam());
                String string = token = ptoken != null && !ptoken.isEmpty() ? (String)ptoken.get(0) : "";
                if (!token.isEmpty()) {
                    String auth;
                    List pauth = (List)parameters.get(resource.getAuthParameter());
                    String string2 = auth = pauth != null && !pauth.isEmpty() ? (String)pauth.get(0) : "";
                    if (auth.isEmpty()) {
                        try {
                            SecurityUser user = adminHandler.getSecurityUser(token);
                            if (user != null) {
                                String authorization = (String)user.getAttribute(String.class, "authorization");
                                if (authorization != null) {
                                    MapStringObject parameter = new MapStringObject();
                                    parameter.put((Object)"authorization", (Object)authorization);
                                    parameter.put((Object)"user", (Object)user);
                                    credential.registerUser(parameter);
                                } else {
                                    authorization = UUID.randomUUID().toString();
                                    MapStringObject parameter = new MapStringObject();
                                    parameter.put((Object)"authorization", (Object)authorization);
                                    parameter.put((Object)"user", (Object)user);
                                    credential.registerUser(parameter);
                                }
                                return (String)servletPath + "?" + resource.getAuthParameter() + "=" + authorization;
                            }
                        }
                        catch (Exception e) {
                            log.warn("Failed to check and register user, because: " + e);
                        }
                    }
                }
            }
        } else if (((String)servletPath).startsWith(pathResource)) {
            String nextPath;
            Object stringQuery = StringUtil.mapToQueryString((Map)parameters);
            if (!((String)stringQuery).isEmpty()) {
                stringQuery = "?" + (String)stringQuery;
            }
            if ((nextPath = ((String)servletPath).substring(pathResource.length())).isEmpty()) {
                return pathResource + resource.getIndexFile() + (String)stringQuery;
            }
            int idx = nextPath.indexOf("/");
            if (idx != -1) {
                nextPath = nextPath.substring(0, idx);
            }
            if (!resource.getAllowedPaths().contains(nextPath) && Boolean.TRUE.equals(resource.getAlwaysToIndex())) {
                Object redirect = "/" + nextPath + (String)stringQuery;
                redirect = Base64.getEncoder().encodeToString(((String)redirect).getBytes());
                try {
                    redirect = URLEncoder.encode((String)redirect, StandardCharsets.UTF_8.name());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return pathResource + resource.getIndexFile() + "?" + resource.getRedirectParameter() + "=" + (String)redirect;
            }
        }
        return null;
    }

    static GridHandler getGridHandler(String definition, DataMapper dataMapper, RedisTemplate<String, byte[]> redisTemplate, MessageHandler messageHandler, String location, Map<String, GridOption> options, Map<String, GridAdditional> additionals) throws Exception {
        String string = location = location != null ? location.trim() : "";
        if (!location.isEmpty()) {
            GridHandlerImpl gridHandler = new GridHandlerImpl().setDataMapper(dataMapper).setLocation(location).setDefinition(definition).setMessageHandler(messageHandler).setRedisTemplate(redisTemplate).setAdditionals(additionals).setOptions(options).setPrefix(AdminHandler.class.getSimpleName() + "-Grid");
            gridHandler.afterPropertiesSet();
            return gridHandler;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void syncToCentral(AdminProperties properties) throws Exception {
        block34: {
            AdminProperties.Central central = properties.getCentral();
            if (central != null) {
                String resourceEndpoint;
                String resDir;
                File resourceDirectory = null;
                String string = resDir = central.getResourceDirectory() != null ? central.getResourceDirectory().trim() : "";
                if (!resDir.isEmpty() && (resourceDirectory = new File(resDir)).isFile()) {
                    resourceDirectory = null;
                }
                String string2 = resourceEndpoint = central.getResourceEndpoint() != null ? central.getResourceEndpoint().trim() : "";
                if (HelperAdmin.isHttp(resourceEndpoint) && resourceDirectory != null) {
                    Response response = null;
                    ResponseBody body = null;
                    try {
                        File fileVersion = new File(resourceDirectory, ".version");
                        String localVersion = "";
                        if (fileVersion.isFile()) {
                            localVersion = FileUtils.readFileToString((File)fileVersion, (Charset)StandardCharsets.UTF_8).trim();
                        }
                        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).callTimeout(60L, TimeUnit.SECONDS).build();
                        String url = HttpUrl.parse((String)resourceEndpoint).newBuilder().addQueryParameter("version", localVersion).build().toString();
                        Request request = new Request.Builder().url(url).build();
                        Call call = client.newCall(request);
                        response = call.execute();
                        int status = response.code();
                        body = response.body();
                        if (HttpStatus.OK.value() != status) break block34;
                        String serverVersion = response.header(central.getVersionHeader());
                        String contentType = response.header("Content-Type");
                        if (contentType == null || !MediaType.APPLICATION_OCTET_STREAM.equals((Object)MediaType.valueOf((String)contentType))) break block34;
                        FileUtils.deleteQuietly((File)resourceDirectory);
                        ZipInputStream zis = new ZipInputStream(body.byteStream());
                        ZipEntry zen = zis.getNextEntry();
                        byte[] buffer = new byte[1024];
                        while (zen != null) {
                            File destFile = new File(resourceDirectory, zen.getName());
                            if (zen.isDirectory()) {
                                if (!destFile.isDirectory() && !destFile.mkdirs()) {
                                    throw new Exception("Failed to create directory " + destFile);
                                }
                            } else {
                                File parent = destFile.getParentFile();
                                if (!parent.isDirectory() && !parent.mkdirs()) {
                                    throw new Exception("Failed to create directory " + parent);
                                }
                                try (FileOutputStream fos = new FileOutputStream(destFile);){
                                    int len;
                                    while ((len = zis.read(buffer)) > 0) {
                                        fos.write(buffer, 0, len);
                                    }
                                    fos.flush();
                                }
                            }
                            zen = zis.getNextEntry();
                        }
                        zis.closeEntry();
                        zis.close();
                        FileUtils.write((File)fileVersion, (CharSequence)serverVersion, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (Exception e) {
                        log.warn("SyncToCentral ({}): {}", (Object)resourceEndpoint, e != null ? e.getMessage() : e);
                    }
                    finally {
                        if (body != null) {
                            try {
                                body.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SecurityUser getSecurityUser(DataMapper dataMapper, AdminProperties properties, String token) {
        AdminProperties.Central central = properties.getCentral();
        if (central != null) {
            String tokenEndpoint;
            String string = tokenEndpoint = central.getTokenEndpoint() != null ? central.getTokenEndpoint().trim() : "";
            if (HelperAdmin.isHttp(tokenEndpoint)) {
                Response response = null;
                ResponseBody body = null;
                try {
                    OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).callTimeout(60L, TimeUnit.SECONDS).build();
                    FormBody form = new FormBody.Builder().add("token", token).build();
                    Request request = new Request.Builder().url(tokenEndpoint).post((RequestBody)form).build();
                    Call call = client.newCall(request);
                    response = call.execute();
                    int status = response.code();
                    body = response.body();
                    if (HttpStatus.OK.value() == status) {
                        JsonNode data = dataMapper.read(body.byteStream(), JsonNode.class);
                        SecurityUser securityUser = dataMapper.copy((Object)data.get("data"), SecurityUser.class);
                        return securityUser;
                    }
                }
                catch (Exception e) {
                    log.warn("GetSecurityUser ({}): {}", (Object)tokenEndpoint, e != null ? e.getMessage() : e);
                }
                finally {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return null;
    }

    private static boolean isHttp(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }
}

