/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.crud.CrudHandler;
import net.ideahut.springboot.crud.CrudHandlerImpl;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.util.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

final class HelperCrud {
    private static final Logger log = LoggerFactory.getLogger(HelperCrud.class);

    private HelperCrud() {
    }

    static CrudHandler getHandler(ApplicationContext applicationContext, AdminProperties.Crud crud) throws Exception {
        EntityTrxManager entityTrxManager = (EntityTrxManager)applicationContext.getBean(EntityTrxManager.class);
        try {
            entityTrxManager = (EntityTrxManager)applicationContext.getBean(EntityTrxManager.class);
        }
        catch (Exception e) {
            log.warn("EntityTrxManager bean is not found");
        }
        if (entityTrxManager != null) {
            EntityTrxManager fEntityTrxManager = entityTrxManager;
            CrudHandlerImpl crudHandler = new CrudHandlerImpl().setApplicationContext(applicationContext).setAlwaysUseNative(crud.getUseNative()).setEntityTrxManager(entityTrxManager).setResource((manager, name) -> {
                try {
                    Class clazz = FrameworkUtil.classOf(name);
                    TrxManagerInfo trxManagerInfo = fEntityTrxManager.getDefaultTrxManagerInfo();
                    if (manager != null && !manager.isEmpty()) {
                        trxManagerInfo = fEntityTrxManager.getTrxManagerInfo(manager);
                    }
                    EntityInfo entityInfo = trxManagerInfo.getEntityInfo(clazz);
                    CrudProperties resource = new CrudProperties();
                    resource.setEntityInfo(entityInfo);
                    resource.setMaxLimit(crud.getMaxLimit());
                    return resource;
                }
                catch (Exception e) {
                    throw FrameworkUtil.exception(e);
                }
            }).setPermission((action, request) -> true);
            crudHandler.afterPropertiesSet();
            return crudHandler;
        }
        return null;
    }
}

