/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.ArrayList;
import java.util.List;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.grid.GridHandler;
import net.ideahut.springboot.grid.GridParent;
import net.ideahut.springboot.grid.GridSource;
import net.ideahut.springboot.mapper.DataMapper;

final class HelperGrid {
    private HelperGrid() {
    }

    static AdminMenu getMenu(DataMapper dataMapper, GridHandler gridHandler, AdminProperties.Module module) {
        if (gridHandler == null) {
            return null;
        }
        List<GridParent> grids = gridHandler.getTree();
        if (grids.isEmpty()) {
            return null;
        }
        String prefix = "grid";
        AdminMenu mroot = new AdminMenu();
        mroot.setId(prefix);
        mroot.setLink("");
        mroot.setTitle("Grid");
        if (!HelperMenu.isMenuEnable(mroot, module)) {
            return null;
        }
        String path = !mroot.getLink().isEmpty() ? mroot.getLink() : "/grid";
        mroot.setLink("");
        AdminMenu proot = dataMapper.copy((Object)mroot, AdminMenu.class);
        mroot.setChildren(new ArrayList());
        if (grids.size() == 1) {
            GridParent parent = grids.get(0);
            List<GridSource> sources = parent.getSources();
            int i = 0;
            for (GridSource source : sources) {
                AdminMenu menu = new AdminMenu();
                menu.setId(prefix + "_" + i);
                menu.setLink(path + "?name=" + source.getName() + "&parent=" + parent.getName());
                menu.setTitle(source.getTitle());
                menu.setParent(proot);
                mroot.getChildren().add(menu);
                ++i;
            }
        } else {
            int i = 0;
            for (GridParent parent : grids) {
                AdminMenu mmenu = new AdminMenu();
                mmenu.setId(prefix + "_" + i);
                mmenu.setLink("");
                mmenu.setTitle(parent.getTitle());
                mmenu.setParent(proot);
                AdminMenu pmenu = dataMapper.copy((Object)mmenu, AdminMenu.class);
                mmenu.setChildren(new ArrayList());
                int j = 0;
                for (GridSource source : parent.getSources()) {
                    AdminMenu child = new AdminMenu();
                    child.setId(prefix + "_" + i + "_" + j);
                    child.setLink(path + "?name=" + source.getName() + "&parent=" + parent.getName());
                    child.setTitle(source.getTitle());
                    child.setParent(pmenu);
                    mmenu.getChildren().add(child);
                    ++j;
                }
                mroot.getChildren().add(mmenu);
                ++i;
            }
        }
        return mroot;
    }
}

