/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.admin.AdminHandler;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.DepreHelper;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.admin.HelperObject;
import net.ideahut.springboot.redis.RedisInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.Assert;

final class HelperRedis {
    private static final Logger log = LoggerFactory.getLogger(HelperRedis.class);
    private static final String FLUSH_PREFIX = AdminHandler.class.getSimpleName() + "_REDIS_FLUSH_";

    private HelperRedis() {
    }

    static Map<String, HelperObject.AdminRedisInfo> getInfos(ApplicationContext applicationContext, AdminProperties.Module module) {
        if (module == null || !Boolean.FALSE.equals(module.getEnable())) {
            try {
                TreeMap<String, HelperObject.AdminRedisInfo> adinfos = new TreeMap<String, HelperObject.AdminRedisInfo>();
                Map beans = applicationContext.getBeansOfType(RedisOperations.class);
                for (Map.Entry entry : beans.entrySet()) {
                    RedisInfo info = new RedisInfo();
                    info.setName((String)entry.getKey());
                    info.setLabel(((String)entry.getKey()).substring(0, 1).toUpperCase() + ((String)entry.getKey()).substring(1));
                    info.setKeyType(((RedisOperations)entry.getValue()).getKeySerializer().getTargetType().getName());
                    info.setValueType(((RedisOperations)entry.getValue()).getValueSerializer().getTargetType().getName());
                    HelperObject.AdminRedisInfo adinfo = new HelperObject.AdminRedisInfo();
                    adinfo.setInfo(info);
                    adinfo.setBean(entry.getValue());
                    Properties properties = HelperRedis.getProperties(adinfo);
                    info.setCanExecute(Boolean.valueOf(properties != null));
                    adinfos.put(info.getName(), adinfo);
                }
                return adinfos;
            }
            catch (Exception e) {
                log.warn("RedisInfos", (Object)e.getMessage());
            }
        }
        return null;
    }

    static AdminMenu getMenu(Map<String, HelperObject.AdminRedisInfo> redisInfos, AdminProperties.Module module) {
        if (redisInfos != null && !redisInfos.isEmpty()) {
            AdminMenu mroot = new AdminMenu();
            mroot.setId("redis");
            mroot.setLink("/redis");
            mroot.setTitle("Redis");
            if (HelperMenu.isMenuEnable(mroot, module)) {
                return mroot;
            }
        }
        return null;
    }

    static Properties getProperties(HelperObject.AdminRedisInfo info) {
        if (info.getBean() != null) {
            return (Properties)((RedisOperations)info.getBean()).execute(connection -> {
                try {
                    return DepreHelper.redisInfo(connection);
                }
                catch (Exception e) {
                    String msg;
                    String string = msg = e != null ? e.getMessage() : "";
                    if (!msg.startsWith("NOAUTH Authentication")) {
                        log.warn("RedisInfo-" + info.getInfo().getName() + ": {}", (Object)msg);
                    }
                    return null;
                }
            });
        }
        return null;
    }

    static Collection<RedisInfo> infos(Map<String, HelperObject.AdminRedisInfo> redisInfos) {
        if (redisInfos != null) {
            ArrayList<RedisInfo> infos = new ArrayList<RedisInfo>();
            for (Map.Entry<String, HelperObject.AdminRedisInfo> entry : redisInfos.entrySet()) {
                if (!Boolean.TRUE.equals(entry.getValue().getInfo().getCanExecute())) continue;
                RedisInfo info = new RedisInfo();
                BeanUtils.copyProperties((Object)entry.getValue().getInfo(), (Object)info);
                infos.add(info);
            }
            return infos;
        }
        return null;
    }

    static String flushPre(String id, Map<String, HelperObject.AdminRedisInfo> redisInfos, String name) {
        HelperObject.AdminRedisInfo info = redisInfos != null ? redisInfos.get(name) : null;
        Assert.notNull((Object)info, (String)("RedisInfo is not found: " + name));
        return (String)((RedisOperations)info.getBean()).execute(connection -> {
            byte[] value;
            String code = UUID.randomUUID().toString();
            byte[] key = (FLUSH_PREFIX + id + code).getBytes();
            if (Boolean.TRUE.equals(DepreHelper.redisSet(connection, key, value = name.getBytes()))) {
                DepreHelper.redisExpire(connection, key, TimeUnit.SECONDS, 300L);
            }
            return code;
        });
    }

    static void flushPost(String id, Map<String, HelperObject.AdminRedisInfo> redisInfos, String name, String code) {
        HelperObject.AdminRedisInfo info = redisInfos != null ? redisInfos.get(name) : null;
        Assert.notNull((Object)info, (String)("RedisInfo is not found: " + name));
        ((RedisOperations)info.getBean()).execute(connection -> {
            byte[] key = (FLUSH_PREFIX + id + code).getBytes();
            byte[] value = DepreHelper.redisGet(connection, key);
            if (value != null) {
                String cname = new String(value);
                Assert.isTrue((boolean)cname.equals(name), (String)"Invalid code");
                if ("DB".equals(id)) {
                    DepreHelper.redisFlushDb(connection);
                } else if ("ALL".equals(id)) {
                    DepreHelper.redisFlushAll(connection);
                }
            }
            return null;
        });
    }
}

