/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.admin.HelperMenu;
import net.ideahut.springboot.object.KeyValue;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.object.RequestInfo;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RequestMethod;

final class HelperRequest {
    private HelperRequest() {
    }

    static List<RequestInfo> getInfos(ApplicationContext applicationContext, AdminProperties.Module module) {
        if (module == null || !Boolean.FALSE.equals(module.getEnable())) {
            return FrameworkUtil.getRequestInfos(applicationContext, false);
        }
        return new ArrayList<RequestInfo>();
    }

    static AdminMenu getMenu(List<RequestInfo> requestMapInfos, AdminProperties.Module module) {
        if (requestMapInfos != null && !requestMapInfos.isEmpty()) {
            AdminMenu mroot = new AdminMenu();
            mroot.setId("request");
            mroot.setLink("/request");
            mroot.setTitle("Request");
            if (HelperMenu.isMenuEnable(mroot, module)) {
                return mroot;
            }
        }
        return null;
    }

    static Page getPage(List<RequestInfo> requestInfos, RequestInfo.Search search, Integer index, Integer size, String order) {
        index = index != null && index > 0 ? index : 1;
        size = size != null && size > 0 ? size : 10;
        Page page = Page.of((Integer)index, (Integer)size);
        if (requestInfos != null && !requestInfos.isEmpty()) {
            int max;
            List<RequestInfo> datas = HelperRequest.filter(requestInfos, search);
            HelperRequest.order(datas, order);
            int records = datas.size();
            int min = (index - 1) * size;
            if (min > records - 1) {
                if (index > 1) {
                    index = index - 1;
                }
                min = (index - 1) * size;
                page.setIndex(index);
            }
            if ((max = min + size) > records) {
                max = records;
            }
            page.setRecords(Long.valueOf(records));
            page.setData(datas.subList(min, max));
        }
        return page;
    }

    private static List<RequestInfo> filter(List<RequestInfo> requestInfos, RequestInfo.Search search) {
        List<RequestInfo> datas = new ArrayList<RequestInfo>(requestInfos);
        if (search != null) {
            String annotation;
            String function;
            String method;
            String bean;
            String path;
            String string = path = search.getPath() != null ? search.getPath().trim().toLowerCase() : "";
            if (!path.isEmpty()) {
                datas = datas.stream().filter(o -> {
                    for (String patternValue : o.getPatternValues()) {
                        if (!patternValue.toLowerCase().contains(path)) continue;
                        return true;
                    }
                    return false;
                }).toList();
            }
            String string2 = bean = search.getBean() != null ? search.getBean().trim().toLowerCase() : "";
            if (!bean.isEmpty()) {
                datas = datas.stream().filter(o -> o.getHandler().getBean().toLowerCase().contains(bean)).toList();
            }
            String string3 = method = search.getMethod() != null ? search.getMethod().trim().toUpperCase() : "";
            if (!method.isEmpty()) {
                datas = datas.stream().filter(o -> {
                    for (RequestMethod rmethod : o.getMethods()) {
                        if (!rmethod.name().equals(method)) continue;
                        return true;
                    }
                    return false;
                }).toList();
            }
            String string4 = function = search.getFunction() != null ? search.getFunction().trim().toLowerCase() : "";
            if (!function.isEmpty()) {
                datas = datas.stream().filter(o -> o.getHandler().getMethod().getName().toLowerCase().contains(function)).toList();
            }
            String string5 = annotation = search.getAnnotation() != null ? search.getAnnotation().trim().toLowerCase() : "";
            if (!annotation.isEmpty()) {
                datas = datas.stream().filter(o -> {
                    for (KeyValue mannot : o.getHandler().getMethod().getAnnotations()) {
                        if (!((String)((Object)mannot.getKey())).toLowerCase().contains(annotation)) continue;
                        return true;
                    }
                    return false;
                }).toList();
            }
            if (search.getIsPublic() != null) {
                datas = datas.stream().filter(o -> o.isPublic() == search.getIsPublic().booleanValue()).toList();
            }
            if (search.getIsExclude() != null) {
                datas = datas.stream().filter(o -> o.isExclude() == search.getIsExclude().booleanValue()).toList();
            }
        }
        return new ArrayList<RequestInfo>(datas);
    }

    private static void order(List<RequestInfo> datas, String order) {
        String sortby;
        String string = sortby = order != null ? order.trim() : "";
        if (!sortby.isEmpty() && datas.size() > 1) {
            boolean descending = sortby.startsWith("-");
            if (descending) {
                sortby = sortby.substring(1);
            }
            if ("bean".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getHandler().getBean().compareTo(o1.getHandler().getBean()) : o1.getHandler().getBean().compareTo(o2.getHandler().getBean()));
            } else if ("path".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getPatternValues().iterator().next().compareTo(o1.getPatternValues().iterator().next()) : o1.getPatternValues().iterator().next().compareTo(o2.getPatternValues().iterator().next()));
            } else if ("method".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getMethods().iterator().next().compareTo((Enum)o1.getMethods().iterator().next()) : o1.getMethods().iterator().next().compareTo((Enum)o2.getMethods().iterator().next()));
            } else if ("function".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? o2.getHandler().getMethod().getName().compareTo(o1.getHandler().getMethod().getName()) : o1.getHandler().getMethod().getName().compareTo(o2.getHandler().getMethod().getName()));
            } else if ("public".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? Boolean.compare(o2.isPublic(), o1.isPublic()) : Boolean.compare(o1.isPublic(), o2.isPublic()));
            } else if ("exclude".equals(sortby)) {
                Collections.sort(datas, (o1, o2) -> descending ? Boolean.compare(o2.isExclude(), o1.isExclude()) : Boolean.compare(o1.isExclude(), o2.isExclude()));
            }
        }
    }
}

