/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import java.net.InetSocketAddress;
import java.util.UUID;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.security.SecurityCredential;
import net.ideahut.springboot.security.SecurityUser;
import net.ideahut.springboot.security.WebFluxSecurityAuthorization;
import net.ideahut.springboot.util.WebFluxUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebFluxAdminSecurity
implements WebFluxSecurityAuthorization,
InitializingBean {
    private SecurityCredential credential;
    private AdminProperties properties;
    private DataMapper dataMapper;
    private String headerKey;
    private Boolean enableRemoteHost;
    private Boolean enableUserAgent;

    public WebFluxAdminSecurity setCredential(SecurityCredential credential) {
        this.credential = credential;
        return this;
    }

    public WebFluxAdminSecurity setProperties(AdminProperties properties) {
        this.properties = properties;
        return this;
    }

    public WebFluxAdminSecurity setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public WebFluxAdminSecurity setHeaderKey(String headerKey) {
        this.headerKey = headerKey;
        return this;
    }

    public String getHeaderKey() {
        return this.headerKey;
    }

    public WebFluxAdminSecurity setEnableRemoteHost(Boolean enableRemoteHost) {
        this.enableRemoteHost = enableRemoteHost;
        return this;
    }

    public WebFluxAdminSecurity setEnableUserAgent(Boolean enableUserAgent) {
        this.enableUserAgent = enableUserAgent;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.credential, (String)"credential is required");
        Assert.notNull((Object)this.properties, (String)"properties is required");
        String string = this.headerKey = this.headerKey != null ? this.headerKey.trim() : "";
        if (this.headerKey.isEmpty()) {
            this.headerKey = "Authorization";
        }
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        if (this.enableRemoteHost == null) {
            this.enableRemoteHost = Boolean.FALSE;
        }
        if (this.enableUserAgent == null) {
            this.enableUserAgent = Boolean.FALSE;
        }
    }

    @Override
    public Mono<Void> isRequestAuthorized(ServerWebExchange exchange) {
        String agent;
        String host;
        ServerHttpRequest request = exchange.getRequest();
        AdminProperties.Resource resource = this.properties.getResource();
        String resourcePath = resource.getRequestPath();
        String servletPath = request.getPath().pathWithinApplication().value();
        if (servletPath.startsWith(resourcePath)) {
            return null;
        }
        AdminProperties.Api api = this.properties.getApi();
        boolean isInfo = WebFluxUtil.getHeader(Boolean.TYPE, (HttpMessage)request, api.getInfoHeader(), false);
        if (isInfo) {
            return this.info(exchange);
        }
        String loginPath = api.getRequestPath() + api.getLoginPath();
        if (servletPath.startsWith(loginPath) && HttpMethod.POST.equals((Object)request.getMethod())) {
            return this.login(exchange);
        }
        String authorization = WebFluxUtil.getHeader((HttpMessage)request, this.headerKey, "");
        if (authorization.isEmpty()) {
            return this.notAuthorized(exchange);
        }
        MapStringObject parameter = new MapStringObject();
        parameter.put((Object)"authorization", (Object)authorization);
        parameter.put((Object)"host", (Object)WebFluxUtil.getRemoteHost(request));
        parameter.put((Object)"agent", (Object)WebFluxUtil.getUserAgent(request));
        if (!this.credential.isValidCredential(parameter)) {
            return this.notAuthorized(exchange);
        }
        SecurityUser user = this.credential.getSecurityUser(parameter);
        if (Boolean.TRUE.equals(this.enableRemoteHost) && !(host = (String)user.getAttribute(String.class, SecurityUser.Attribute.HOST, (Object)"")).equals(WebFluxUtil.getRemoteHost(request))) {
            return this.notAuthorized(exchange);
        }
        if (Boolean.TRUE.equals(this.enableUserAgent) && !(agent = (String)user.getAttribute(String.class, SecurityUser.Attribute.AGENT, (Object)"")).equals(WebFluxUtil.getUserAgent(request))) {
            return this.notAuthorized(exchange);
        }
        String logoutPath = api.getRequestPath() + api.getLogoutPath();
        if (servletPath.startsWith(logoutPath)) {
            return this.logout(parameter);
        }
        return null;
    }

    private Mono<Void> info(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        MapStringObject info = new MapStringObject();
        info.put((Object)"ContextPath", (Object)request.getPath().contextPath().value());
        info.put((Object)"Method", (Object)request.getMethod().name());
        info.put((Object)"QueryParams", (Object)request.getQueryParams());
        InetSocketAddress address = request.getRemoteAddress();
        if (address != null) {
            if (address.getAddress() != null) {
                info.put((Object)"RemoteAddr", (Object)address.getAddress().getHostAddress());
            }
            info.put((Object)"RemoteHost", (Object)address.getHostName());
            info.put((Object)"RemotePort", (Object)address.getPort());
        }
        info.put((Object)"RequestId", (Object)request.getId());
        info.put((Object)"RequestURI", (Object)request.getURI());
        info.put((Object)"ServletPath", (Object)request.getPath().pathWithinApplication().value());
        info.put((Object)"Headers", (Object)request.getHeaders());
        info.put((Object)"Parameters", (Object)request.getQueryParams());
        info.put((Object)"Cookies", (Object)request.getCookies());
        return this.sendResult(exchange, Result.success((Object)info));
    }

    private Mono<Void> login(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        String username = (String)request.getQueryParams().getFirst((Object)"username");
        if (username == null || username.isEmpty()) {
            return this.sendResult(exchange, Result.error((String)"LOGIN-01", (String)"username is required"));
        }
        String password = (String)request.getQueryParams().getFirst((Object)"password");
        if (password == null || password.isEmpty()) {
            return this.sendResult(exchange, Result.error((String)"LOGIN-02", (String)"password is required"));
        }
        String authorization = UUID.randomUUID().toString();
        MapStringObject parameter = new MapStringObject();
        parameter.put((Object)"username", (Object)username);
        parameter.put((Object)"password", (Object)password);
        parameter.put((Object)"authorization", (Object)authorization);
        parameter.put((Object)"host", (Object)WebFluxUtil.getRemoteHost(request));
        parameter.put((Object)"agent", (Object)WebFluxUtil.getUserAgent(request));
        if (!this.credential.registerUser(parameter)) {
            return this.sendResult(exchange, Result.error((String)"LOGIN-03", (String)"Invalid user"));
        }
        return this.sendResult(exchange, Result.success((Object)authorization));
    }

    private Mono<Void> logout(MapStringObject parameter) {
        this.credential.invalidate(parameter);
        return Mono.empty();
    }

    private Mono<Void> notAuthorized(ServerWebExchange exchange) {
        exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        return Mono.empty();
    }

    private Mono<Void> sendResult(ServerWebExchange exchange, Result result) {
        return WebFluxUtil.sendToClient(this.dataMapper, exchange, result);
    }
}

