/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.ideahut.springboot.admin.AdminHandler;
import net.ideahut.springboot.admin.AdminMenu;
import net.ideahut.springboot.admin.AdminTrxManagerInfo;
import net.ideahut.springboot.audit.AuditAccessible;
import net.ideahut.springboot.cache.CacheInfo;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudResult;
import net.ideahut.springboot.job.dto.JobGroupDto;
import net.ideahut.springboot.job.dto.JobTriggerDto;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.BeanInfo;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.object.Page;
import net.ideahut.springboot.object.RequestInfo;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.redis.RedisInfo;
import net.ideahut.springboot.util.WebMvcUtil;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class WebMvcAdminController {
    @GetMapping(value={"/check"})
    public Result check(HttpServletRequest request, HttpServletResponse response) {
        String authorization = WebMvcUtil.getHeader(request, "Authorization", "");
        if (!authorization.isEmpty()) {
            String authToken = Base64.getEncoder().encodeToString(authorization.getBytes());
            response.setHeader("Auth-Token", authToken);
        }
        return Result.success();
    }

    @GetMapping(value={"/info"})
    public Result info() {
        MapStringObject info = this.adminHandler().info();
        return Result.success((Object)info);
    }

    @GetMapping(value={"/beans"})
    public Result beans(@ModelAttribute BeanInfo search, @ModelAttribute Page inPage, @RequestParam(value="order", required=false) String order) {
        Page page = this.adminHandler().beans(search, inPage.getIndex(), inPage.getSize(), order);
        return Result.success((Object)page);
    }

    @GetMapping(value={"/menus"})
    public Result menus() {
        List<AdminMenu> menus = this.adminHandler().menus();
        return Result.success(menus);
    }

    @GetMapping(value={"/grid"})
    public Result grid(@RequestParam(value="name") String name, @RequestParam(value="parent") String parent) {
        ObjectNode grid = this.adminHandler().grid(parent, name);
        return Result.success((Object)grid);
    }

    @PostMapping(value={"/crud/{action}"})
    public Result crud(HttpServletRequest httpServletRequest, @PathVariable(value="action") String action) throws Exception {
        byte[] data = WebMvcUtil.getBodyAsBytes(httpServletRequest);
        CrudResult cres = this.adminHandler().crud(CrudAction.valueOf(action.toUpperCase()), data);
        Result result = cres.getError() != null ? Result.error((Message)cres.getError()) : Result.success((Object)cres.getValue());
        if (cres.getInfo() != null) {
            result.setInfo(cres.getInfo());
        }
        return result;
    }

    @GetMapping(value={"/reload"})
    public Result reload() {
        Set<String> reload = this.adminHandler().reload();
        return Result.success(reload);
    }

    @PostMapping(value={"/reload"})
    public Result reload(@RequestParam(value="name") String name) throws Exception {
        boolean ok = this.adminHandler().reload(name);
        return Result.success((Object)ok);
    }

    @GetMapping(value={"/cache/info"})
    public Result cacheInfo(@RequestParam(value="type") String type, @RequestParam(value="handler", required=false) String handler) {
        if ("single".equals(type)) {
            Collection<CacheInfo> infos = this.adminHandler().cacheSingleInfos();
            return Result.success(infos).setInfo("type", (Object)type);
        }
        if ("group".equals(type)) {
            Assert.hasLength((String)handler, (String)"handler is required");
            CacheInfo info = this.adminHandler().cacheGroupInfo(handler);
            return Result.success((Object)info).setInfo("type", (Object)type);
        }
        return Result.success();
    }

    @PostMapping(value={"/cache/keys"})
    public Result cacheKeys(HttpServletRequest httpServletRequest) throws Exception {
        byte[] data = WebMvcUtil.getBodyAsBytes(httpServletRequest);
        CacheRequest request = this.dataMapper().read(data, CacheRequest.class);
        Page page = this.adminHandler().cacheKeys(request.getInfo(), request.getIndex(), request.getSize());
        return Result.success((Object)page);
    }

    @PostMapping(value={"/cache/delete"})
    public Result cacheDelete(HttpServletRequest httpServletRequest) throws Exception {
        byte[] data = WebMvcUtil.getBodyAsBytes(httpServletRequest);
        CacheRequest request = this.dataMapper().read(data, CacheRequest.class);
        this.adminHandler().cacheDeleteKeys(request.getInfo(), request.getKeys());
        return Result.success();
    }

    @PostMapping(value={"/cache/clear"})
    public Result cacheClear(HttpServletRequest httpServletRequest) throws Exception {
        byte[] data = WebMvcUtil.getBodyAsBytes(httpServletRequest);
        CacheRequest request = this.dataMapper().read(data, CacheRequest.class);
        this.adminHandler().cacheClear(request.getInfo());
        return Result.success();
    }

    @GetMapping(value={"/redis/infos"})
    public Result redisInfos() {
        Collection<RedisInfo> infos = this.adminHandler().redisInfos();
        return Result.success(infos);
    }

    @GetMapping(value={"/redis/properties"})
    public Result redisProperties(@RequestParam(value="name") String name) {
        Properties properties = this.adminHandler().redisProperties(name);
        return Result.success((Object)properties);
    }

    @GetMapping(value={"/redis/flush/db"})
    public Result redisFlushDb(@RequestParam(value="name") String name) {
        String code = this.adminHandler().redisPreFlushDb(name);
        return Result.success((Object)code);
    }

    @PostMapping(value={"/redis/flush/db"})
    public Result redisFlushDb(@RequestParam(value="name") String name, @RequestParam(value="code") String code) {
        this.adminHandler().redisFlushDb(name, code);
        return Result.success();
    }

    @GetMapping(value={"/redis/flush/all"})
    public Result redisFlushAll(@RequestParam(value="name") String name) {
        String code = this.adminHandler().redisPreFlushAll(name);
        return Result.success((Object)code);
    }

    @PostMapping(value={"/redis/flush/all"})
    public Result redisFlushAll(@RequestParam(value="name") String name, @RequestParam(value="code") String code) {
        this.adminHandler().redisFlushAll(name, code);
        return Result.success();
    }

    @GetMapping(value={"/audit/info"})
    public Result auditInfo(@RequestParam(value="handler") String handler, @RequestParam(value="type") String type, @RequestParam(value="manager") String manager) throws Exception {
        AuditAccessible.AuditMember member = this.adminHandler().auditInfo(handler, manager, type);
        return Result.success((Object)member);
    }

    @PostMapping(value={"/audit/list"})
    public Result auditList(HttpServletRequest httpServletRequest, @RequestParam(value="handler") String handler) throws Exception {
        byte[] data = WebMvcUtil.getBodyAsBytes(httpServletRequest);
        Page page = this.adminHandler().auditList(handler, data);
        return Result.success((Object)page);
    }

    @GetMapping(value={"/manager/info"})
    public Result managerInfo(@RequestParam(value="manager") String manager) throws Exception {
        AdminTrxManagerInfo info = this.adminHandler().managerInfo(manager);
        return Result.success((Object)info);
    }

    @GetMapping(value={"/manager/entities"})
    public Result managerEntities(@RequestParam(value="manager") String manager, @ModelAttribute AdminTrxManagerInfo.Entity search, @ModelAttribute Page inPage, @RequestParam(value="order", required=false) String order) throws Exception {
        Page page = this.adminHandler().managerEntities(manager, search, inPage.getIndex(), inPage.getSize(), order);
        return Result.success((Object)page);
    }

    @GetMapping(value={"/manager/entity"})
    public Result managerInfo(@RequestParam(value="manager") String manager, @RequestParam(value="entity") String entity) throws Exception {
        AdminTrxManagerInfo.Entity object = this.adminHandler().managerEntity(manager, entity);
        return Result.success((Object)object);
    }

    @GetMapping(value={"/entity/replica"})
    public Result entityReplica(@RequestParam(value="manager") String manager, @RequestParam(value="entity") String entity, @RequestParam(value="total") Integer total) throws Exception {
        List<String> sqls = this.adminHandler().entityReplica(manager, entity, total);
        return Result.success(sqls);
    }

    @GetMapping(value={"/entity/grid"})
    public Result entityGrid(@RequestParam(value="manager") String manager, @RequestParam(value="entity") String entity) throws Exception {
        String grid = this.adminHandler().entityGrid(manager, entity);
        return Result.success((Object)grid);
    }

    @GetMapping(value={"/scheduler/groups"})
    public Result schedulerGroups(@RequestParam(value="handler") String handler, @RequestParam(name="isActive", required=false) Boolean isActive) throws Exception {
        isActive = isActive != null ? isActive : Boolean.TRUE;
        List<JobGroupDto> groups = this.adminHandler().schedulerGroups(handler, isActive);
        return Result.success(groups);
    }

    @GetMapping(value={"/scheduler/triggers"})
    public Result schedulerTriggers(@RequestParam(value="handler") String handler, @RequestParam(name="isActive", required=false) Boolean isActive, @RequestParam(name="groupId", required=false) List<String> groupIds) throws Exception {
        isActive = isActive != null ? isActive : Boolean.TRUE;
        List<JobGroupDto> groups = this.adminHandler().schedulerTriggers(handler, isActive, groupIds);
        return Result.success(groups);
    }

    @PostMapping(value={"/scheduler/start"})
    public Result schedulerStart(@RequestParam(value="handler") String handler) throws Exception {
        boolean start = this.adminHandler().schedulerStart(handler);
        return Result.success((Object)start);
    }

    @PostMapping(value={"/scheduler/stop"})
    public Result schedulerStop(@RequestParam(value="handler") String handler) throws Exception {
        boolean stop = this.adminHandler().schedulerStop(handler);
        return Result.success((Object)stop);
    }

    @GetMapping(value={"/scheduler/running"})
    public Result schedulerRunning(@RequestParam(value="handler") String handler) throws Exception {
        boolean running = this.adminHandler().schedulerRunning(handler);
        return Result.success((Object)running);
    }

    @GetMapping(value={"/scheduler/metadata"})
    public Result schedulerMetadata(@RequestParam(value="handler") String handler) throws Exception {
        MapStringObject metadata = this.adminHandler().schedulerMetadata(handler);
        boolean running = this.adminHandler().schedulerRunning(handler);
        Set<String> packages = this.adminHandler().schedulerPackages(handler);
        return Result.success((Object)metadata).setInfo("running", (Object)running).setInfo("packages", packages);
    }

    @PostMapping(value={"/scheduler/pause"})
    public Result schedulerPause(@RequestParam(value="handler") String handler, @RequestParam(value="triggerId") String triggerId) throws Exception {
        JobTriggerDto trigger = this.adminHandler().schedulerPause(handler, triggerId);
        return Result.success((Object)trigger);
    }

    @PostMapping(value={"/scheduler/resume"})
    public Result schedulerResume(@RequestParam(value="handler") String handler, @RequestParam(value="triggerId") String triggerId) throws Exception {
        JobTriggerDto trigger = this.adminHandler().schedulerResume(handler, triggerId);
        return Result.success((Object)trigger);
    }

    @PostMapping(value={"/scheduler/trigger"})
    public Result schedulerTrigger(@RequestParam(value="handler") String handler, @RequestParam(value="triggerId") String triggerId) throws Exception {
        JobTriggerDto trigger = this.adminHandler().schedulerTrigger(handler, triggerId);
        return Result.success((Object)trigger);
    }

    @PostMapping(value={"/scheduler/delete"})
    public Result schedulerDelete(@RequestParam(value="handler") String handler, @RequestParam(value="triggerId") String triggerId) throws Exception {
        JobTriggerDto trigger = this.adminHandler().schedulerDelete(handler, triggerId);
        return Result.success((Object)trigger);
    }

    @PostMapping(value={"/scheduler/add"})
    public Result schedulerAdd(@RequestParam(value="handler") String handler, @RequestParam(value="triggerId") String triggerId) throws Exception {
        JobTriggerDto trigger = this.adminHandler().schedulerAdd(handler, triggerId);
        return Result.success((Object)trigger);
    }

    @GetMapping(value={"/request/list"})
    public Result requestList(@ModelAttribute RequestInfo.Search search, @ModelAttribute Page inPage, @RequestParam(value="order", required=false) String order) {
        Page page = this.adminHandler().requestList(search, inPage.getIndex(), inPage.getSize(), order);
        return Result.success((Object)page);
    }

    protected abstract AdminHandler adminHandler();

    protected abstract DataMapper dataMapper();

    private static class CacheRequest {
        private CacheInfo info;
        private Integer index;
        private Integer size;
        private List<String> keys;

        private CacheRequest() {
        }

        public void setInfo(CacheInfo info) {
            this.info = info;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public void setKeys(List<String> keys) {
            this.keys = keys;
        }

        public CacheInfo getInfo() {
            return this.info;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Integer getSize() {
            return this.size;
        }

        public List<String> getKeys() {
            return this.keys;
        }
    }
}

