/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.admin;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import net.ideahut.springboot.admin.AdminProperties;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.MapStringObject;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.security.SecurityAuthorization;
import net.ideahut.springboot.security.SecurityCredential;
import net.ideahut.springboot.security.SecurityUser;
import net.ideahut.springboot.util.WebMvcUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class WebMvcAdminSecurity
implements SecurityAuthorization,
InitializingBean {
    private SecurityCredential credential;
    private AdminProperties properties;
    private DataMapper dataMapper;
    private String headerKey;
    private Boolean enableRemoteHost;
    private Boolean enableUserAgent;

    public WebMvcAdminSecurity setCredential(SecurityCredential credential) {
        this.credential = credential;
        return this;
    }

    public WebMvcAdminSecurity setProperties(AdminProperties properties) {
        this.properties = properties;
        return this;
    }

    public WebMvcAdminSecurity setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public WebMvcAdminSecurity setHeaderKey(String headerKey) {
        this.headerKey = headerKey;
        return this;
    }

    public String getHeaderKey() {
        return this.headerKey;
    }

    public WebMvcAdminSecurity setEnableRemoteHost(Boolean enableRemoteHost) {
        this.enableRemoteHost = enableRemoteHost;
        return this;
    }

    public WebMvcAdminSecurity setEnableUserAgent(Boolean enableUserAgent) {
        this.enableUserAgent = enableUserAgent;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.credential, (String)"credential is required");
        Assert.notNull((Object)this.properties, (String)"properties is required");
        String string = this.headerKey = this.headerKey != null ? this.headerKey.trim() : "";
        if (this.headerKey.isEmpty()) {
            this.headerKey = "Authorization";
        }
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        if (this.enableRemoteHost == null) {
            this.enableRemoteHost = Boolean.FALSE;
        }
        if (this.enableUserAgent == null) {
            this.enableUserAgent = Boolean.FALSE;
        }
    }

    public boolean isRequestAuthorized(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String agent;
        String host;
        String resourcePath;
        String servletPath = request.getServletPath();
        AdminProperties.Resource resource = this.properties.getResource();
        if (resource != null && servletPath.startsWith(resourcePath = resource.getRequestPath())) {
            return true;
        }
        AdminProperties.Api api = this.properties.getApi();
        boolean isInfo = WebMvcUtil.getHeader(Boolean.TYPE, request, api.getInfoHeader(), false);
        if (isInfo) {
            return this.info(request, response);
        }
        String loginPath = api.getRequestPath() + api.getLoginPath();
        if (servletPath.startsWith(loginPath) && "POST".equalsIgnoreCase(request.getMethod())) {
            return this.login(request, response);
        }
        String authorization = WebMvcUtil.getHeader(request, this.headerKey, "");
        if (authorization.isEmpty()) {
            return this.notAuthorized(response);
        }
        String remoteHost = WebMvcUtil.getRemoteHost(request);
        String userAgent = WebMvcUtil.getUserAgent(request);
        MapStringObject parameter = new MapStringObject();
        parameter.put((Object)"authorization", (Object)authorization);
        parameter.put((Object)"host", (Object)remoteHost);
        parameter.put((Object)"agent", (Object)userAgent);
        if (!this.credential.isValidCredential(parameter)) {
            return this.notAuthorized(response);
        }
        SecurityUser user = this.credential.getSecurityUser(parameter);
        if (Boolean.TRUE.equals(this.enableRemoteHost) && !(host = (String)user.getAttribute(String.class, SecurityUser.Attribute.HOST, (Object)"")).equals(remoteHost)) {
            return this.notAuthorized(response);
        }
        if (Boolean.TRUE.equals(this.enableUserAgent) && !(agent = (String)user.getAttribute(String.class, SecurityUser.Attribute.AGENT, (Object)"")).equals(userAgent)) {
            return this.notAuthorized(response);
        }
        String logoutPath = api.getRequestPath() + api.getLogoutPath();
        if (servletPath.startsWith(logoutPath)) {
            return this.logout(parameter);
        }
        return true;
    }

    private boolean info(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Cookie[] rqCookies;
        Enumeration enParameters;
        MapStringObject info = new MapStringObject();
        info.put((Object)"CharacterEncoding", (Object)request.getCharacterEncoding());
        info.put((Object)"ContentType", (Object)request.getContentType());
        info.put((Object)"ContentLength", (Object)request.getContentLengthLong());
        info.put((Object)"ContextPath", (Object)request.getContextPath());
        info.put((Object)"Locale", (Object)request.getLocale().toString());
        info.put((Object)"Method", (Object)request.getMethod());
        info.put((Object)"PathInfo", (Object)request.getPathInfo());
        info.put((Object)"PathTranslated", (Object)request.getPathTranslated());
        info.put((Object)"Protocol", (Object)request.getProtocol());
        info.put((Object)"ProtocolRequestId", (Object)request.getProtocolRequestId());
        info.put((Object)"QueryString", (Object)request.getQueryString());
        info.put((Object)"RemoteAddr", (Object)request.getRemoteAddr());
        info.put((Object)"RemoteHost", (Object)request.getRemoteHost());
        info.put((Object)"RemotePort", (Object)request.getRemotePort());
        info.put((Object)"RemoteUser", (Object)request.getRemoteUser());
        info.put((Object)"RequestId", (Object)request.getRequestId());
        info.put((Object)"RequestURI", (Object)request.getRequestURI());
        info.put((Object)"RequestedSessionId", (Object)request.getRequestedSessionId());
        info.put((Object)"Scheme", (Object)request.getScheme());
        info.put((Object)"ServletPath", (Object)request.getServletPath());
        Enumeration enHeaders = request.getHeaderNames();
        if (enHeaders != null) {
            MapStringObject headers = new MapStringObject();
            while (enHeaders.hasMoreElements()) {
                String name;
                Enumeration values = request.getHeaders(name = (String)enHeaders.nextElement());
                headers.put((Object)name, values != null ? Collections.list(values) : null);
            }
            info.put((Object)"Headers", (Object)headers);
        }
        if ((enParameters = request.getParameterNames()) != null) {
            MapStringObject parameters = new MapStringObject();
            while (enParameters.hasMoreElements()) {
                String name = (String)enParameters.nextElement();
                String[] values = request.getParameterValues(name);
                parameters.put((Object)name, (Object)values);
            }
            info.put((Object)"Parameters", (Object)parameters);
        }
        if ((rqCookies = request.getCookies()) != null) {
            ArrayList cookies = new ArrayList();
            for (Cookie rqCookie : rqCookies) {
                MapStringObject cookie = new MapStringObject();
                cookie.put((Object)"Domain", (Object)rqCookie.getDomain());
                cookie.put((Object)"MaxAge", (Object)rqCookie.getMaxAge());
                cookie.put((Object)"Name", (Object)rqCookie.getName());
                cookie.put((Object)"Path", (Object)rqCookie.getPath());
                cookie.put((Object)"Secure", (Object)rqCookie.getSecure());
                cookie.put((Object)"Value", (Object)rqCookie.getValue());
            }
            info.put((Object)"Cookies", cookies);
        }
        return this.sendResult(request, response, Result.success((Object)info));
    }

    private boolean login(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String username = request.getParameter("username");
        if (username == null || username.isEmpty()) {
            return this.sendResult(request, response, Result.error((String)"LOGIN-01", (String)"username is required"));
        }
        String password = request.getParameter("password");
        if (password == null || password.isEmpty()) {
            return this.sendResult(request, response, Result.error((String)"LOGIN-02", (String)"password is required"));
        }
        String authorization = UUID.randomUUID().toString();
        MapStringObject parameter = new MapStringObject();
        parameter.put((Object)"username", (Object)username);
        parameter.put((Object)"password", (Object)password);
        parameter.put((Object)"authorization", (Object)authorization);
        parameter.put((Object)"host", (Object)WebMvcUtil.getRemoteHost(request));
        parameter.put((Object)"agent", (Object)WebMvcUtil.getUserAgent(request));
        if (!this.credential.registerUser(parameter)) {
            return this.sendResult(request, response, Result.error((String)"LOGIN-03", (String)"Invalid user"));
        }
        return this.sendResult(request, response, Result.success((Object)authorization));
    }

    private boolean logout(MapStringObject parameter) throws Exception {
        this.credential.invalidate(parameter);
        return false;
    }

    private boolean notAuthorized(HttpServletResponse response) throws Exception {
        response.sendError(401);
        return false;
    }

    private boolean sendResult(HttpServletRequest request, HttpServletResponse response, Result result) throws Exception {
        WebMvcUtil.sendToClient(this.dataMapper, request, response, result);
        return false;
    }
}

