/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.RequestBody;
import org.springframework.http.HttpMethod;

public class ApiConsumerRequest {
    private String apiName;
    private String token;
    private RequestProxy proxy;
    private String url;
    private String path;
    private HttpMethod method;
    private RequestBody body;
    private String queryString;
    private Map<String, List<String>> queryParams;
    private Map<String, List<String>> headers;
    private Long connectTimeout;
    private Long callTimeout;
    private Long readTimeout;
    private Long writeTimeout;
    private Boolean followRedirect;
    private Boolean followSslRedirects;
    private SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private X509TrustManager x509TrustManager;

    public ApiConsumerRequest setApiName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    public ApiConsumerRequest setToken(String token) {
        this.token = token;
        return this;
    }

    public ApiConsumerRequest setProxy(RequestProxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public ApiConsumerRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public ApiConsumerRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public ApiConsumerRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public ApiConsumerRequest setBody(RequestBody body) {
        this.body = body;
        return this;
    }

    public ApiConsumerRequest setQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public ApiConsumerRequest setQueryParams(Map<String, List<String>> queryParams) {
        this.queryParams = queryParams;
        return this;
    }

    public ApiConsumerRequest setQueryParam(String name, List<String> values) {
        if (this.queryParams == null) {
            this.queryParams = new LinkedHashMap<String, List<String>>();
        }
        this.queryParams.put(name, values);
        return this;
    }

    public ApiConsumerRequest setQueryParam(String name, String value) {
        if (this.queryParams == null) {
            this.queryParams = new LinkedHashMap<String, List<String>>();
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.queryParams.put(name, values);
        return this;
    }

    public ApiConsumerRequest addQueryParam(String name, String value) {
        if (this.queryParams == null) {
            this.queryParams = new LinkedHashMap<String, List<String>>();
        }
        List values = this.queryParams.getOrDefault(name, new ArrayList());
        values.add(value);
        this.queryParams.put(name, values);
        return this;
    }

    public ApiConsumerRequest setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public ApiConsumerRequest setHeader(String name, List<String> values) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, List<String>>();
        }
        this.headers.put(name, values);
        return this;
    }

    public ApiConsumerRequest setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, List<String>>();
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name, values);
        return this;
    }

    public ApiConsumerRequest addHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, List<String>>();
        }
        List values = this.headers.getOrDefault(name, new ArrayList());
        values.add(value);
        this.headers.put(name, values);
        return this;
    }

    public ApiConsumerRequest setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ApiConsumerRequest setCallTimeout(Long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public ApiConsumerRequest setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public ApiConsumerRequest setWriteTimeout(Long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public ApiConsumerRequest setFollowRedirect(Boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    public ApiConsumerRequest setFollowSslRedirects(Boolean followSslRedirects) {
        this.followSslRedirects = followSslRedirects;
        return this;
    }

    public ApiConsumerRequest setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
        return this;
    }

    public ApiConsumerRequest setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public ApiConsumerRequest setX509TrustManager(X509TrustManager x509TrustManager) {
        this.x509TrustManager = x509TrustManager;
        return this;
    }

    public static ApiConsumerRequest create() {
        return new ApiConsumerRequest();
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getToken() {
        return this.token;
    }

    public RequestProxy getProxy() {
        return this.proxy;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public Long getCallTimeout() {
        return this.callTimeout;
    }

    public Long getReadTimeout() {
        return this.readTimeout;
    }

    public Long getWriteTimeout() {
        return this.writeTimeout;
    }

    public Boolean getFollowRedirect() {
        return this.followRedirect;
    }

    public Boolean getFollowSslRedirects() {
        return this.followSslRedirects;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public X509TrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }

    public static class RequestProxy {
        private Proxy.Type type;
        private String host;
        private Integer port;
        private String authorization;

        public RequestProxy setType(Proxy.Type type) {
            this.type = type;
            return this;
        }

        public RequestProxy setHost(String host) {
            this.host = host;
            return this;
        }

        public RequestProxy setPort(Integer port) {
            this.port = port;
            return this;
        }

        public RequestProxy setAuthorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        protected Proxy getProxy() {
            return new Proxy(this.type, new InetSocketAddress(this.host, (int)this.port));
        }

        public Proxy.Type getType() {
            return this.type;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getAuthorization() {
            return this.authorization;
        }
    }
}

