/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.util.FrameworkUtil;
import okhttp3.Response;

public class ApiConsumerResponse {
    private final Integer code;
    private final byte[] body;
    private final Map<String, List<String>> headers;

    ApiConsumerResponse(Response response) throws IOException {
        this.code = response.code();
        this.headers = response.headers().toMultimap();
        this.body = response.body().bytes();
    }

    public List<String> getHeaderValues(String name) {
        List<String> values = null;
        if (this.headers != null && (values = this.headers.get(name)) == null && (values = this.headers.get(name.toLowerCase())) == null) {
            values = this.headers.get(name.toUpperCase());
        }
        return values;
    }

    public String getHeaderValue(String name, String defaultValue) {
        List<String> values = this.getHeaderValues(name);
        return values != null && !values.isEmpty() ? values.get(0) : defaultValue;
    }

    public String getHeaderValue(String name) {
        return this.getHeaderValue(name, null);
    }

    public JsonNode getBodyAsJsonNode(DataMapper dataMapper) {
        return this.body != null && this.body.length != 0 ? dataMapper.read(this.body, JsonNode.class) : null;
    }

    public Result getBodyAsResult(DataMapper dataMapper, Class<?> dataType) {
        Result result = null;
        JsonNode node = this.getBodyAsJsonNode(dataMapper);
        if (node != null && node.has("status")) {
            JsonNode error = null;
            if (node.has("error") && !(error = node.get("error")).isArray()) {
                error = dataMapper.createArrayNode().add(error);
                ((ObjectNode)node).set("error", error);
            }
            result = dataMapper.copy((Object)node, Result.class).setData(null);
            if (node.has("data")) {
                Object data = dataMapper.copy((Object)node.get("data"), dataType);
                result.setData(data);
            }
        }
        return result;
    }

    public Result getBodyAsResult(DataMapper dataMapper, TypeReference<?> dataTypeRef) {
        Result result = null;
        JsonNode node = this.getBodyAsJsonNode(dataMapper);
        if (node != null && node.has("status")) {
            JsonNode error = null;
            if (node.has("error") && !(error = node.get("error")).isArray()) {
                error = dataMapper.createArrayNode().add(error);
                ((ObjectNode)node).set("error", error);
            }
            result = dataMapper.copy((Object)node, Result.class).setData(null);
            if (node.has("data")) {
                Object data = dataMapper.copy((Object)node.get("data"), dataTypeRef);
                result.setData(data);
            }
        }
        return result;
    }

    public <T> T getBodyAsData(DataMapper dataMapper, Class<T> type) {
        Result result = this.getBodyAsResult(dataMapper, type);
        if (result != null) {
            if (1 == result.getStatus()) {
                throw FrameworkUtil.exception(result);
            }
            return (T)result.getData();
        }
        return null;
    }

    public <T> T getBodyAsData(DataMapper dataMapper, TypeReference<T> typeRef) {
        Result result = this.getBodyAsResult(dataMapper, typeRef);
        if (result != null) {
            if (1 == result.getStatus()) {
                throw FrameworkUtil.exception(result);
            }
            return (T)result.getData();
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public byte[] getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    private static class ResultField {
        private static final String STATUS = "status";
        private static final String ERROR = "error";
        private static final String DATA = "data";

        private ResultField() {
        }
    }
}

