/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.api.ApiConsumerRequest;
import net.ideahut.springboot.api.ApiConsumerResponse;
import net.ideahut.springboot.api.ApiConsumerService;
import net.ideahut.springboot.api.ApiHeader;
import net.ideahut.springboot.api.ApiHelper;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.TimeUtil;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public class ApiConsumerServiceImpl
implements ApiConsumerService,
InitializingBean {
    private DataMapper dataMapper;
    private ApiService apiService;

    public ApiConsumerServiceImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public ApiConsumerServiceImpl setApiService(ApiService apiService) {
        this.apiService = apiService;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.apiService, (String)"apiService is required");
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
    }

    @Override
    public String token(String apiName) {
        ApiSource apiSource = this.getApiSource(apiName);
        String tokenUrl = FrameworkUtil.getOrDefault(apiSource.getConsumerUrl(), "").trim();
        ApiHelper.throwIfTrue(tokenUrl.isEmpty(), ApiHelper.Error.TOKEN_URL_REQUIRED);
        ApiConsumerRequest request = ApiConsumerRequest.create().setUrl(tokenUrl).setApiName(apiSource.getApiName());
        ApiConsumerResponse response = this.call(request);
        ApiHelper.throwIfTrue(200 != response.getCode(), Message.of((String)("HTTP-" + response.getCode()), (String)new String(response.getBody())));
        return response.getBodyAsData(this.dataMapper, String.class);
    }

    @Override
    public ApiConsumerResponse call(ApiConsumerRequest input) {
        ApiSource apiSource = this.getApiSource(input.getApiName());
        Response response = null;
        try {
            Request request = this.getRequest(apiSource, input);
            OkHttpClient client = this.getClient(input, request.url().isHttps());
            Call call = client.newCall(request);
            response = call.execute();
            ApiConsumerResponse apiConsumerResponse = new ApiConsumerResponse(response);
            this.close(response);
            return apiConsumerResponse;
        }
        catch (Exception e) {
            try {
                throw FrameworkUtil.exception(e);
            }
            catch (Throwable throwable) {
                this.close(response);
                throw throwable;
            }
        }
    }

    private void close(Response response) {
        if (response != null) {
            try {
                response.body().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ApiSource getApiSource(String apiName) {
        ApiHelper.throwIfTrue(apiName == null || apiName.isEmpty(), ApiHelper.Error.NAME_NOT_VALID);
        ApiSource apiSource = this.apiService.getApiSource(apiName);
        ApiHelper.throwIfTrue(apiSource == null, ApiHelper.Error.SOURCE_NOT_FOUND);
        return apiSource;
    }

    private OkHttpClient getClient(ApiConsumerRequest request, boolean isHttps) {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        final ApiConsumerRequest.RequestProxy proxy = request.getProxy();
        if (proxy != null) {
            builder.proxy(proxy.getProxy());
            if (proxy.getAuthorization() != null) {
                builder.authenticator(new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        return response.request().newBuilder().header("Proxy-Authorization", proxy.getAuthorization()).build();
                    }
                });
            }
        }
        this.prepareTimeout(builder, request);
        if (isHttps) {
            this.prepareHttps(builder, request);
        } else {
            this.prepareHttp(builder, request);
        }
        return builder.build();
    }

    private void prepareTimeout(OkHttpClient.Builder builder, ApiConsumerRequest request) {
        if (request.getConnectTimeout() != null) {
            builder.connectTimeout(request.getConnectTimeout().longValue(), TimeUnit.SECONDS);
        }
        if (request.getCallTimeout() != null) {
            builder.callTimeout(request.getCallTimeout().longValue(), TimeUnit.SECONDS);
        }
        if (request.getReadTimeout() != null) {
            builder.readTimeout(request.getReadTimeout().longValue(), TimeUnit.SECONDS);
        }
        if (request.getWriteTimeout() != null) {
            builder.writeTimeout(request.getWriteTimeout().longValue(), TimeUnit.SECONDS);
        }
    }

    private void prepareHttp(OkHttpClient.Builder builder, ApiConsumerRequest request) {
        if (request.getFollowRedirect() != null) {
            builder.followRedirects(request.getFollowRedirect().booleanValue());
        }
        if (request.getSocketFactory() != null) {
            builder.socketFactory(request.getSocketFactory());
        }
    }

    private void prepareHttps(OkHttpClient.Builder builder, ApiConsumerRequest request) {
        if (request.getFollowSslRedirects() != null) {
            builder.followSslRedirects(request.getFollowSslRedirects().booleanValue());
        }
        if (request.getSslSocketFactory() != null) {
            builder.sslSocketFactory(request.getSslSocketFactory(), request.getX509TrustManager());
        }
    }

    private void prepareUrl(Request.Builder builder, ApiSource apiSource, ApiConsumerRequest input) {
        String queryString;
        Map<String, List<String>> queryParams;
        Object url = input.getUrl();
        if (url == null) {
            url = apiSource.getBaseUrl() + input.getPath();
        }
        if ((queryParams = input.getQueryParams()) != null) {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
            for (Map.Entry<String, List<String>> entry : queryParams.entrySet()) {
                for (String value : entry.getValue()) {
                    urlBuilder.addQueryParameter(entry.getKey(), value);
                }
            }
            url = urlBuilder.build().toString();
        }
        if ((queryString = input.getQueryString()) != null && !queryString.isEmpty()) {
            url = (String)url + (((String)url).indexOf("?") == -1 ? "?" : "&") + queryString;
        }
        builder.url((String)url);
    }

    private void prepareHeader(Request.Builder builder, ApiConsumerRequest input) {
        Map<String, List<String>> headers = input.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String value : entry.getValue()) {
                    builder.addHeader(entry.getKey(), value);
                }
            }
        }
    }

    private Request getRequest(ApiSource apiSource, ApiConsumerRequest input) {
        String token;
        if (input.getMethod() == null) {
            input.setMethod(HttpMethod.GET);
        }
        Request.Builder builder = new Request.Builder();
        this.prepareUrl(builder, apiSource, input);
        this.prepareHeader(builder, input);
        ApiHeader apiHeader = this.apiService.getApiHeader();
        builder.method(input.getMethod().name(), input.getBody()).header(apiHeader.getFromHeader(), this.apiService.getApiName());
        String string = token = input.getToken() != null ? input.getToken() : "";
        if (!token.isEmpty()) {
            builder.header(apiHeader.getTokenHeader(), token);
        } else {
            String secret = FrameworkUtil.getOrDefault(apiSource.getSecret(), "");
            ApiHelper.throwIfTrue(secret.isEmpty(), ApiHelper.Error.TOKEN_SECRET_REQUIRED);
            String digest = ApiHelper.fixDigest(apiSource.getDigest(), this.apiService.getDefaultDigest());
            String timestamp = "" + TimeUtil.currentEpochMillis();
            String signature = FrameworkUtil.digest(digest, secret + timestamp);
            builder.header(apiHeader.getSignatureHeader(), signature).header(apiHeader.getTimestampHeader(), timestamp);
        }
        return builder.build();
    }
}

