/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.api.ApiHandler2;
import net.ideahut.springboot.api.ApiHandler3;
import net.ideahut.springboot.api.ApiHandlerImpl;
import net.ideahut.springboot.api.ApiHelper;
import net.ideahut.springboot.api.dto.ApiCrudDto;
import net.ideahut.springboot.api.dto.ApiCrudFieldDto;
import net.ideahut.springboot.api.dto.ApiItemCrudDto;
import net.ideahut.springboot.api.dto.ApiItemRequestDto;
import net.ideahut.springboot.api.dto.ApiProviderConfigDto;
import net.ideahut.springboot.api.dto.ApiProviderCrudActionDto;
import net.ideahut.springboot.api.dto.ApiProviderCrudDto;
import net.ideahut.springboot.api.dto.ApiProviderDto;
import net.ideahut.springboot.api.dto.ApiProviderHostDto;
import net.ideahut.springboot.api.dto.ApiProviderRequestDto;
import net.ideahut.springboot.api.dto.ApiProviderRoleDto;
import net.ideahut.springboot.api.dto.ApiRoleCrudActionDto;
import net.ideahut.springboot.api.dto.ApiRoleCrudDto;
import net.ideahut.springboot.api.dto.ApiRoleCrudFilterDto;
import net.ideahut.springboot.api.dto.ApiRoleDto;
import net.ideahut.springboot.api.dto.ApiRoleRequestDto;
import net.ideahut.springboot.api.entity.ApiCrud;
import net.ideahut.springboot.api.entity.ApiCrudField;
import net.ideahut.springboot.api.entity.ApiItemCrud;
import net.ideahut.springboot.api.entity.ApiItemRequest;
import net.ideahut.springboot.api.entity.ApiProvider;
import net.ideahut.springboot.api.entity.ApiProviderConfig;
import net.ideahut.springboot.api.entity.ApiProviderCrud;
import net.ideahut.springboot.api.entity.ApiProviderCrudAction;
import net.ideahut.springboot.api.entity.ApiProviderHost;
import net.ideahut.springboot.api.entity.ApiProviderRequest;
import net.ideahut.springboot.api.entity.ApiProviderRole;
import net.ideahut.springboot.api.entity.ApiRole;
import net.ideahut.springboot.api.entity.ApiRoleCrud;
import net.ideahut.springboot.api.entity.ApiRoleCrudAction;
import net.ideahut.springboot.api.entity.ApiRoleCrudFilter;
import net.ideahut.springboot.api.entity.ApiRoleRequest;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.entity.EntityInfo;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.support.CompareDtoAndEnt;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;
import org.springframework.web.method.HandlerMethod;

final class ApiHandler0 {
    private ApiHandler0() {
    }

    private static void setCache(ApiHandlerImpl handler, String vkey, Object object) {
        ValueOperations valops = handler.redisTemplate.opsForValue();
        if (object != null) {
            byte[] value = handler.dataMapper.writeAsBytes(object, 1);
            valops.set((Object)vkey, (Object)value);
            byte[] bkey = vkey.getBytes();
            String lkey = Keys.keys(handler);
            ListOperations lisops = handler.redisTemplate.opsForList();
            lisops.remove((Object)lkey, 1L, (Object)bkey);
            lisops.rightPush((Object)lkey, (Object)bkey);
        } else {
            valops.set((Object)vkey, (Object)ApiHelper.NULL, (long)handler.nullExpiry.intValue(), TimeUnit.SECONDS);
        }
    }

    private static void delCache(ApiHandlerImpl handler, String vkey) {
        byte[] bkey = vkey.getBytes();
        String lkey = Keys.keys(handler);
        ListOperations lisops = handler.redisTemplate.opsForList();
        lisops.remove((Object)lkey, 1L, (Object)bkey);
        handler.redisTemplate.delete((Object)vkey);
    }

    static synchronized boolean lock(ApiHandlerImpl handler) {
        String key = Keys.lock(handler);
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] bytes = (byte[])valops.get((Object)key);
        if (bytes != null) {
            return false;
        }
        valops.set((Object)key, (Object)"1".getBytes());
        return true;
    }

    static void unlock(ApiHandlerImpl handler) {
        String key = Keys.lock(handler);
        handler.redisTemplate.delete((Object)key);
    }

    static void clear(ApiHandlerImpl handler) {
        List allkeys;
        String lkey = Keys.keys(handler);
        ListOperations lisops = handler.redisTemplate.opsForList();
        Long size = lisops.size((Object)lkey);
        if (size != null && size > 0L && (allkeys = lisops.leftPop((Object)lkey, size.longValue())) != null && !allkeys.isEmpty()) {
            HashSet<String> keysForValue = new HashSet<String>();
            while (!allkeys.isEmpty()) {
                keysForValue.add(new String((byte[])allkeys.remove(0)));
            }
            handler.redisTemplate.delete(keysForValue);
        }
    }

    private static void compareCheck(Class<?> dtoClass, TrxManagerInfo trxManagerInfo, Class<?> entClass) {
        Assert.notNull((Object)trxManagerInfo.getEntityInfo(entClass), (String)("Entity class '" + entClass.getName() + "' is not found in TrxManager: " + trxManagerInfo.getName()));
        CompareDtoAndEnt.check(dtoClass, entClass);
    }

    static void fixEntityClass(ApiHandlerImpl handler) {
        String trxManagerName;
        ApiHandlerImpl.EntityClass entityClass = FrameworkUtil.getOrDefault(handler.entityClass, new ApiHandlerImpl.EntityClass());
        entityClass.setApiRole(FrameworkUtil.getOrDefault(entityClass.getApiRole(), ApiRole.class));
        entityClass.setApiProvider(FrameworkUtil.getOrDefault(entityClass.getApiProvider(), ApiProvider.class));
        entityClass.setApiProviderConfig(FrameworkUtil.getOrDefault(entityClass.getApiProviderConfig(), ApiProviderConfig.class));
        entityClass.setApiProviderHost(FrameworkUtil.getOrDefault(entityClass.getApiProviderHost(), ApiProviderHost.class));
        entityClass.setApiProviderRole(FrameworkUtil.getOrDefault(entityClass.getApiProviderRole(), ApiProviderRole.class));
        entityClass.setApiItemRequest(FrameworkUtil.getOrDefault(entityClass.getApiItemRequest(), ApiItemRequest.class));
        entityClass.setApiRoleRequest(FrameworkUtil.getOrDefault(entityClass.getApiRoleRequest(), ApiRoleRequest.class));
        if (Boolean.TRUE.equals(handler.enableCrud)) {
            entityClass.setApiCrud(FrameworkUtil.getOrDefault(entityClass.getApiCrud(), ApiCrud.class));
            entityClass.setApiCrudField(FrameworkUtil.getOrDefault(entityClass.getApiCrudField(), ApiCrudField.class));
            entityClass.setApiItemCrud(FrameworkUtil.getOrDefault(entityClass.getApiItemCrud(), ApiItemCrud.class));
            entityClass.setApiRoleCrud(FrameworkUtil.getOrDefault(entityClass.getApiRoleCrud(), ApiRoleCrud.class));
            entityClass.setApiRoleCrudAction(FrameworkUtil.getOrDefault(entityClass.getApiRoleCrudAction(), ApiRoleCrudAction.class));
            entityClass.setApiRoleCrudFilter(FrameworkUtil.getOrDefault(entityClass.getApiRoleCrudFilter(), ApiRoleCrudFilter.class));
        }
        if (Boolean.TRUE.equals(handler.enableConsumer)) {
            entityClass.setApiProviderCrud(FrameworkUtil.getOrDefault(entityClass.getApiProviderCrud(), ApiProviderCrud.class));
            entityClass.setApiProviderCrudAction(FrameworkUtil.getOrDefault(entityClass.getApiProviderCrudAction(), ApiProviderCrudAction.class));
            entityClass.setApiProviderRequest(FrameworkUtil.getOrDefault(entityClass.getApiProviderRequest(), ApiProviderRequest.class));
        }
        trxManagerName = (trxManagerName = entityClass.getTrxManagerName()) != null ? trxManagerName.trim() : "";
        entityClass.setTrxManagerName(trxManagerName);
        String fieldNameForCrudRole = entityClass.getFieldNameForCrudRole();
        String string = fieldNameForCrudRole = fieldNameForCrudRole != null ? fieldNameForCrudRole.trim() : "";
        if (fieldNameForCrudRole.isEmpty()) {
            fieldNameForCrudRole = "apiCrudRole";
        }
        entityClass.setFieldNameForCrudRole(fieldNameForCrudRole);
        handler.entityClass = entityClass;
    }

    static void checkEntityClass(ApiHandlerImpl handler) {
        TrxManagerInfo trxManagerInfo = handler.trxManagerInfo;
        ApiHandlerImpl.EntityClass entityClass = handler.entityClass;
        ApiHandler0.compareCheck(ApiRoleDto.class, trxManagerInfo, entityClass.getApiRole());
        ApiHandler0.compareCheck(ApiProviderDto.class, trxManagerInfo, entityClass.getApiProvider());
        ApiHandler0.compareCheck(ApiProviderConfigDto.class, trxManagerInfo, entityClass.getApiProviderConfig());
        ApiHandler0.compareCheck(ApiProviderHostDto.class, trxManagerInfo, entityClass.getApiProviderHost());
        ApiHandler0.compareCheck(ApiProviderRoleDto.class, trxManagerInfo, entityClass.getApiProviderRole());
        ApiHandler0.compareCheck(ApiItemRequestDto.class, trxManagerInfo, entityClass.getApiItemRequest());
        ApiHandler0.compareCheck(ApiRoleRequestDto.class, trxManagerInfo, entityClass.getApiRoleRequest());
        if (Boolean.TRUE.equals(handler.enableCrud)) {
            ApiHandler0.compareCheck(ApiCrudDto.class, trxManagerInfo, entityClass.getApiCrud());
            ApiHandler0.compareCheck(ApiCrudFieldDto.class, trxManagerInfo, entityClass.getApiCrudField());
            ApiHandler0.compareCheck(ApiItemCrudDto.class, trxManagerInfo, entityClass.getApiItemCrud());
            ApiHandler0.compareCheck(ApiRoleCrudDto.class, trxManagerInfo, entityClass.getApiRoleCrud());
            ApiHandler0.compareCheck(ApiRoleCrudActionDto.class, trxManagerInfo, entityClass.getApiRoleCrudAction());
            ApiHandler0.compareCheck(ApiRoleCrudFilterDto.class, trxManagerInfo, entityClass.getApiRoleCrudFilter());
        }
        if (Boolean.TRUE.equals(handler.enableConsumer)) {
            ApiHandler0.compareCheck(ApiProviderCrudDto.class, trxManagerInfo, entityClass.getApiProviderCrud());
            ApiHandler0.compareCheck(ApiProviderCrudActionDto.class, trxManagerInfo, entityClass.getApiProviderCrudAction());
            ApiHandler0.compareCheck(ApiProviderRequestDto.class, trxManagerInfo, entityClass.getApiProviderRequest());
        }
    }

    static ApiProviderDto getApiProvider(ApiHandlerImpl handler, String apiName) {
        String ckey = Keys.provider(handler, apiName);
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] bytes = (byte[])valops.get((Object)ckey);
        if (bytes != null) {
            return ApiHelper.valueOf(handler.dataMapper, bytes, ApiProviderDto.class);
        }
        ApiProviderDto dto = ApiHandler2.getApiProviderFromDb(handler, apiName);
        ApiHandler0.setCache(handler, ckey, dto);
        return dto;
    }

    static void removeApiProvider(ApiHandlerImpl handler, String apiName) {
        String ckey = Keys.provider(handler, apiName);
        ApiHandler0.delCache(handler, ckey);
    }

    static CrudProperties getCrudProperties(ApiHandlerImpl handler, ApiRoleCrudDto apiCrudRoleDto) {
        String ckey = Keys.crudRole(handler, apiCrudRoleDto);
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] bytes = (byte[])valops.get((Object)ckey);
        if (bytes != null) {
            CrudProperties properties = ApiHelper.valueOf(handler.dataMapper, bytes, CrudProperties.class);
            ApiHandler0.fixCrudProperties(handler, properties);
            return properties;
        }
        CrudProperties properties = ApiHandler3.getCrudPropertiesByApiRole(handler, apiCrudRoleDto);
        ApiHandler0.setCache(handler, ckey, properties);
        ApiHandler0.fixCrudProperties(handler, properties);
        return properties;
    }

    static CrudProperties getCrudProperties(ApiHandlerImpl handler, ApiProviderCrudDto apiProviderCrudDto) {
        String ckey = Keys.crudProvider(handler, apiProviderCrudDto);
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] bytes = (byte[])valops.get((Object)ckey);
        if (bytes != null) {
            CrudProperties properties = ApiHelper.valueOf(handler.dataMapper, bytes, CrudProperties.class);
            ApiHandler0.fixCrudProperties(handler, properties);
            return properties;
        }
        CrudProperties properties = ApiHandler3.getCrudPropertiesByApiName(handler, apiProviderCrudDto);
        ApiHandler0.setCache(handler, ckey, properties);
        ApiHandler0.fixCrudProperties(handler, properties);
        return properties;
    }

    private static void fixCrudProperties(ApiHandlerImpl handler, CrudProperties properties) {
        if (properties != null) {
            String manager;
            TrxManagerInfo trxManagerInfo = handler.entityTrxManager.getDefaultTrxManagerInfo();
            String string = manager = properties.getManagerName() != null ? properties.getManagerName().trim() : "";
            if (!manager.isEmpty()) {
                trxManagerInfo = handler.entityTrxManager.getTrxManagerInfo(manager);
                Assert.notNull((Object)trxManagerInfo, (String)("CRUD Manager is not found, for: " + manager));
            }
            Class clazz = FrameworkUtil.classOf(properties.getClassName());
            EntityInfo entityInfo = trxManagerInfo.getEntityInfo(clazz);
            properties.setEntityInfo(entityInfo);
        }
    }

    static void removeApiCrud(ApiHandlerImpl handler, ApiRoleCrudDto apiRoleCrudDto) {
        String ckey = Keys.crudRole(handler, apiRoleCrudDto);
        ApiHandler0.delCache(handler, ckey);
    }

    static void removeApiCrud(ApiHandlerImpl handler, ApiProviderCrudDto apiProviderCrudDto) {
        String ckey = Keys.crudProvider(handler, apiProviderCrudDto);
        ApiHandler0.delCache(handler, ckey);
    }

    static void removeApiRequest(ApiHandlerImpl handler, ApiRoleRequestDto apiRoleRequestDto) {
        String ckey = Keys.requestRole(handler, apiRoleRequestDto);
        ApiHandler0.delCache(handler, ckey);
    }

    static void removeApiRequest(ApiHandlerImpl handler, ApiProviderRequestDto apiProviderRequestDto) {
        String ckey = Keys.requestProvider(handler, apiProviderRequestDto);
        ApiHandler0.delCache(handler, ckey);
    }

    static ApiRoleRequestDto getApiRoleRequest(final ApiHandlerImpl handler, String apiRoleCode, HandlerMethod handlerMethod) {
        String packageName = "";
        String className = handlerMethod.getBeanType().getName();
        int idx = className.lastIndexOf(".");
        if (idx != -1) {
            packageName = className.substring(0, idx);
            className = className.substring(idx + 1);
        }
        Method method = handlerMethod.getMethod();
        final ApiRoleRequestDto dto = new ApiRoleRequestDto().setApiRoleCode(apiRoleCode).setClassName(className).setFunctionName(method.getName()).setPackageName(packageName).setParameterCount(Integer.valueOf(method.getParameterCount()));
        String ckey = Keys.requestRole(handler, dto);
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] value = (byte[])valops.get((Object)ckey);
        if (value != null) {
            return ApiHelper.valueOf(handler.dataMapper, value, ApiRoleRequestDto.class);
        }
        ApiRoleRequestDto apiRequestRoleDto = handler.trxManagerInfo.transaction(new SessionCallable<ApiRoleRequestDto>(){

            @Override
            public ApiRoleRequestDto call(Session session) throws Exception {
                Object id = handler.dataMapper.copy((Object)dto, handler.entityClass.getApiRoleRequest());
                Object entity = session.get(handler.entityClass.getApiRoleRequest(), id);
                handler.trxManagerInfo.loadLazy(entity, handler.entityClass.getApiRoleRequest());
                return entity != null ? handler.dataMapper.copy(entity, ApiRoleRequestDto.class) : null;
            }
        });
        ApiHandler0.setCache(handler, ckey, apiRequestRoleDto);
        return apiRequestRoleDto;
    }

    static ApiProviderRequestDto getApiProviderRequest(final ApiHandlerImpl handler, String apiName, HandlerMethod handlerMethod) {
        String packageName = "";
        String className = handlerMethod.getBeanType().getName();
        int idx = className.lastIndexOf(".");
        if (idx != -1) {
            packageName = className.substring(0, idx);
            className = className.substring(idx + 1);
        }
        Method method = handlerMethod.getMethod();
        final ApiProviderRequestDto dto = ApiProviderRequestDto.create().setApiName(apiName).setClassName(className).setFunctionName(method.getName()).setPackageName(packageName).setParameterCount(Integer.valueOf(method.getParameterCount()));
        String vkey = Keys.requestProvider(handler, dto);
        ValueOperations valops = handler.redisTemplate.opsForValue();
        byte[] value = (byte[])valops.get((Object)vkey);
        if (value != null) {
            return ApiHelper.valueOf(handler.dataMapper, value, ApiProviderRequestDto.class);
        }
        ApiProviderRequestDto apiProviderRequestDto = handler.trxManagerInfo.transaction(new SessionCallable<ApiProviderRequestDto>(){

            @Override
            public ApiProviderRequestDto call(Session session) throws Exception {
                Object id = handler.dataMapper.copy((Object)dto, handler.entityClass.getApiProviderRequest());
                Object entity = session.get(handler.entityClass.getApiProviderRequest(), id);
                handler.trxManagerInfo.loadLazy(entity, handler.entityClass.getApiProviderRequest());
                return entity != null ? handler.dataMapper.copy(entity, ApiProviderRequestDto.class) : null;
            }
        });
        ApiHandler0.setCache(handler, vkey, apiProviderRequestDto);
        return apiProviderRequestDto;
    }

    private static final class Keys {
        private Keys() {
        }

        static String lock(ApiHandlerImpl handler) {
            return handler.redisPrefix + "--LOCK--";
        }

        static String keys(ApiHandlerImpl handler) {
            return handler.redisPrefix + "--KEYS--";
        }

        static String provider(ApiHandlerImpl handler, String apiName) {
            return handler.redisPrefix + "--PROVIDER--" + apiName;
        }

        static String crudRole(ApiHandlerImpl handler, ApiRoleCrudDto apiRoleCrudDto) {
            return handler.redisPrefix + "--CRUD-ROLE--" + apiRoleCrudDto.getApiRoleCode() + "|" + apiRoleCrudDto.getApiCrudCode();
        }

        static String requestRole(ApiHandlerImpl handler, ApiRoleRequestDto apiRoleRequestDto) {
            return handler.redisPrefix + "--REQUEST-ROLE--" + apiRoleRequestDto.getApiRoleCode() + "|" + apiRoleRequestDto.getPackageName() + "|" + apiRoleRequestDto.getClassName() + "|" + apiRoleRequestDto.getFunctionName() + "|" + apiRoleRequestDto.getParameterCount();
        }

        static String crudProvider(ApiHandlerImpl handler, ApiProviderCrudDto apiProviderCrudDto) {
            return handler.redisPrefix + "--CRUD-PROVIDER--" + apiProviderCrudDto.getApiName() + "|" + apiProviderCrudDto.getApiCrudCode();
        }

        static String requestProvider(ApiHandlerImpl handler, ApiProviderRequestDto apiProviderRequestDto) {
            return handler.redisPrefix + "--REQUEST-PROVIDER--" + apiProviderRequestDto.getApiName() + "|" + apiProviderRequestDto.getPackageName() + "|" + apiProviderRequestDto.getClassName() + "|" + apiProviderRequestDto.getFunctionName() + "|" + apiProviderRequestDto.getParameterCount();
        }
    }
}

