/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import net.ideahut.springboot.annotation.ApiExclude;
import net.ideahut.springboot.api.ApiHandlerImpl;
import net.ideahut.springboot.api.dto.ApiItemCrudDto;
import net.ideahut.springboot.api.dto.ApiItemRequestDto;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.object.MethodInfo;
import net.ideahut.springboot.object.RequestInfo;
import net.ideahut.springboot.task.TaskListExecutor;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;

final class ApiHandler1 {
    private static final String DELETE_FROM = "delete from ";

    private ApiHandler1() {
    }

    private static void flushAndClear(Session session) {
        session.flush();
        session.clear();
    }

    static void deleteItemCrud(final ApiHandlerImpl handler) throws Exception {
        handler.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

            @Override
            public Void call(Session session) throws Exception {
                session.createQuery(ApiHandler1.DELETE_FROM + handler.entityClass.getApiItemCrud().getName(), null).executeUpdate();
                return null;
            }
        });
    }

    private static void saveItemCrud(ApiHandlerImpl handler, TrxManagerInfo trxManagerInfo, String manager, Session session) throws Exception {
        int i = 0;
        for (Class<?> clazz : trxManagerInfo.getEntityClasses()) {
            ApiExclude apiExclude = clazz.getAnnotation(ApiExclude.class);
            if (apiExclude != null && apiExclude.value()) continue;
            ApiItemCrudDto dto = ApiItemCrudDto.create().setClassName(clazz.getSimpleName()).setManager(manager).setPackageName(clazz.getPackageName());
            Object entity = handler.dataMapper.copy((Object)dto, handler.entityClass.getApiItemCrud());
            session.persist(entity);
            if (++i < 50) continue;
            ApiHandler1.flushAndClear(session);
            i = 0;
        }
        if (i != 0) {
            ApiHandler1.flushAndClear(session);
        }
    }

    static void saveItemCrud(final ApiHandlerImpl handler, TaskListExecutor executor) throws Exception {
        String defaultManagerName = handler.entityTrxManager.getDefaultTrxManagerInfo().getName();
        for (final TrxManagerInfo trxManagerInfo : handler.entityTrxManager.getTrxManagerInfos()) {
            final String manager = !defaultManagerName.equals(trxManagerInfo.getName()) ? trxManagerInfo.getName() : "";
            executor.add((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    return handler.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

                        @Override
                        public Void call(Session session) throws Exception {
                            ApiHandler1.saveItemCrud(handler, trxManagerInfo, manager, session);
                            return null;
                        }
                    });
                }
            });
        }
    }

    static void deleteItemRequest(final ApiHandlerImpl handler) throws Exception {
        handler.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

            @Override
            public Void call(Session session) throws Exception {
                session.createQuery(ApiHandler1.DELETE_FROM + handler.entityClass.getApiItemRequest().getName(), null).executeUpdate();
                return null;
            }
        });
    }

    private static void saveItemRequest(ApiHandlerImpl handler, List<RequestInfo> requestInfos, Session session) throws Exception {
        int i = 0;
        for (RequestInfo requestInfo : requestInfos) {
            String patterns;
            if (requestInfo.isPublic() || requestInfo.isExclude()) continue;
            RequestInfo.Handler rhandler = requestInfo.getHandler();
            MethodInfo method = rhandler.getMethod();
            String packageName = "";
            String className = rhandler.getBean();
            int idx = className.lastIndexOf(".");
            if (idx != -1) {
                packageName = className.substring(0, idx);
                className = className.substring(idx + 1);
            }
            if ((patterns = StringUtils.join(requestInfo.getPatternValues(), (String)",")).length() > 1024) {
                patterns = patterns.substring(0, 1024);
            }
            String methods = StringUtils.join(requestInfo.getMethods(), (String)",");
            String consumes = StringUtils.join(requestInfo.getConsumableMediaTypes(), (String)",");
            String produces = StringUtils.join(requestInfo.getProducibleMediaTypes(), (String)",");
            ApiItemRequestDto dto = new ApiItemRequestDto().setClassName(className).setConsumes(consumes).setFunctionName(method.getName()).setMethods(methods).setPackageName(packageName).setParameterCount(Integer.valueOf(method.getParameterCount())).setPatterns(patterns).setProduces(produces);
            Object entity = handler.dataMapper.copy((Object)dto, handler.entityClass.getApiItemRequest());
            session.persist(entity);
            if (++i < 50) continue;
            ApiHandler1.flushAndClear(session);
            i = 0;
        }
        if (i != 0) {
            ApiHandler1.flushAndClear(session);
        }
    }

    static void saveItemRequest(final ApiHandlerImpl handler, TaskListExecutor executor, final List<RequestInfo> requestInfos) throws Exception {
        executor.add((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return handler.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

                    @Override
                    public Void call(Session session) throws Exception {
                        ApiHandler1.saveItemRequest(handler, requestInfos, session);
                        return null;
                    }
                });
            }
        });
    }

    static void syncEntities(final ApiHandlerImpl handler, final boolean isCrudEnabled) {
        handler.trxManagerInfo.transaction(true, new SessionCallable<Void>(){

            @Override
            public Void call(Session session) throws Exception {
                Long records;
                Object count;
                if (isCrudEnabled) {
                    count = session.createQuery("select count(1) from " + handler.entityClass.getApiItemCrud().getName(), Object.class).uniqueResult();
                    records = Long.parseLong("" + count);
                    if (records > 0L) {
                        session.createQuery(ApiHandler1.DELETE_FROM + handler.entityClass.getApiCrud().getName() + " where (manager, packageName, className) not in (select manager, packageName, className from " + handler.entityClass.getApiItemCrud().getName() + ")", null).executeUpdate();
                    }
                    HashSet<String> actions = new HashSet<String>();
                    for (CrudAction action : CrudAction.values()) {
                        actions.add(action.name());
                    }
                    session.createQuery(ApiHandler1.DELETE_FROM + handler.entityClass.getApiRoleCrudAction().getName() + " where action not in (?1)", null).setParameter(1, actions).executeUpdate();
                }
                if ((records = Long.valueOf(Long.parseLong("" + (count = session.createQuery("select count(1) from " + handler.entityClass.getApiItemRequest().getName(), Object.class).uniqueResult())))) > 0L) {
                    session.createQuery(ApiHandler1.DELETE_FROM + handler.entityClass.getApiRoleRequest().getName() + " where (packageName, className, functionName, parameterCount) not in (select packageName, className, functionName, parameterCount from " + handler.entityClass.getApiItemRequest().getName() + ")", null).executeUpdate();
                }
                return null;
            }
        });
    }
}

