/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.ideahut.springboot.api.ApiHandlerImpl;
import net.ideahut.springboot.api.dto.ApiProviderDto;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.object.StringMap;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;

final class ApiHandler2 {
    private ApiHandler2() {
    }

    static ApiProviderDto getApiProviderFromDb(ApiHandlerImpl handler, String apiName) {
        Future<ApiProviderDto> futureProvider = ApiHandler2.futureApiProvider(handler, apiName);
        Future<Set<String>> futureHost = ApiHandler2.futureApiProviderHost(handler, apiName);
        Future<StringMap> futureConfig = ApiHandler2.futureApiProviderConfig(handler, apiName);
        Future<StringMap> futureRole = ApiHandler2.futureApiProviderRole(handler, apiName);
        try {
            ApiProviderDto provider = futureProvider.get();
            Set<String> hosts = futureHost.get();
            StringMap config = futureConfig.get();
            StringMap role = futureRole.get();
            if (provider != null) {
                provider.getHosts().addAll(hosts);
                provider.getConfig().putAll((Map)config);
                provider.getRole().putAll((Map)role);
            }
            return provider;
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    private static Future<ApiProviderDto> futureApiProvider(final ApiHandlerImpl handler, final String apiName) {
        return handler.taskHandler.submit((Callable)new Callable<ApiProviderDto>(){

            @Override
            public ApiProviderDto call() throws Exception {
                Object entity = handler.trxManagerInfo.transaction(new SessionCallable<Object>(){

                    @Override
                    public Object call(Session session) throws Exception {
                        Object entity = session.get(handler.entityClass.getApiProvider(), (Object)apiName);
                        handler.trxManagerInfo.loadLazy(entity, handler.entityClass.getApiProvider());
                        return entity;
                    }
                });
                if (entity != null) {
                    ApiProviderDto dto = handler.dataMapper.copy(entity, ApiProviderDto.class);
                    return FrameworkUtil.isTrue(dto.getIsActive()) ? dto.setHosts(new HashSet()).setConfig(new StringMap()).setRole(new StringMap()) : null;
                }
                return null;
            }
        });
    }

    private static Future<Set<String>> futureApiProviderHost(final ApiHandlerImpl handler, final String apiName) {
        return handler.taskHandler.submit((Callable)new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                return handler.trxManagerInfo.transaction(new SessionCallable<Set<String>>(){

                    @Override
                    public Set<String> call(Session session) throws Exception {
                        List hosts = session.createQuery("select host from " + handler.entityClass.getApiProviderHost().getName() + " where apiName = ?1 ", String.class).setParameter(1, (Object)apiName).getResultList();
                        return new HashSet<String>(hosts);
                    }
                });
            }
        });
    }

    private static Future<StringMap> futureApiProviderConfig(final ApiHandlerImpl handler, final String apiName) {
        return handler.taskHandler.submit((Callable)new Callable<StringMap>(){

            @Override
            public StringMap call() throws Exception {
                return handler.trxManagerInfo.transaction(new SessionCallable<StringMap>(){

                    @Override
                    public StringMap call(Session session) throws Exception {
                        List items = session.createQuery("select configName, configValue from " + handler.entityClass.getApiProviderConfig().getName() + " where apiName = ?1 ", Object[].class).setParameter(1, (Object)apiName).getResultList();
                        StringMap config = new StringMap();
                        while (!items.isEmpty()) {
                            Object[] item = (Object[])items.remove(0);
                            config.put((Object)((String)item[0]), (Object)((String)item[1]));
                        }
                        return config;
                    }
                });
            }
        });
    }

    private static Future<StringMap> futureApiProviderRole(final ApiHandlerImpl handler, final String apiName) {
        return handler.taskHandler.submit((Callable)new Callable<StringMap>(){

            @Override
            public StringMap call() throws Exception {
                return handler.trxManagerInfo.transaction(new SessionCallable<StringMap>(){

                    @Override
                    public StringMap call(Session session) throws Exception {
                        List items = session.createQuery("select roleCode, apiRoleCode from " + handler.entityClass.getApiProviderRole().getName() + " where apiName = ?1 and isActive = ?2 ", Object[].class).setParameter(1, (Object)apiName).setParameter(2, (Object)FrameworkUtil.YES).getResultList();
                        StringMap role = new StringMap();
                        while (!items.isEmpty()) {
                            Object[] item = (Object[])items.remove(0);
                            role.put((Object)((String)item[0]), (Object)((String)item[1]));
                        }
                        return role;
                    }
                });
            }
        });
    }
}

