/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.ideahut.springboot.api.ApiHandlerImpl;
import net.ideahut.springboot.api.dto.ApiCrudDto;
import net.ideahut.springboot.api.dto.ApiProviderCrudDto;
import net.ideahut.springboot.api.dto.ApiRoleCrudDto;
import net.ideahut.springboot.api.dto.ApiRoleCrudFilterDto;
import net.ideahut.springboot.crud.CrudAction;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.entity.SessionCallable;
import net.ideahut.springboot.util.FrameworkUtil;
import org.hibernate.Session;

final class ApiHandler3 {
    private ApiHandler3() {
    }

    private static CrudProperties getCrudPropertiesFromEntityObject(ApiHandlerImpl handler, Object object) {
        CrudProperties properties = null;
        if (object != null) {
            ApiCrudDto crud = handler.dataMapper.copy(object, ApiCrudDto.class);
            String packageName = crud.getPackageName() != null ? crud.getPackageName().trim() : "";
            Object className = crud.getClassName();
            if (!packageName.isEmpty()) {
                className = packageName + "." + (String)className;
            }
            properties = new CrudProperties();
            properties.setClassName((String)className);
            properties.setEnableLoad(FrameworkUtil.isTrue(crud.getIsLoadEnabled()));
            properties.setEnableStack(FrameworkUtil.isTrue(crud.getIsStackEnabled()));
            properties.setManagerName(crud.getManager());
            properties.setMaxLimit(crud.getMaxLimit());
            properties.setUseNative(FrameworkUtil.isTrue(crud.getIsUseNative()));
        }
        return properties;
    }

    private static Future<List<String>> futureCrudFields(final ApiHandlerImpl handler, final String apiCrudCode) {
        return handler.taskHandler.submit((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return handler.trxManagerInfo.transaction(new SessionCallable<List<String>>(){

                    @Override
                    public List<String> call(Session session) throws Exception {
                        return session.createQuery("select fieldName from " + handler.entityClass.getApiCrudField().getName() + " where apiCrudCode = ?1 ", String.class).setParameter(1, (Object)apiCrudCode).getResultList();
                    }
                });
            }
        });
    }

    private static Future<CrudProperties> futureCrudPropertiesByApiRole(final ApiHandlerImpl handler, final ApiRoleCrudDto apiCrudRoleDto) {
        return handler.taskHandler.submit((Callable)new Callable<CrudProperties>(){

            @Override
            public CrudProperties call() throws Exception {
                Object object = handler.trxManagerInfo.transaction(new SessionCallable<Object>(){

                    @Override
                    public Object call(Session session) throws Exception {
                        Object object = session.createQuery("select a from " + handler.entityClass.getApiCrud().getName() + " a join " + handler.entityClass.getApiRoleCrud().getName() + " b on b.apiCrudCode = a.apiCrudCode where b.apiRoleCode = ?1 and a.apiCrudCode = ?2 ", Object.class).setParameter(1, (Object)apiCrudRoleDto.getApiRoleCode()).setParameter(2, (Object)apiCrudRoleDto.getApiCrudCode()).uniqueResult();
                        handler.trxManagerInfo.loadLazy(object, handler.entityClass.getApiCrud());
                        return object;
                    }
                });
                return ApiHandler3.getCrudPropertiesFromEntityObject(handler, object);
            }
        });
    }

    private static Future<List<CrudProperties.SpecificFilter>> futureCrudSpecifics(final ApiHandlerImpl handler, final ApiRoleCrudDto apiCrudRoleDto) {
        return handler.taskHandler.submit((Callable)new Callable<List<CrudProperties.SpecificFilter>>(){

            @Override
            public List<CrudProperties.SpecificFilter> call() throws Exception {
                List<Object> items = handler.trxManagerInfo.transaction(new SessionCallable<List<Object>>(){

                    @Override
                    public List<Object> call(Session session) throws Exception {
                        String name = handler.entityClass.getFieldNameForCrudRole();
                        Object apiCrudRole = handler.dataMapper.copy((Object)apiCrudRoleDto, handler.entityClass.getApiRoleCrud());
                        List items = session.createQuery("from " + handler.entityClass.getApiRoleCrudFilter().getName() + " where " + name + " = ?1 ", Object.class).setParameter(1, apiCrudRole).getResultList();
                        handler.trxManagerInfo.loadLazy(items, handler.entityClass.getApiRoleCrudFilter());
                        return items;
                    }
                });
                ArrayList<CrudProperties.SpecificFilter> specifics = new ArrayList<CrudProperties.SpecificFilter>();
                while (!items.isEmpty()) {
                    Object item = items.remove(0);
                    ApiRoleCrudFilterDto filter = handler.dataMapper.copy(item, ApiRoleCrudFilterDto.class);
                    CrudProperties.SpecificFilter specific = new CrudProperties.SpecificFilter();
                    specific.setField(filter.getFieldName());
                    specific.setPlain(FrameworkUtil.isTrue(filter.getIsPlainValue()));
                    specific.setValue(filter.getFilterValue());
                    specifics.add(specific);
                }
                return specifics;
            }
        });
    }

    private static Future<Set<CrudAction>> futureCrudActionsByApiRole(final ApiHandlerImpl handler, final ApiRoleCrudDto apiCrudRoleDto) {
        return handler.taskHandler.submit((Callable)new Callable<Set<CrudAction>>(){

            @Override
            public Set<CrudAction> call() throws Exception {
                List<String> items = handler.trxManagerInfo.transaction(new SessionCallable<List<String>>(){

                    @Override
                    public List<String> call(Session session) throws Exception {
                        return session.createQuery("select action from " + handler.entityClass.getApiRoleCrudAction().getName() + " where apiRoleCode = ?1 and apiCrudCode = ?2 ", String.class).setParameter(1, (Object)apiCrudRoleDto.getApiRoleCode()).setParameter(2, (Object)apiCrudRoleDto.getApiCrudCode()).getResultList();
                    }
                });
                HashSet<CrudAction> actions = new HashSet<CrudAction>();
                while (!items.isEmpty()) {
                    CrudAction action = CrudAction.of(items.remove(0));
                    if (action == null) continue;
                    actions.add(action);
                }
                return actions;
            }
        });
    }

    static CrudProperties getCrudPropertiesByApiRole(ApiHandlerImpl handler, ApiRoleCrudDto apiCrudRoleDto) {
        Future<CrudProperties> futureProperties = ApiHandler3.futureCrudPropertiesByApiRole(handler, apiCrudRoleDto);
        Future<List<String>> futureFields = ApiHandler3.futureCrudFields(handler, apiCrudRoleDto.getApiCrudCode());
        Future<List<CrudProperties.SpecificFilter>> futureSpecifics = ApiHandler3.futureCrudSpecifics(handler, apiCrudRoleDto);
        Future<Set<CrudAction>> futureActions = ApiHandler3.futureCrudActionsByApiRole(handler, apiCrudRoleDto);
        try {
            CrudProperties properties = futureProperties.get();
            List<String> fields = futureFields.get();
            List<CrudProperties.SpecificFilter> specifics = futureSpecifics.get();
            Set<CrudAction> actions = futureActions.get();
            if (properties != null) {
                properties.setSelectFields(fields);
                properties.setSpecificFilters(specifics);
                properties.setActions(actions);
            }
            return properties;
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }

    private static Future<CrudProperties> futureCrudPropertiesByApiName(final ApiHandlerImpl handler, final ApiProviderCrudDto apiProviderCrudDto) {
        return handler.taskHandler.submit((Callable)new Callable<CrudProperties>(){

            @Override
            public CrudProperties call() throws Exception {
                Object object = handler.trxManagerInfo.transaction(new SessionCallable<Object>(){

                    @Override
                    public Object call(Session session) throws Exception {
                        Object object = session.createQuery("select a from " + handler.entityClass.getApiCrud().getName() + " a join " + handler.entityClass.getApiProviderCrud().getName() + " b on b.apiCrudCode = a.apiCrudCode where b.apiName = ?1 and a.apiCrudCode = ?2 ", Object.class).setParameter(1, (Object)apiProviderCrudDto.getApiName()).setParameter(2, (Object)apiProviderCrudDto.getApiCrudCode()).uniqueResult();
                        handler.trxManagerInfo.loadLazy(object, handler.entityClass.getApiCrud());
                        return object;
                    }
                });
                return ApiHandler3.getCrudPropertiesFromEntityObject(handler, object);
            }
        });
    }

    private static Future<Set<CrudAction>> futureCrudActionsByApiName(final ApiHandlerImpl handler, final ApiProviderCrudDto apiProviderCrudDto) {
        return handler.taskHandler.submit((Callable)new Callable<Set<CrudAction>>(){

            @Override
            public Set<CrudAction> call() throws Exception {
                List<String> items = handler.trxManagerInfo.transaction(new SessionCallable<List<String>>(){

                    @Override
                    public List<String> call(Session session) throws Exception {
                        return session.createQuery("select action from " + handler.entityClass.getApiProviderCrudAction().getName() + " where apiName = ?1 and apiCrudCode = ?2 ", String.class).setParameter(1, (Object)apiProviderCrudDto.getApiName()).setParameter(2, (Object)apiProviderCrudDto.getApiCrudCode()).getResultList();
                    }
                });
                HashSet<CrudAction> actions = new HashSet<CrudAction>();
                while (!items.isEmpty()) {
                    CrudAction action = CrudAction.of(items.remove(0));
                    if (action == null) continue;
                    actions.add(action);
                }
                return actions;
            }
        });
    }

    static CrudProperties getCrudPropertiesByApiName(ApiHandlerImpl handler, ApiProviderCrudDto apiProviderCrudDto) {
        Future<CrudProperties> futureProperties = ApiHandler3.futureCrudPropertiesByApiName(handler, apiProviderCrudDto);
        Future<List<String>> futureFields = ApiHandler3.futureCrudFields(handler, apiProviderCrudDto.getApiCrudCode());
        Future<Set<CrudAction>> futureActions = ApiHandler3.futureCrudActionsByApiName(handler, apiProviderCrudDto);
        try {
            CrudProperties properties = futureProperties.get();
            List<String> fields = futureFields.get();
            Set<CrudAction> actions = futureActions.get();
            if (properties != null) {
                properties.setSelectFields(fields);
                properties.setActions(actions);
            }
            return properties;
        }
        catch (Exception e) {
            throw FrameworkUtil.exception(e);
        }
    }
}

