/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.List;
import java.util.concurrent.Callable;
import net.ideahut.springboot.api.ApiHandler;
import net.ideahut.springboot.api.ApiHandler0;
import net.ideahut.springboot.api.ApiHandler1;
import net.ideahut.springboot.api.dto.ApiProviderCrudDto;
import net.ideahut.springboot.api.dto.ApiProviderDto;
import net.ideahut.springboot.api.dto.ApiProviderRequestDto;
import net.ideahut.springboot.api.dto.ApiRoleCrudDto;
import net.ideahut.springboot.api.dto.ApiRoleRequestDto;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.bean.BeanReload;
import net.ideahut.springboot.bean.BeanShutdown;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.entity.EntityTrxManager;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.RequestInfo;
import net.ideahut.springboot.task.TaskHandler;
import net.ideahut.springboot.task.TaskListExecutor;
import net.ideahut.springboot.util.FrameworkUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;
import org.springframework.web.method.HandlerMethod;

public class ApiHandlerImpl
implements ApiHandler,
InitializingBean,
BeanReload,
BeanShutdown,
BeanConfigure<ApiHandler> {
    private boolean configured = false;
    protected TrxManagerInfo trxManagerInfo;
    protected ApplicationContext applicationContext;
    protected EntityTrxManager entityTrxManager;
    protected DataMapper dataMapper;
    protected TaskHandler taskHandler;
    protected String redisPrefix;
    protected RedisTemplate<String, byte[]> redisTemplate;
    protected EntityClass entityClass;
    protected Boolean enableCrud;
    protected Boolean enableSync;
    protected Boolean enableConsumer;
    protected Integer nullExpiry;

    public ApiHandlerImpl setEntityTrxManager(EntityTrxManager entityTrxManager) {
        this.entityTrxManager = entityTrxManager;
        return this;
    }

    public ApiHandlerImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public ApiHandlerImpl setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return this;
    }

    public ApiHandlerImpl setRedisPrefix(String redisPrefix) {
        this.redisPrefix = redisPrefix;
        return this;
    }

    public ApiHandlerImpl setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public ApiHandlerImpl setEntityClass(EntityClass entityClass) {
        this.entityClass = entityClass;
        return this;
    }

    public EntityClass getEntityClass() {
        return this.entityClass;
    }

    public ApiHandlerImpl setEnableCrud(Boolean enableCrud) {
        this.enableCrud = enableCrud;
        return this;
    }

    public ApiHandlerImpl setEnableSync(Boolean enableSync) {
        this.enableSync = enableSync;
        return this;
    }

    public ApiHandlerImpl setEnableConsumer(Boolean enableConsumer) {
        this.enableConsumer = enableConsumer;
        return this;
    }

    public ApiHandlerImpl setNullExpiry(Integer nullExpiry) {
        this.nullExpiry = nullExpiry;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.entityTrxManager, (String)"entityTrxManager is required");
        Assert.notNull((Object)this.taskHandler, (String)"taskHandler is required");
        Assert.notNull(this.redisTemplate, (String)"redisTemplate is required");
        this.enableSync = this.enableSync != null ? this.enableSync : Boolean.FALSE;
        this.enableCrud = this.enableCrud != null ? this.enableCrud : Boolean.FALSE;
        this.enableConsumer = this.enableConsumer != null ? this.enableConsumer : Boolean.FALSE;
        ApiHandler0.fixEntityClass(this);
        String string = this.redisPrefix = this.redisPrefix != null ? this.redisPrefix.trim() : "";
        if (this.redisPrefix.isEmpty()) {
            this.redisPrefix = "ApiHandler";
        }
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        if (this.nullExpiry == null || this.nullExpiry <= 0) {
            this.nullExpiry = 300;
        }
    }

    @Override
    public Callable<ApiHandler> onConfigureBean(ApplicationContext applicationContext) {
        final ApiHandlerImpl self = this;
        self.applicationContext = applicationContext;
        return new Callable<ApiHandler>(){

            @Override
            public ApiHandler call() throws Exception {
                ApiHandlerImpl.this.trxManagerInfo = FrameworkUtil.getTrxManagerInfo(ApiHandlerImpl.this.entityTrxManager, ApiHandlerImpl.this.entityClass.getTrxManagerName());
                Assert.notNull((Object)ApiHandlerImpl.this.trxManagerInfo, (String)("TrxManager is not found, for: " + ApiHandlerImpl.this.entityClass.getTrxManagerName()));
                ApiHandler0.checkEntityClass(self);
                ApiHandlerImpl.this.onReloadBean();
                ApiHandlerImpl.this.configured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.configured;
    }

    public boolean onReloadBean() throws Exception {
        if (!ApiHandler0.lock(this)) {
            return false;
        }
        try {
            ApiHandler0.clear(this);
            List<RequestInfo> requestInfos = FrameworkUtil.getRequestInfos(this.applicationContext, false);
            TaskListExecutor executor = TaskListExecutor.of((Integer)4);
            if (Boolean.TRUE.equals(this.enableCrud)) {
                ApiHandler1.deleteItemCrud(this);
                ApiHandler1.saveItemCrud(this, executor);
            }
            ApiHandler1.deleteItemRequest(this);
            ApiHandler1.saveItemRequest(this, executor, requestInfos);
            executor.concurrentResult().clear();
            if (Boolean.TRUE.equals(this.enableSync)) {
                ApiHandler1.syncEntities(this, Boolean.TRUE.equals(this.enableCrud));
            }
        }
        finally {
            ApiHandler0.unlock(this);
        }
        return true;
    }

    @Override
    public void onShutdownBean() {
        ApiHandler0.unlock(this);
    }

    @Override
    public ApiProviderDto getApiProvider(String apiName) {
        BeanConfigure.checkBeanConfigure(this);
        return ApiHandler0.getApiProvider(this, apiName);
    }

    @Override
    public CrudProperties getCrudProperties(ApiRoleCrudDto apiRoleCrudDto) {
        BeanConfigure.checkBeanConfigure(this);
        Assert.isTrue((boolean)Boolean.TRUE.equals(this.enableCrud), (String)"CRUD is not enabled");
        return ApiHandler0.getCrudProperties(this, apiRoleCrudDto);
    }

    @Override
    public CrudProperties getCrudProperties(ApiProviderCrudDto apiProviderCrudDto) {
        BeanConfigure.checkBeanConfigure(this);
        Assert.isTrue((boolean)Boolean.TRUE.equals(this.enableConsumer), (String)"ApiConsumer is not enabled");
        return ApiHandler0.getCrudProperties(this, apiProviderCrudDto);
    }

    @Override
    public ApiRoleRequestDto getApiRoleRequest(String apiRoleCode, HandlerMethod handlerMethod) {
        BeanConfigure.checkBeanConfigure(this);
        return ApiHandler0.getApiRoleRequest(this, apiRoleCode, handlerMethod);
    }

    @Override
    public ApiProviderRequestDto getApiProviderRequest(String apiName, HandlerMethod handlerMethod) {
        BeanConfigure.checkBeanConfigure(this);
        return ApiHandler0.getApiProviderRequest(this, apiName, handlerMethod);
    }

    public void clearCache() {
        ApiHandler0.clear(this);
    }

    public void removeApiCrud(ApiRoleCrudDto ... apiRoleCrudDtos) {
        if (apiRoleCrudDtos != null) {
            for (ApiRoleCrudDto apiRoleCrudDto : apiRoleCrudDtos) {
                ApiHandler0.removeApiCrud(this, apiRoleCrudDto);
            }
        }
    }

    public void removeApiCrud(ApiProviderCrudDto ... apiProviderCrudDtos) {
        if (apiProviderCrudDtos != null) {
            for (ApiProviderCrudDto apiProviderCrudDto : apiProviderCrudDtos) {
                ApiHandler0.removeApiCrud(this, apiProviderCrudDto);
            }
        }
    }

    public void removeApiRequest(ApiRoleRequestDto ... apiRoleRequestDtos) {
        if (apiRoleRequestDtos != null) {
            for (ApiRoleRequestDto apiRoleRequestDto : apiRoleRequestDtos) {
                ApiHandler0.removeApiRequest(this, apiRoleRequestDto);
            }
        }
    }

    public void removeApiRequest(ApiProviderRequestDto ... apiProviderRequestDtos) {
        if (apiProviderRequestDtos != null) {
            for (ApiProviderRequestDto apiProviderRequestDto : apiProviderRequestDtos) {
                ApiHandler0.removeApiRequest(this, apiProviderRequestDto);
            }
        }
    }

    public void removeApiProvider(String ... apiNames) {
        if (apiNames != null) {
            for (String apiName : apiNames) {
                ApiHandler0.removeApiProvider(this, apiName);
            }
        }
    }

    public static class EntityClass {
        private String trxManagerName;
        private String fieldNameForCrudRole;
        private Class<?> apiCrud;
        private Class<?> apiCrudField;
        private Class<?> apiItemCrud;
        private Class<?> apiItemRequest;
        private Class<?> apiProvider;
        private Class<?> apiProviderConfig;
        private Class<?> apiProviderCrud;
        private Class<?> apiProviderCrudAction;
        private Class<?> apiProviderHost;
        private Class<?> apiProviderRequest;
        private Class<?> apiProviderRole;
        private Class<?> apiRole;
        private Class<?> apiRoleCrud;
        private Class<?> apiRoleCrudAction;
        private Class<?> apiRoleCrudFilter;
        private Class<?> apiRoleRequest;

        public EntityClass setTrxManagerName(String trxManagerName) {
            this.trxManagerName = trxManagerName;
            return this;
        }

        public EntityClass setFieldNameForCrudRole(String fieldNameForCrudRole) {
            this.fieldNameForCrudRole = fieldNameForCrudRole;
            return this;
        }

        public EntityClass setApiCrud(Class<?> apiCrud) {
            this.apiCrud = apiCrud;
            return this;
        }

        public EntityClass setApiCrudField(Class<?> apiCrudField) {
            this.apiCrudField = apiCrudField;
            return this;
        }

        public EntityClass setApiItemCrud(Class<?> apiItemCrud) {
            this.apiItemCrud = apiItemCrud;
            return this;
        }

        public EntityClass setApiItemRequest(Class<?> apiItemRequest) {
            this.apiItemRequest = apiItemRequest;
            return this;
        }

        public EntityClass setApiProvider(Class<?> apiProvider) {
            this.apiProvider = apiProvider;
            return this;
        }

        public EntityClass setApiProviderConfig(Class<?> apiProviderConfig) {
            this.apiProviderConfig = apiProviderConfig;
            return this;
        }

        public EntityClass setApiProviderCrud(Class<?> apiProviderCrud) {
            this.apiProviderCrud = apiProviderCrud;
            return this;
        }

        public EntityClass setApiProviderCrudAction(Class<?> apiProviderCrudAction) {
            this.apiProviderCrudAction = apiProviderCrudAction;
            return this;
        }

        public EntityClass setApiProviderHost(Class<?> apiProviderHost) {
            this.apiProviderHost = apiProviderHost;
            return this;
        }

        public EntityClass setApiProviderRequest(Class<?> apiProviderRequest) {
            this.apiProviderRequest = apiProviderRequest;
            return this;
        }

        public EntityClass setApiProviderRole(Class<?> apiProviderRole) {
            this.apiProviderRole = apiProviderRole;
            return this;
        }

        public EntityClass setApiRole(Class<?> apiRole) {
            this.apiRole = apiRole;
            return this;
        }

        public EntityClass setApiRoleCrud(Class<?> apiRoleCrud) {
            this.apiRoleCrud = apiRoleCrud;
            return this;
        }

        public EntityClass setApiRoleCrudAction(Class<?> apiRoleCrudAction) {
            this.apiRoleCrudAction = apiRoleCrudAction;
            return this;
        }

        public EntityClass setApiRoleCrudFilter(Class<?> apiRoleCrudFilter) {
            this.apiRoleCrudFilter = apiRoleCrudFilter;
            return this;
        }

        public EntityClass setApiRoleRequest(Class<?> apiRoleRequest) {
            this.apiRoleRequest = apiRoleRequest;
            return this;
        }

        public String getTrxManagerName() {
            return this.trxManagerName;
        }

        public String getFieldNameForCrudRole() {
            return this.fieldNameForCrudRole;
        }

        public Class<?> getApiCrud() {
            return this.apiCrud;
        }

        public Class<?> getApiCrudField() {
            return this.apiCrudField;
        }

        public Class<?> getApiItemCrud() {
            return this.apiItemCrud;
        }

        public Class<?> getApiItemRequest() {
            return this.apiItemRequest;
        }

        public Class<?> getApiProvider() {
            return this.apiProvider;
        }

        public Class<?> getApiProviderConfig() {
            return this.apiProviderConfig;
        }

        public Class<?> getApiProviderCrud() {
            return this.apiProviderCrud;
        }

        public Class<?> getApiProviderCrudAction() {
            return this.apiProviderCrudAction;
        }

        public Class<?> getApiProviderHost() {
            return this.apiProviderHost;
        }

        public Class<?> getApiProviderRequest() {
            return this.apiProviderRequest;
        }

        public Class<?> getApiProviderRole() {
            return this.apiProviderRole;
        }

        public Class<?> getApiRole() {
            return this.apiRole;
        }

        public Class<?> getApiRoleCrud() {
            return this.apiRoleCrud;
        }

        public Class<?> getApiRoleCrudAction() {
            return this.apiRoleCrudAction;
        }

        public Class<?> getApiRoleCrudFilter() {
            return this.apiRoleCrudFilter;
        }

        public Class<?> getApiRoleRequest() {
            return this.apiRoleRequest;
        }
    }
}

