/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ideahut.springboot.exception.ResultException;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.object.Result;
import net.ideahut.springboot.util.FrameworkUtil;

final class ApiHelper {
    static final String SEPARATOR = "::";
    static final String API_PRIMARY = "API_PRIMARY";
    static final byte[] NULL = new byte[]{0};

    private ApiHelper() {
    }

    static <T> T valueOf(DataMapper mapper, byte[] bytes, Class<T> type) {
        if (bytes.length == 1 && bytes[0] == NULL[0]) {
            return null;
        }
        return mapper.read(bytes, type);
    }

    static <T> byte[] bytesOf(DataMapper mapper, T object) {
        if (object != null) {
            return mapper.writeAsBytes(object, 1);
        }
        return NULL;
    }

    static RuntimeException exception(Throwable throwable, String errorCode, String errorText) {
        Result result;
        List error;
        String cderr = "";
        if (throwable instanceof ResultException && (error = (result = ((ResultException)throwable).getResult()).getError()) != null && !error.isEmpty()) {
            cderr = ((Message)error.get(error.size() - 1)).getCode();
        }
        return FrameworkUtil.exception(Result.error((String)errorCode, (String)(errorText + (String)(!cderr.isEmpty() ? " (" + cderr + ")" : ""))));
    }

    static RuntimeException exception(Throwable throwable, Message error) {
        return ApiHelper.exception(throwable, error.getCode(), error.getText());
    }

    static void throwIfTrue(boolean condition, String errorCode, String errorText) {
        if (condition) {
            throw ApiHelper.exception(null, errorCode, errorText);
        }
    }

    static void throwIfTrue(boolean condition, Message error) {
        if (condition) {
            throw ApiHelper.exception(null, error);
        }
    }

    static String fixDigest(String digest, String defaultValue) {
        String algorithm = FrameworkUtil.getOrDefault(digest, "").trim().toUpperCase();
        if (algorithm.isEmpty()) {
            algorithm = defaultValue;
        }
        return algorithm;
    }

    static final class Error {
        static final Message TYPE_NOT_FOUND = Message.of((String)"API-00", (String)"ApiType not found");
        static final Message PROCESSOR_NOT_AVAIL = Message.of((String)"API-01", (String)"ApiProcessor unavailable");
        static final Message PARAMETER_NOT_VALID = Message.of((String)"API-02", (String)"Invalid ApiParameter");
        static final Message KEY_NOT_VALID = Message.of((String)"API-03", (String)"Invalid ApiKey");
        static final Message NAME_NOT_VALID = Message.of((String)"API-04", (String)"Invalid ApiName");
        static final Message ACCESS_NOT_VALID = Message.of((String)"API-05", (String)"Invalid ApiAccess");
        static final Message ACCESS_EXPIRED = Message.of((String)"API-06", (String)"ApiAccess expired");
        static final Message ACCESS_NOT_FOUND = Message.of((String)"API-07", (String)"ApiAccess not found");
        static final Message ACCESS_NOT_ALLOWED = Message.of((String)"API-08", (String)"ApiAccess not allowed");
        static final Message REQUEST_NOT_VALID = Message.of((String)"API-09", (String)"Invalid Request");
        static final Message SOURCE_NOT_FOUND = Message.of((String)"API-10", (String)"ApiSource not found");
        static final Message SOURCE_NOT_ALLOWED = Message.of((String)"API-11", (String)"ApiSource not allowed");
        static final Message HOST_NOT_VALID = Message.of((String)"API-12", (String)"Invalid Host");
        static final Message DATA_HEADER_NOT_VALID = Message.of((String)"API-13", (String)"Invalid data header");
        static final Message TIMESTAMP_REQUIRED = Message.of((String)"API-14", (String)"Timestamp required");
        static final Message TIMESTAMP_NOT_VALID = Message.of((String)"API-15", (String)"Invalid Timestamp");
        static final Message SIGNATURE_NOT_VALID = Message.of((String)"API-16", (String)"Invalid Signature");
        static final Message TOKEN_NOT_VALID = Message.of((String)"API-17", (String)"Invalid ApiToken");
        static final Message TOKEN_SECRET_REQUIRED = Message.of((String)"API-18", (String)"ApiToken secret required");
        static final Message TOKEN_EXPIRED = Message.of((String)"API-19", (String)"ApiToken expired");
        static final Message TOKEN_URL_REQUIRED = Message.of((String)"API-20", (String)"ApiToken url required");
        static final Message TOKEN_SERVICE_NULL = Message.of((String)"API-21", (String)"ApiToken service not available");
        static final Message INTERNAL_SERVICE_NULL = Message.of((String)"API-22", (String)"Internal access service not available");

        private Error() {
        }
    }

    static final class TypeRef {
        static final TypeReference<Set<String>> STRING_SET = new TypeReference<Set<String>>(){};
        static final TypeReference<Map<String, String>> STRING_MAP = new TypeReference<Map<String, String>>(){};

        private TypeRef() {
        }
    }
}

