/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.Base64;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiServiceImpl;

final class ApiPrimary {
    static final int AUTH = 1;
    static final int TOKEN = 2;
    static final int TYPE = 3;
    private String apiKey;
    private String apiName;
    private String apiType;
    private String scheme;
    private String content;
    private int category;

    ApiPrimary() {
    }

    protected ApiPrimary setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    protected ApiPrimary setApiName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    protected ApiPrimary setApiType(String apiType) {
        this.apiType = apiType;
        return this;
    }

    protected ApiPrimary setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    protected ApiPrimary setContent(String content) {
        this.content = content;
        return this;
    }

    public ApiPrimary setCategory(int category) {
        this.category = category;
        return this;
    }

    static ApiPrimary parse(String token) {
        ApiPrimary apiPrimary = new ApiPrimary();
        if (token != null && !token.isEmpty()) {
            String text = token;
            int idx = text.indexOf(" ");
            if (idx != -1) {
                apiPrimary.setScheme(text.substring(0, idx));
                text = text.substring(idx + 1);
            }
            if ((idx = text.indexOf("::")) != -1) {
                apiPrimary.setContent(text.substring(idx + "::".length()));
                text = text.substring(0, idx);
                String prefix = new String(Base64.getDecoder().decode(text));
                String[] split = prefix.split("::");
                if (split.length == 3) {
                    apiPrimary.setApiKey(split[0]).setApiType(split[1]).setApiName(split[2]);
                }
            }
        }
        return apiPrimary;
    }

    static ApiPrimary parse(ApiServiceImpl<?> service, ApiRequest apiRequest) {
        ApiPrimary apiPrimary = new ApiPrimary();
        String authorization = apiRequest.getHeader("Authorization", "");
        if (!authorization.isEmpty()) {
            apiPrimary = ApiPrimary.parse(authorization).setCategory(1);
        } else {
            String token = apiRequest.getHeader(service.header.getToken(), "");
            if (!token.isEmpty()) {
                apiPrimary = ApiPrimary.parse(token).setCategory(2);
            } else {
                String apiType = apiRequest.getHeader(service.header.getType(), "");
                apiPrimary.setApiType(apiType).setCategory(3);
            }
        }
        return apiPrimary;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getApiType() {
        return this.apiType;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getContent() {
        return this.content;
    }

    public int getCategory() {
        return this.category;
    }
}

