/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiAuth;
import net.ideahut.springboot.api.ApiHeader;
import net.ideahut.springboot.api.ApiParameter;
import net.ideahut.springboot.api.ApiPrimary;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiService1;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.exception.ResultException;
import net.ideahut.springboot.object.Result;

public abstract class ApiProcessor {
    protected final ApiService apiService;

    protected ApiProcessor(ApiService apiService) {
        this.apiService = apiService;
    }

    private ApiParameter getApiParameterFromApiPrimary(ApiRequest apiRequest, int category) {
        ApiPrimary apiPrimary = (ApiPrimary)apiRequest.getAttribute("API_PRIMARY");
        if (apiPrimary != null && category == apiPrimary.getCategory()) {
            return new ApiParameter().setApiKey(apiPrimary.getApiKey()).setApiName(apiPrimary.getApiName()).setApiType(apiPrimary.getApiType()).setContent(apiPrimary.getContent()).setScheme(apiPrimary.getScheme());
        }
        return null;
    }

    protected ApiParameter getApiParameterFromAuthorization(ApiRequest apiRequest) {
        ApiParameter apiParameter = this.getApiParameterFromApiPrimary(apiRequest, 1);
        if (apiParameter == null) {
            String authorization = apiRequest.getHeader("Authorization", "");
            apiParameter = ApiService1.getApiParameter(authorization);
        }
        return apiParameter;
    }

    protected ApiParameter getApiParameterFromTokenHeader(ApiRequest apiRequest) {
        ApiParameter apiParameter = this.getApiParameterFromApiPrimary(apiRequest, 2);
        if (apiParameter == null) {
            ApiHeader apiHeader = this.apiService.getApiHeader();
            String token = apiRequest.getHeader(apiHeader.getTokenHeader(), "");
            apiParameter = ApiService1.getApiParameter(token);
        }
        return apiParameter;
    }

    protected String createApiKey(ApiParameter apiParameter, String digest) {
        return ApiService1.createApiKey(this.apiService, apiParameter, digest);
    }

    protected String createToken(ApiParameter apiParameter) {
        return ApiService1.createToken(apiParameter);
    }

    protected void throwIfTrue(ApiProcessor processor, String errorCode, boolean condition) throws Exception {
        if (condition) {
            throw new ResultException(Result.error((String)(processor.getApiType() + "-" + errorCode)));
        }
    }

    public abstract String getApiType();

    public abstract ApiParameter getApiParameter(ApiRequest var1) throws Exception;

    public abstract ApiAccess getApiAccess(ApiSource var1, ApiParameter var2) throws Exception;

    public abstract boolean isValidAccess(ApiSource var1, ApiParameter var2, ApiAccess var3);

    public abstract ApiAuth createApiAuth(ApiSource var1, ApiParameter var2, ApiAccess var3) throws Exception;
}

