/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import net.ideahut.springboot.api.ApiHeader;
import net.ideahut.springboot.api.ApiProcessor;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiServiceImpl;
import net.ideahut.springboot.util.FrameworkUtil;

final class ApiService0 {
    private ApiService0() {
    }

    static void prepareProcessors(ApiServiceImpl<?> service) throws Exception {
        if (service.processorClasses != null) {
            service.processors.clear();
            Class[] types = new Class[]{ApiService.class};
            for (Class<? extends ApiProcessor> clazz : service.processorClasses) {
                ApiProcessor processor = (ApiProcessor)FrameworkUtil.newInstance(clazz, types, new Object[]{service});
                ApiProcessor aproc = service.processors.get(processor.getApiType());
                if (aproc != null) {
                    throw new Exception("Duplicate processor, ApiType: " + processor.getApiType() + " [" + aproc.getClass().getName() + " x " + processor.getClass().getName() + "]");
                }
                service.processors.put(processor.getApiType(), processor);
            }
        }
    }

    static void fixRedisExpiry(ApiServiceImpl<?> service) {
        ApiServiceImpl.RedisExpiry redisExpiry;
        ApiServiceImpl.RedisExpiry redisExpiry2 = redisExpiry = service.redisExpiry != null ? service.redisExpiry : new ApiServiceImpl.RedisExpiry();
        if (redisExpiry.getAccessItem() == null || redisExpiry.getAccessItem() <= 0) {
            redisExpiry.setAccessItem(300);
        }
        if (redisExpiry.getAccessNull() == null || redisExpiry.getAccessNull() <= 0) {
            redisExpiry.setAccessNull(120);
        }
        if (redisExpiry.getConsumerItem() == null || redisExpiry.getConsumerItem() <= 0) {
            redisExpiry.setConsumerItem(600);
        }
        if (redisExpiry.getConsumerNull() == null || redisExpiry.getConsumerNull() <= 0) {
            redisExpiry.setConsumerNull(150);
        }
        service.redisExpiry = redisExpiry;
    }

    static void fixHeader(ApiServiceImpl<?> service) {
        ApiServiceImpl.Header header = service.header != null ? service.header : new ApiServiceImpl.Header();
        String token = header.getToken() != null ? header.getToken().trim() : "";
        header.setToken(!token.isEmpty() ? token : "Access-Token");
        String type = header.getType() != null ? header.getType().trim() : "";
        header.setType(!type.isEmpty() ? type : "Access-Type");
        String signature = header.getSignature() != null ? header.getSignature().trim() : "";
        header.setSignature(!signature.isEmpty() ? signature : "Access-Signature");
        String timestamp = header.getTimestamp() != null ? header.getTimestamp().trim() : "";
        header.setTimestamp(!timestamp.isEmpty() ? timestamp : "Access-Timestamp");
        String zoneOffset = header.getZoneOffset() != null ? header.getZoneOffset().trim() : "";
        header.setZoneOffset(!zoneOffset.isEmpty() ? zoneOffset : "Access-ZoneOffset");
        String from = header.getFrom() != null ? header.getFrom().trim() : "";
        header.setFrom(!from.isEmpty() ? from : "Access-From");
        String data = header.getData() != null ? header.getData().trim() : "";
        header.setData(!data.isEmpty() ? data : "Access-Data");
        service.header = header;
        ApiHeader apiHeader = new ApiHeader();
        apiHeader.setDataHeader(header.getData());
        apiHeader.setFromHeader(header.getFrom());
        apiHeader.setSignatureHeader(header.getSignature());
        apiHeader.setTimestampHeader(header.getTimestamp());
        apiHeader.setZoneOffsetHeader(header.getZoneOffset());
        apiHeader.setTokenHeader(header.getToken());
        apiHeader.setTypeHeader(header.getType());
        service.apiHeader = apiHeader;
    }

    static final class Keys {
        private Keys() {
        }

        static String access(ApiServiceImpl<?> service, String apiKey) {
            return service.redisPrefix + "--ACCESS--" + apiKey;
        }

        static String consumer(ApiServiceImpl<?> service, String token) {
            return service.redisPrefix + "--CONSUMER--" + token;
        }
    }
}

