/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.Base64;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiHelper;
import net.ideahut.springboot.api.ApiParameter;
import net.ideahut.springboot.api.ApiProcessor;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiService0;
import net.ideahut.springboot.api.ApiServiceImpl;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.util.Assert;

final class ApiService1 {
    private ApiService1() {
    }

    static String createApiKey(ApiService apiService, ApiParameter apiParameter, String digest) {
        Assert.hasLength((String)apiParameter.getApiType(), (String)"ApiParameter.apiType is required");
        Assert.hasLength((String)apiParameter.getApiName(), (String)"ApiParameter.apiName is required");
        Assert.hasLength((String)apiParameter.getContent(), (String)"ApiParameter.content is required");
        String algorithm = ApiHelper.fixDigest(digest, apiService.getDefaultDigest());
        String apiKey = UUID.randomUUID().toString() + apiParameter.getApiType() + apiParameter.getApiName() + apiParameter.getContent();
        return FrameworkUtil.digest(algorithm, apiKey);
    }

    static String createToken(ApiParameter apiParameter) {
        Assert.hasLength((String)apiParameter.getApiKey(), (String)"ApiParameter.apiKey is required");
        Assert.hasLength((String)apiParameter.getApiType(), (String)"ApiParameter.apiType is required");
        Assert.hasLength((String)apiParameter.getApiName(), (String)"ApiParameter.apiName is required");
        Assert.hasLength((String)apiParameter.getContent(), (String)"ApiParameter.content is required");
        Object prefix = apiParameter.getApiKey() + "::" + apiParameter.getApiType() + "::" + apiParameter.getApiName();
        prefix = Base64.getEncoder().encodeToString(((String)prefix).getBytes());
        return (String)prefix + "::" + apiParameter.getContent();
    }

    static ApiProcessor getApiProcessor(ApiServiceImpl<?> service, ApiRequest apiRequest, String apiType) {
        ApiProcessor apiProcessor = service.processors.get(apiType);
        ApiHelper.throwIfTrue(apiProcessor == null && !apiRequest.isPublicMapping(), ApiHelper.Error.PROCESSOR_NOT_AVAIL);
        return apiProcessor;
    }

    static ApiParameter getApiParameter(String token) {
        if (token != null && !token.isEmpty()) {
            ApiParameter apiParameter = new ApiParameter();
            String text = token;
            int idx = text.indexOf(" ");
            if (idx != -1) {
                apiParameter.setScheme(text.substring(0, idx));
                text = text.substring(idx + 1);
            }
            if ((idx = text.indexOf("::")) != -1) {
                apiParameter.setContent(text.substring(idx + "::".length()));
                text = text.substring(0, idx);
                String prefix = new String(Base64.getDecoder().decode(text));
                String[] split = prefix.split("::");
                if (split.length == 3) {
                    return apiParameter.setApiKey(split[0]).setApiType(split[1]).setApiName(split[2]);
                }
            }
        }
        return null;
    }

    static ApiParameter getApiParameter(ApiProcessor apiProcessor, ApiRequest apiRequest) {
        try {
            return apiProcessor.getApiParameter(apiRequest);
        }
        catch (Exception e) {
            throw ApiHelper.exception(e, ApiHelper.Error.PARAMETER_NOT_VALID);
        }
    }

    static boolean isValidApiKey(ApiParameter apiParameter) {
        String apiKey;
        String string = apiKey = apiParameter.getApiKey() != null ? apiParameter.getApiKey() : "";
        if (apiKey.isEmpty()) {
            ApiHelper.throwIfTrue(!apiParameter.getApiRequest().isPublicMapping(), ApiHelper.Error.KEY_NOT_VALID);
            return false;
        }
        return true;
    }

    static boolean isValidApiName(ApiParameter apiParameter) {
        String apiName;
        String string = apiName = apiParameter.getApiName() != null ? apiParameter.getApiName() : "";
        if (apiName.isEmpty()) {
            ApiHelper.throwIfTrue(!apiParameter.getApiRequest().isPublicMapping(), ApiHelper.Error.NAME_NOT_VALID);
            return false;
        }
        return true;
    }

    static void removeApiAccess(ApiServiceImpl<?> service, String ... apiKeys) {
        if (apiKeys != null && apiKeys.length != 0) {
            HashSet<String> ckeys = new HashSet<String>();
            for (String apiKey : apiKeys) {
                ckeys.add(ApiService0.Keys.access(service, apiKey));
            }
            service.redisTemplate.delete(ckeys);
            ckeys.clear();
        }
    }

    static Object[] getApiAccess(ApiServiceImpl<?> service, ApiProcessor apiProcessor, ApiParameter apiParameter) {
        String ckey = ApiService0.Keys.access(service, apiParameter.getApiKey());
        ValueOperations valops = service.redisTemplate.opsForValue();
        byte[] value = (byte[])valops.get((Object)ckey);
        if (value != null) {
            return new Object[]{ApiHelper.valueOf(service.dataMapper, value, ApiAccess.class), null};
        }
        try {
            Integer expiry;
            ApiSource apiSource = service.getApiSource(apiParameter.getApiName());
            apiSource = FrameworkUtil.getOrDefault(apiSource, new ApiSource());
            ApiAccess apiAccess = apiProcessor.getApiAccess(apiSource, apiParameter);
            value = ApiHelper.bytesOf(service.dataMapper, apiAccess);
            if (ApiHelper.NULL == value) {
                expiry = service.redisExpiry.getAccessNull();
            } else {
                Long diff;
                expiry = service.redisExpiry.getAccessItem();
                if (apiAccess.getValidUntil() != null && apiAccess.getValidUntil() > 0L && (diff = Long.valueOf((apiAccess.getValidUntil() - TimeUtil.currentEpochMillis()) / 1000L)) > 0L && diff < (long)expiry.intValue()) {
                    expiry = diff.intValue();
                }
            }
            valops.set((Object)ckey, (Object)value, (long)expiry.intValue(), TimeUnit.SECONDS);
            return new Object[]{apiAccess, apiSource};
        }
        catch (Exception e) {
            if (apiParameter.getApiRequest().isPublicMapping()) {
                return new Object[]{null, null};
            }
            throw ApiHelper.exception(e, ApiHelper.Error.ACCESS_NOT_VALID);
        }
    }
}

