/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiHeader;
import net.ideahut.springboot.api.ApiHelper;
import net.ideahut.springboot.api.ApiParameter;
import net.ideahut.springboot.api.ApiPrimary;
import net.ideahut.springboot.api.ApiProcessor;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiService0;
import net.ideahut.springboot.api.ApiService1;
import net.ideahut.springboot.api.ApiServiceImpl;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.springframework.data.redis.core.ValueOperations;

final class ApiService2 {
    private ApiService2() {
    }

    private static void validateToken(ApiServiceImpl<?> service, ApiSource apiSource, ApiRequest apiRequest) {
        ApiAccess apiAccess;
        Long now = TimeUtil.currentEpochMillis();
        String token = apiRequest.getHeader(service.apiHeader.getTokenHeader(), "");
        String ckey = ApiService0.Keys.consumer(service, token);
        ValueOperations valops = service.redisTemplate.opsForValue();
        byte[] value = (byte[])valops.get((Object)ckey);
        if (value != null) {
            apiAccess = ApiHelper.valueOf(service.dataMapper, value, ApiAccess.class);
        } else {
            try {
                apiAccess = service.apiTokenService.getConsumerApiAccess(apiSource, token);
                if (!apiSource.getApiName().equals(apiAccess.getConsumerId())) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                ApiHelper.throwIfTrue(true, ApiHelper.Error.TOKEN_NOT_VALID);
                return;
            }
            value = ApiHelper.bytesOf(service.dataMapper, apiAccess);
            valops.set((Object)ckey, (Object)value, (long)(ApiHelper.NULL != value ? service.redisExpiry.getConsumerItem() : service.redisExpiry.getConsumerNull()).intValue(), TimeUnit.SECONDS);
        }
        ApiHelper.throwIfTrue(apiAccess == null, ApiHelper.Error.TOKEN_EXPIRED);
        Long validUntil = apiAccess.getValidUntil();
        ApiHelper.throwIfTrue(validUntil == null || validUntil > 0L && validUntil < now, ApiHelper.Error.TOKEN_EXPIRED);
    }

    static ApiAccess getApiAccessByApiName(ApiServiceImpl<?> service, ApiRequest apiRequest) {
        ApiAccess apiAccess;
        String data;
        ApiHeader apiHeader = service.apiHeader;
        String from = apiRequest.getHeader(apiHeader.getFromHeader(), "");
        ApiSource apiSource = service.getApiSource(from);
        ApiHelper.throwIfTrue(apiSource == null, ApiHelper.Error.SOURCE_NOT_FOUND);
        ApiHelper.throwIfTrue(!FrameworkUtil.isTrue(apiSource.getIsConsumer()), ApiHelper.Error.SOURCE_NOT_ALLOWED);
        Set hosts = apiSource.getHosts();
        if (hosts != null && !hosts.isEmpty()) {
            ApiHelper.throwIfTrue(!hosts.contains(apiRequest.getRemoteHost()), ApiHelper.Error.HOST_NOT_VALID);
        }
        if (!(data = apiRequest.getHeader(service.apiHeader.getDataHeader(), "").trim()).isEmpty()) {
            try {
                apiAccess = service.dataMapper.read(data, ApiAccess.class);
            }
            catch (Exception e) {
                ApiHelper.throwIfTrue(true, ApiHelper.Error.DATA_HEADER_NOT_VALID);
                return null;
            }
        } else {
            apiAccess = new ApiAccess();
        }
        String signature = apiRequest.getHeader(apiHeader.getSignatureHeader(), "").trim();
        if (!signature.isEmpty()) {
            service.apiTokenService.validateSignature(apiHeader, apiSource, apiRequest, signature);
        } else {
            ApiService2.validateToken(service, apiSource, apiRequest);
        }
        return apiAccess.setConsumerId(from).setIsConsumer(Boolean.TRUE);
    }

    static ApiAccess getApiAccessByApiRole(ApiServiceImpl<?> service, ApiRequest apiRequest) {
        ApiPrimary apiPrimary = ApiPrimary.parse(service, apiRequest);
        if (apiPrimary.getApiType() == null) {
            return null;
        }
        ApiProcessor apiProcessor = ApiService1.getApiProcessor(service, apiRequest, apiPrimary.getApiType());
        if (apiProcessor == null) {
            return null;
        }
        apiRequest.setAttribute("API_PRIMARY", (Object)apiPrimary);
        ApiParameter apiParameter = ApiService1.getApiParameter(apiProcessor, apiRequest);
        apiRequest.removeAttribute(new String[]{"API_PRIMARY"});
        if (apiParameter == null) {
            return null;
        }
        apiParameter.setApiRequest(apiRequest).setInternalId(service.apiName);
        if (!ApiService1.isValidApiKey(apiParameter)) {
            return null;
        }
        if (!ApiService1.isValidApiName(apiParameter)) {
            return null;
        }
        ApiAccess apiAccess = null;
        ApiSource apiSource = null;
        if (service.apiName.equals(apiParameter.getApiName())) {
            ApiHelper.throwIfTrue(service.apiAccessService == null, ApiHelper.Error.INTERNAL_SERVICE_NULL);
            apiAccess = service.apiAccessService.getApiAccess(apiParameter);
        } else {
            Object[] array = ApiService1.getApiAccess(service, apiProcessor, apiParameter);
            apiAccess = (ApiAccess)array[0];
            apiSource = (ApiSource)array[1];
        }
        if (apiAccess != null) {
            Long validUntil = apiAccess.getValidUntil();
            ApiHelper.throwIfTrue(validUntil == null || validUntil < TimeUtil.currentEpochMillis(), ApiHelper.Error.ACCESS_EXPIRED);
            if (apiSource == null) {
                apiSource = service.getApiSource(apiParameter.getApiName());
                apiSource = apiSource != null ? apiSource : new ApiSource();
            }
            ApiHelper.throwIfTrue(!apiProcessor.isValidAccess(apiSource, apiParameter, apiAccess), ApiHelper.Error.ACCESS_NOT_ALLOWED);
        } else if (!apiRequest.isPublicMapping()) {
            ApiHelper.throwIfTrue(true, ApiHelper.Error.ACCESS_NOT_FOUND);
        }
        return apiAccess;
    }
}

