/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiAccessService;
import net.ideahut.springboot.api.ApiHandler;
import net.ideahut.springboot.api.ApiHeader;
import net.ideahut.springboot.api.ApiParameter;
import net.ideahut.springboot.api.ApiPrimary;
import net.ideahut.springboot.api.ApiProcessor;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiService;
import net.ideahut.springboot.api.ApiService0;
import net.ideahut.springboot.api.ApiService1;
import net.ideahut.springboot.api.ApiService2;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.api.ApiSourceService;
import net.ideahut.springboot.api.ApiTokenService;
import net.ideahut.springboot.api.dto.ApiProviderCrudDto;
import net.ideahut.springboot.api.dto.ApiProviderDto;
import net.ideahut.springboot.api.dto.ApiRoleCrudDto;
import net.ideahut.springboot.bean.BeanConfigure;
import net.ideahut.springboot.crud.CrudProperties;
import net.ideahut.springboot.entity.TrxManagerInfo;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.mapper.DataMapperImpl;
import net.ideahut.springboot.object.SelfReference;
import net.ideahut.springboot.task.TaskHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;
import org.springframework.web.method.HandlerMethod;

abstract class ApiServiceImpl<T>
extends SelfReference<T>
implements ApiService,
InitializingBean,
BeanConfigure<ApiService> {
    private static final long serialVersionUID = 1838337944218017601L;
    private boolean configured = false;
    private transient ApplicationContext applicationContext;
    protected transient TrxManagerInfo trxManagerInfo;
    protected transient Map<String, ApiProcessor> processors = new HashMap<String, ApiProcessor>();
    protected transient ApiHeader apiHeader;
    protected transient DataMapper dataMapper;
    protected transient TaskHandler taskHandler;
    protected transient RedisExpiry redisExpiry;
    protected String redisPrefix;
    protected transient RedisTemplate<String, byte[]> redisTemplate;
    protected transient Header header;
    protected transient ApiHandler apiHandler;
    protected transient ApiSourceService apiSourceService;
    protected transient ApiAccessService apiAccessService;
    protected transient ApiTokenService apiTokenService;
    protected transient Set<Class<? extends ApiProcessor>> processorClasses;
    protected String apiName;
    protected String defaultDigest;

    ApiServiceImpl() {
    }

    public T setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return (T)this.self();
    }

    public T setTaskHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
        return (T)this.self();
    }

    public T setRedisExpiry(RedisExpiry redisExpiry) {
        this.redisExpiry = redisExpiry;
        return (T)this.self();
    }

    public T setRedisPrefix(String redisPrefix) {
        this.redisPrefix = redisPrefix;
        return (T)this.self();
    }

    public T setRedisTemplate(RedisTemplate<String, byte[]> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return (T)this.self();
    }

    public T setHeader(Header header) {
        this.header = header;
        return (T)this.self();
    }

    public T setApiHandler(ApiHandler apiHandler) {
        this.apiHandler = apiHandler;
        return (T)this.self();
    }

    public T setApiAccessService(ApiAccessService apiAccessService) {
        this.apiAccessService = apiAccessService;
        return (T)this.self();
    }

    public T setApiSourceService(ApiSourceService apiSourceService) {
        this.apiSourceService = apiSourceService;
        return (T)this.self();
    }

    public T setApiTokenService(ApiTokenService apiTokenService) {
        this.apiTokenService = apiTokenService;
        return (T)this.self();
    }

    public T setApiName(String apiName) {
        this.apiName = apiName;
        return (T)this.self();
    }

    public T setDefaultDigest(String defaultDigest) {
        this.defaultDigest = defaultDigest;
        return (T)this.self();
    }

    public T setApiProcessors(Collection<Class<? extends ApiProcessor>> processors) {
        this.processorClasses = processors != null ? new HashSet<Class<? extends ApiProcessor>>(processors) : null;
        return (T)this.self();
    }

    @Override
    public Callable<ApiService> onConfigureBean(final ApplicationContext applicationContext) {
        final ApiServiceImpl self = this;
        self.applicationContext = applicationContext;
        return new Callable<ApiService>(){

            @Override
            public ApiService call() throws Exception {
                String string = ApiServiceImpl.this.apiName = ApiServiceImpl.this.apiName != null ? ApiServiceImpl.this.apiName.trim() : "";
                if (ApiServiceImpl.this.apiName.isEmpty()) {
                    if (applicationContext != null && applicationContext.getId() != null) {
                        ApiServiceImpl.this.apiName = applicationContext.getId();
                    }
                    Assert.hasLength((String)ApiServiceImpl.this.apiName, (String)"apiName is required");
                }
                ApiService0.prepareProcessors(self);
                ApiServiceImpl.this.configured = true;
                return self;
            }
        };
    }

    @Override
    public boolean isBeanConfigured() {
        return this.configured;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.redisTemplate, (String)"redisTemplate is required");
        Assert.notNull((Object)this.apiHandler, (String)"apiHandler is required");
        Assert.notNull((Object)this.apiTokenService, (String)"apiTokenService is required");
        if (this.dataMapper == null) {
            this.dataMapper = new DataMapperImpl();
        }
        String string = this.redisPrefix = this.redisPrefix != null ? this.redisPrefix.trim() : "";
        if (this.redisPrefix.isEmpty()) {
            this.redisPrefix = "ApiService";
        }
        String string2 = this.defaultDigest = this.defaultDigest != null ? this.defaultDigest.trim().toUpperCase() : "";
        if (this.defaultDigest.isEmpty()) {
            this.defaultDigest = "SHA-256";
        }
        ApiService0.fixRedisExpiry(this);
        ApiService0.fixHeader(this);
    }

    protected ApiAccess getApiAccess(ApiRequest apiRequest) {
        String from = apiRequest.getHeader(this.apiHeader.getFromHeader(), "");
        if (!from.isEmpty()) {
            return ApiService2.getApiAccessByApiName(this, apiRequest);
        }
        return ApiService2.getApiAccessByApiRole(this, apiRequest);
    }

    @Override
    public String getApiKey(ApiRequest apiRequest) {
        BeanConfigure.checkBeanConfigure(this);
        ApiPrimary apiPrimary = ApiPrimary.parse(this, apiRequest);
        return apiPrimary.getApiKey();
    }

    @Override
    public void removeApiAccess(String ... apiKeys) {
        BeanConfigure.checkBeanConfigure(this);
        ApiService1.removeApiAccess(this, apiKeys);
    }

    @Override
    public ApiProcessor getApiProcessor(String apiType) {
        BeanConfigure.checkBeanConfigure(this);
        return this.processors.get(apiType);
    }

    @Override
    public String getApiName() {
        BeanConfigure.checkBeanConfigure(this);
        return this.apiName;
    }

    @Override
    public ApiHeader getApiHeader() {
        BeanConfigure.checkBeanConfigure(this);
        return this.apiHeader;
    }

    @Override
    public ApiSource getApiSource(String apiName) {
        ApiParameter apiParameter = new ApiParameter().setApiName(apiName);
        if (this.apiSourceService != null) {
            return this.apiSourceService.getApiSource(apiParameter);
        }
        ApiProviderDto apiProviderDto = this.apiHandler.getApiProvider(apiParameter.getApiName());
        return apiProviderDto != null ? this.dataMapper.copy((Object)apiProviderDto, ApiSource.class) : null;
    }

    @Override
    public boolean isApiRequestAllowed(ApiAccess apiAccess, HandlerMethod handlerMethod) {
        BeanConfigure.checkBeanConfigure(this);
        if (Boolean.TRUE.equals(apiAccess.getIsConsumer())) {
            return null != this.apiHandler.getApiProviderRequest(apiAccess.getConsumerId(), handlerMethod);
        }
        return null != this.apiHandler.getApiRoleRequest(apiAccess.getApiRole(), handlerMethod);
    }

    @Override
    public CrudProperties getApiCrudProperties(ApiAccess apiAccess, String apiCrudCode) {
        BeanConfigure.checkBeanConfigure(this);
        if (Boolean.TRUE.equals(apiAccess.getIsConsumer())) {
            return this.apiHandler.getCrudProperties(ApiProviderCrudDto.create().setApiName(apiAccess.getConsumerId()).setApiCrudCode(apiCrudCode));
        }
        return this.apiHandler.getCrudProperties(ApiRoleCrudDto.create().setApiRoleCode(apiAccess.getApiRole()).setApiCrudCode(apiCrudCode));
    }

    @Override
    public DataMapper getDataMapper() {
        return this.dataMapper;
    }

    @Override
    public ApiTokenService getApiTokenService() {
        return this.apiTokenService;
    }

    @Override
    public String getDefaultDigest() {
        return this.defaultDigest;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public static class RedisExpiry {
        private Integer accessNull;
        private Integer accessItem;
        private Integer consumerNull;
        private Integer consumerItem;

        public RedisExpiry setAccessNull(Integer accessNull) {
            this.accessNull = accessNull;
            return this;
        }

        public RedisExpiry setAccessItem(Integer accessItem) {
            this.accessItem = accessItem;
            return this;
        }

        public RedisExpiry setConsumerNull(Integer consumerNull) {
            this.consumerNull = consumerNull;
            return this;
        }

        public RedisExpiry setConsumerItem(Integer consumerItem) {
            this.consumerItem = consumerItem;
            return this;
        }

        Integer getAccessNull() {
            return this.accessNull;
        }

        Integer getAccessItem() {
            return this.accessItem;
        }

        Integer getConsumerNull() {
            return this.consumerNull;
        }

        Integer getConsumerItem() {
            return this.consumerItem;
        }
    }

    public static class Header {
        private String token;
        private String type;
        private String signature;
        private String timestamp;
        private String zoneOffset;
        private String from;
        private String data;

        public Header setToken(String token) {
            this.token = token;
            return this;
        }

        public Header setType(String type) {
            this.type = type;
            return this;
        }

        public Header setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public Header setTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Header setZoneOffset(String zoneOffset) {
            this.zoneOffset = zoneOffset;
            return this;
        }

        public Header setFrom(String from) {
            this.from = from;
            return this;
        }

        public Header setData(String data) {
            this.data = data;
            return this;
        }

        String getToken() {
            return this.token;
        }

        String getType() {
            return this.type;
        }

        String getSignature() {
            return this.signature;
        }

        String getTimestamp() {
            return this.timestamp;
        }

        String getZoneOffset() {
            return this.zoneOffset;
        }

        String getFrom() {
            return this.from;
        }

        String getData() {
            return this.data;
        }
    }
}

