/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Set;
import javax.crypto.SecretKey;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiHeader;
import net.ideahut.springboot.api.ApiHelper;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiSource;
import net.ideahut.springboot.api.ApiTokenService;
import net.ideahut.springboot.mapper.DataMapper;
import net.ideahut.springboot.object.Message;
import net.ideahut.springboot.object.StringMap;
import net.ideahut.springboot.util.FrameworkUtil;
import net.ideahut.springboot.util.TimeUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class ApiTokenServiceImpl
implements ApiTokenService,
InitializingBean {
    private Long timeSpanMillis;
    private DataMapper dataMapper;
    private JwtProcessor jwtProcessor;
    private Consumer consumer;
    private Integer signatureTimeSpan;

    public ApiTokenServiceImpl setDataMapper(DataMapper dataMapper) {
        this.dataMapper = dataMapper;
        return this;
    }

    public ApiTokenServiceImpl setJwtProcessor(JwtProcessor jwtProcessor) {
        this.jwtProcessor = jwtProcessor;
        return this;
    }

    public ApiTokenServiceImpl setConsumer(Consumer consumer) {
        this.consumer = consumer;
        return this;
    }

    public ApiTokenServiceImpl setSignatureTimeSpan(Integer signatureTimeSpan) {
        this.signatureTimeSpan = signatureTimeSpan;
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.consumer == null) {
            this.consumer = new Consumer();
        }
        if (this.consumer.getExpiry() == null) {
            this.consumer.setExpiry(0L);
        }
        if (this.jwtProcessor == null) {
            this.jwtProcessor = new JwtProcessor();
        }
        if (this.jwtProcessor.getExpiry() == null) {
            this.jwtProcessor.setExpiry(3600L);
        }
        if (this.signatureTimeSpan == null || this.signatureTimeSpan < 0) {
            this.signatureTimeSpan = 120;
        }
        this.timeSpanMillis = 1000L * (long)this.signatureTimeSpan.intValue();
    }

    @Override
    public String createConsumerToken(ApiHeader apiHeader, ApiSource apiSource, ApiRequest apiRequest) {
        Set hosts = apiSource.getHosts();
        if (hosts != null && !hosts.isEmpty()) {
            ApiHelper.throwIfTrue(!hosts.contains(apiRequest.getRemoteHost()), ApiHelper.Error.HOST_NOT_VALID);
        }
        String signature = apiRequest.getHeader(apiHeader.getSignatureHeader(), "").trim();
        ApiHelper.throwIfTrue(signature.isEmpty(), ApiHelper.Error.REQUEST_NOT_VALID);
        Message message = this.validateSignature(apiHeader, apiSource, apiRequest, signature);
        ApiHelper.throwIfTrue(message != null, message);
        StringMap config = FrameworkUtil.getOrDefault(apiSource.getConfig(), new StringMap());
        String secret = this.getConfigValue(config, "CONSUMER_JWT_SECRET", this.consumer.getSecret());
        ApiHelper.throwIfTrue(secret == null || secret.isEmpty(), ApiHelper.Error.TOKEN_SECRET_REQUIRED);
        String digest = ApiHelper.fixDigest(this.getConfigValue(config, "CONSUMER_JWT_DIGEST", ""), this.consumer.getDigest());
        Long expiry = (Long)config.getValue(Long.class, "CONSUMER_JWT_EXPIRY", (Object)this.consumer.getExpiry());
        SecretKey secretKey = this.getJwtSecretKey(secret, digest);
        Long validUntil = 0L;
        if (expiry > 0L) {
            validUntil = TimeUtil.currentEpochMillis() + expiry * 1000L;
        }
        ApiAccess apiAccess = new ApiAccess().setConsumerId(apiSource.getApiName()).setValidUntil(validUntil);
        return this.createJwtToken(secretKey, apiAccess);
    }

    @Override
    public ApiAccess getConsumerApiAccess(ApiSource apiSource, String token) {
        StringMap config = FrameworkUtil.getOrDefault(apiSource.getConfig(), new StringMap());
        String secret = this.getConfigValue(config, "CONSUMER_JWT_SECRET", this.consumer.getSecret());
        ApiHelper.throwIfTrue(secret == null || secret.isEmpty(), ApiHelper.Error.TOKEN_SECRET_REQUIRED);
        String digest = ApiHelper.fixDigest(this.getConfigValue(config, "CONSUMER_JWT_DIGEST", ""), this.consumer.getDigest());
        SecretKey secretKey = this.getJwtSecretKey(secret, digest);
        return this.getJwtPayload(ApiAccess.class, secretKey, token);
    }

    @Override
    public String createJwtProcessorToken(ApiSource apiSource, ApiAccess apiAccess) {
        StringMap config = FrameworkUtil.getOrDefault(apiSource.getConfig(), new StringMap());
        String secret = this.getConfigValue(config, "PROCESSOR_JWT_SECRET", this.jwtProcessor.getSecret());
        ApiHelper.throwIfTrue(secret == null || secret.isEmpty(), ApiHelper.Error.TOKEN_SECRET_REQUIRED);
        String digest = ApiHelper.fixDigest(this.getConfigValue(config, "PROCESSOR_JWT_DIGEST", ""), this.jwtProcessor.getDigest());
        Long expiry = (Long)config.getValue(Long.class, "PROCESSOR_JWT_EXPIRY", (Object)this.jwtProcessor.getExpiry());
        Long validUntil = apiAccess.getValidUntil();
        if (validUntil == null) {
            validUntil = expiry > 0L ? TimeUtil.currentEpochMillis() + expiry * 1000L : 0L;
        }
        apiAccess.setValidUntil(validUntil);
        SecretKey secretKey = this.getJwtSecretKey(secret, digest);
        return this.createJwtToken(secretKey, apiAccess);
    }

    @Override
    public ApiAccess getJwtProcessorApiAccess(ApiSource apiSource, String token) {
        StringMap config = FrameworkUtil.getOrDefault(apiSource.getConfig(), new StringMap());
        String secret = this.getConfigValue(config, "PROCESSOR_JWT_SECRET", this.jwtProcessor.getSecret());
        ApiHelper.throwIfTrue(secret == null || secret.isEmpty(), ApiHelper.Error.TOKEN_SECRET_REQUIRED);
        String digest = ApiHelper.fixDigest(this.getConfigValue(config, "PROCESSOR_JWT_DIGEST", ""), this.jwtProcessor.getDigest());
        SecretKey secretKey = this.getJwtSecretKey(secret, digest);
        return this.getJwtPayload(ApiAccess.class, secretKey, token);
    }

    @Override
    public SecretKey getJwtSecretKey(String secret, String digest) {
        String keyDigest;
        int keyLength = 0;
        String string = keyDigest = digest != null ? digest.toUpperCase().replace("-", "") : "";
        keyLength = "SHA512".equals(keyDigest) ? 64 : ("SHA384".equals(keyDigest) ? 48 : 32);
        String keySecret = secret;
        if (keySecret.length() < keyLength) {
            keySecret = StringUtils.rightPad((String)keySecret, (int)keyLength, (String)" ");
        }
        byte[] keyBytes = keySecret.getBytes();
        return Keys.hmacShaKeyFor((byte[])keyBytes);
    }

    @Override
    public <T> T getJwtPayload(Class<T> type, SecretKey secretKey, String token) {
        JwtParser jwtParser = Jwts.parser().verifyWith(secretKey).build();
        Object payload = jwtParser.parse((CharSequence)token).getPayload();
        return this.dataMapper.copy(payload, type);
    }

    @Override
    public <T> T getJwtPayload(TypeReference<T> typeRef, SecretKey secretKey, String token) {
        JwtParser jwtParser = Jwts.parser().verifyWith(secretKey).build();
        Object payload = jwtParser.parse((CharSequence)token).getPayload();
        return this.dataMapper.copy(payload, typeRef);
    }

    @Override
    public Message validateSignature(ApiHeader apiHeader, ApiSource apiSource, ApiRequest apiRequest, String signature) {
        Long timestamp = (Long)apiRequest.getHeader(Long.class, apiHeader.getTimestampHeader());
        if (timestamp == null) {
            return ApiHelper.Error.TIMESTAMP_REQUIRED;
        }
        Long[] timespan = this.getTimespan();
        if (timestamp < timespan[0] || timestamp > timespan[1]) {
            return ApiHelper.Error.TIMESTAMP_NOT_VALID;
        }
        String hash = FrameworkUtil.digest(apiSource.getDigest(), apiSource.getSecret() + timestamp);
        return !hash.equals(signature) ? ApiHelper.Error.SIGNATURE_NOT_VALID : null;
    }

    private String getConfigValue(StringMap config, String name, String defaultValue) {
        String value = (String)config.getOrDefault((Object)name, (Object)"");
        if (value.isEmpty()) {
            value = defaultValue;
        }
        return value;
    }

    private Long[] getTimespan() {
        Long now = TimeUtil.currentEpochMillis();
        Long min = now - this.timeSpanMillis;
        Long max = now + this.timeSpanMillis;
        return new Long[]{min, max};
    }

    private String createJwtToken(SecretKey secretKey, Object payload) {
        byte[] content = this.dataMapper.writeAsBytes(payload, 1);
        JwtBuilder builder = Jwts.builder().content(content);
        return builder.signWith((Key)secretKey).compact();
    }

    public static class JwtProcessor
    extends Consumer {
        @Override
        public JwtProcessor setSecret(String secret) {
            super.setSecret(secret);
            return this;
        }

        @Override
        public JwtProcessor setDigest(String digest) {
            super.setDigest(digest);
            return this;
        }

        @Override
        public JwtProcessor setExpiry(Long expiry) {
            super.setExpiry(expiry);
            return this;
        }
    }

    public static class Consumer {
        private String secret;
        private String digest;
        private Long expiry;

        public Consumer setSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Consumer setDigest(String digest) {
            this.digest = digest;
            return this;
        }

        public Consumer setExpiry(Long expiry) {
            this.expiry = expiry;
            return this;
        }

        public String getSecret() {
            return this.secret;
        }

        public String getDigest() {
            return this.digest;
        }

        public Long getExpiry() {
            return this.expiry;
        }
    }
}

