/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiServiceImpl;
import net.ideahut.springboot.api.WebFluxApiService;
import net.ideahut.springboot.util.WebFluxUtil;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class WebFluxApiServiceImpl
extends ApiServiceImpl<WebFluxApiServiceImpl>
implements WebFluxApiService {
    private static final long serialVersionUID = -8699916122973305952L;

    @Override
    public ApiRequest getApiRequest(ServerHttpRequest request, boolean publicMapping) {
        LinkedHashMap<String, List> headers = new LinkedHashMap<String, List>();
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            headers.put((String)entry.getKey(), (List)entry.getValue());
        }
        return new ApiRequest().setHeaders(headers).setPath(request.getPath().pathWithinApplication().value()).setPublicMapping(publicMapping).setRemoteHost(WebFluxUtil.getRemoteHost(request)).setUserAgent(WebFluxUtil.getUserAgent(request));
    }

    @Override
    public ApiAccess getApiAccess(ServerHttpRequest request, boolean publicMapping) {
        ApiRequest apiRequest = this.getApiRequest(request, publicMapping);
        return super.getApiAccess(apiRequest);
    }

    protected WebFluxApiServiceImpl self() {
        return this;
    }
}

