/*
 * Decompiled with CFR 0.152.
 */
package net.ideahut.springboot.api;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import net.ideahut.springboot.api.ApiAccess;
import net.ideahut.springboot.api.ApiRequest;
import net.ideahut.springboot.api.ApiServiceImpl;
import net.ideahut.springboot.api.WebMvcApiService;
import net.ideahut.springboot.util.WebMvcUtil;

public class WebMvcApiServiceImpl
extends ApiServiceImpl<WebMvcApiServiceImpl>
implements WebMvcApiService {
    private static final long serialVersionUID = 1274032075440135410L;

    @Override
    public ApiRequest getApiRequest(HttpServletRequest request, boolean publicMapping) {
        LinkedHashMap headers = new LinkedHashMap();
        Enumeration en = request.getHeaderNames();
        if (en != null) {
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                Enumeration values = request.getHeaders(name);
                if (values == null) continue;
                headers.put(name, Collections.list(values));
            }
        }
        return new ApiRequest().setHeaders(headers).setPath(request.getServletPath()).setPublicMapping(publicMapping).setRemoteHost(WebMvcUtil.getRemoteHost(request)).setUserAgent(WebMvcUtil.getUserAgent(request));
    }

    @Override
    public ApiAccess getApiAccess(HttpServletRequest request, boolean publicMapping) {
        ApiRequest apiRequest = this.getApiRequest(request, publicMapping);
        return super.getApiAccess(apiRequest);
    }

    protected WebMvcApiServiceImpl self() {
        return this;
    }
}

